/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.Map;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;

@Command(name="host", description="Print partitions information which a specific host belongs to")
public class Host
extends NodeToolCmd {
    @Option(title="all nodes", name={"-a", "--all"}, description="Show all nodes partition info")
    private boolean showAll = false;

    @Override
    public void execute(ClusterMonitorMBean proxy) {
        Map<PartitionGroup, Integer> raftGroupMapSlotNum = this.showAll ? proxy.getSlotNumOfAllNode() : proxy.getSlotNumOfCurNode();
        if (raftGroupMapSlotNum == null) {
            Printer.msgPrintln("The cluster is being created.");
            return;
        }
        this.showInfo(raftGroupMapSlotNum);
    }

    private void showInfo(Map<PartitionGroup, Integer> raftGroupMapSlotNum) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%-50s  %20s", "Raft group", "Slot Number"));
        Printer.msgPrintln(builder.toString());
        for (Map.Entry<PartitionGroup, Integer> entry : raftGroupMapSlotNum.entrySet()) {
            builder = new StringBuilder();
            PartitionGroup raftGroup = entry.getKey();
            Integer slotNum = entry.getValue();
            builder.append('(');
            if (!raftGroup.isEmpty()) {
                builder.append(this.nodeToString((Node)raftGroup.get(0)));
            }
            for (int i = 1; i < raftGroup.size(); ++i) {
                builder.append(", ").append(this.nodeToString((Node)raftGroup.get(i)));
            }
            builder.append(')');
            Printer.msgPrintln(String.format("%-50s->%20s", builder, slotNum));
        }
    }
}

