/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.heartbeat;

import java.util.Set;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.heartbeat.HeartbeatThread;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaHeartbeatThread
extends HeartbeatThread {
    private static final Logger logger = LoggerFactory.getLogger(MetaHeartbeatThread.class);
    private MetaGroupMember localMetaMember;

    public MetaHeartbeatThread(MetaGroupMember metaMember) {
        super(metaMember);
        this.localMetaMember = metaMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void presendHeartbeat(Node node) {
        this.request.setRequireIdentifier(!node.isSetNodeIdentifier());
        Set<Node> set = this.localMetaMember.getIdConflictNodes();
        synchronized (set) {
            this.request.unsetRegenerateIdentifier();
            if (this.localMetaMember.getIdConflictNodes().contains(node)) {
                this.request.setRegenerateIdentifier(true);
            }
        }
        if (this.localMetaMember.isNodeBlind(node) && this.localMetaMember.getPartitionTable() != null) {
            logger.debug("Send partition table to {}", (Object)node);
            this.request.setPartitionTableBytes(this.localMetaMember.getPartitionTable().serialize());
            this.localMetaMember.removeBlindNode(node);
        }
    }

    @Override
    void sendHeartbeatSync(Node node) {
        this.presendHeartbeat(node);
        super.sendHeartbeatSync(node);
        this.request.unsetPartitionTableBytes();
    }

    @Override
    void sendHeartbeatAsync(Node node) {
        this.presendHeartbeat(node);
        super.sendHeartbeatAsync(node);
        this.request.unsetPartitionTableBytes();
    }
}

