/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoppedMemberManager {
    private static final Logger logger = LoggerFactory.getLogger(StoppedMemberManager.class);
    private String stoppedMembersFileName = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "removedMembers";
    private static final String REMOVED = "0";
    private static final String RESUMED = "1";
    private Map<Node, DataGroupMember> removedMemberMap = new HashMap<Node, DataGroupMember>();
    private DataGroupMember.Factory memberFactory;
    private Node thisNode;

    StoppedMemberManager(DataGroupMember.Factory memberFactory, Node thisNode) {
        this.memberFactory = memberFactory;
        this.thisNode = thisNode;
        this.recover();
    }

    public synchronized void put(Node header, DataGroupMember dataGroupMember) {
        this.removedMemberMap.put(header, dataGroupMember);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.stoppedMembersFileName, true));){
            StringBuilder builder = new StringBuilder(REMOVED);
            for (Node node : dataGroupMember.getAllNodes()) {
                builder.append(";").append(node.toString());
            }
            writer.write(builder.toString());
            writer.newLine();
        }
        catch (IOException e) {
            logger.error("Cannot record removed member of header {}", (Object)header, (Object)e);
        }
    }

    public synchronized void remove(Node header) {
        this.removedMemberMap.remove(header);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.stoppedMembersFileName, true));){
            writer.write("1;" + header);
            writer.newLine();
        }
        catch (IOException e) {
            logger.error("Cannot record resumed member of header {}", (Object)header, (Object)e);
        }
    }

    public synchronized DataGroupMember get(Node header) {
        return this.removedMemberMap.get(header);
    }

    private void recover() {
        File stoppedMembersFile = new File(this.stoppedMembersFileName);
        if (!stoppedMembersFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.stoppedMembersFileName));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.parseLine(line);
            }
        }
        catch (IOException e) {
            logger.error("Cannot recover members from file", (Throwable)e);
        }
    }

    private void parseLine(String line) {
        if ("".equalsIgnoreCase(line)) {
            return;
        }
        try {
            String[] split = line.split(";");
            String type = split[0];
            if (REMOVED.equalsIgnoreCase(type)) {
                this.parseRemoved(split);
            } else if (RESUMED.equalsIgnoreCase(type)) {
                this.parseResumed(split);
            }
        }
        catch (Exception e) {
            logger.warn("Fail to analyze {}, skipping", (Object)line);
        }
    }

    private void parseRemoved(String[] split) {
        PartitionGroup partitionGroup = new PartitionGroup();
        for (int i = 1; i < split.length; ++i) {
            Node node = ClusterUtils.stringToNode(split[i]);
            partitionGroup.add(node);
        }
        DataGroupMember member = this.memberFactory.create(partitionGroup, this.thisNode);
        member.setReadOnly();
        this.removedMemberMap.put(partitionGroup.getHeader(), member);
    }

    private void parseResumed(String[] split) {
        Node header = ClusterUtils.stringToNode(split[1]);
        this.removedMemberMap.remove(header);
    }
}

