/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.util.ConcurrentModificationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RaftServer
implements RaftService.AsyncIface,
RaftService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(RaftServer.class);
    private static int connectionTimeoutInMS = ClusterDescriptor.getInstance().getConfig().getConnectionTimeoutInMS();
    private static int readOperationTimeoutMS = ClusterDescriptor.getInstance().getConfig().getReadOperationTimeoutMS();
    private static int writeOperationTimeoutMS = ClusterDescriptor.getInstance().getConfig().getWriteOperationTimeoutMS();
    private static int syncLeaderMaxWaitMs = 20000;
    private static long heartBeatIntervalMs = 1000L;
    ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
    private TServerTransport socket;
    private TServer poolServer;
    Node thisNode;
    TProtocolFactory protocolFactory = this.config.isRpcThriftCompressionEnabled() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
    private ExecutorService clientService;

    RaftServer() {
        this.thisNode = new Node();
        this.thisNode.setInternalIp(this.config.getInternalIp());
        this.thisNode.setMetaPort(this.config.getInternalMetaPort());
        this.thisNode.setDataPort(this.config.getInternalDataPort());
        this.thisNode.setClientPort(this.config.getClusterRpcPort());
        this.thisNode.setClientIp(IoTDBDescriptor.getInstance().getConfig().getRpcAddress());
    }

    RaftServer(Node thisNode) {
        this.thisNode = thisNode;
    }

    public static int getConnectionTimeoutInMS() {
        return connectionTimeoutInMS;
    }

    public static void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        RaftServer.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public static int getReadOperationTimeoutMS() {
        return readOperationTimeoutMS;
    }

    public static int getWriteOperationTimeoutMS() {
        return writeOperationTimeoutMS;
    }

    public static int getSyncLeaderMaxWaitMs() {
        return syncLeaderMaxWaitMs;
    }

    public static void setSyncLeaderMaxWaitMs(int syncLeaderMaxWaitMs) {
        RaftServer.syncLeaderMaxWaitMs = syncLeaderMaxWaitMs;
    }

    public static long getHeartBeatIntervalMs() {
        return heartBeatIntervalMs;
    }

    public static void setHeartBeatIntervalMs(long heartBeatIntervalMs) {
        RaftServer.heartBeatIntervalMs = heartBeatIntervalMs;
    }

    public void start() throws TTransportException, StartupException {
        if (this.poolServer != null) {
            return;
        }
        this.establishServer();
    }

    public void stop() {
        if (this.poolServer == null) {
            return;
        }
        try {
            this.poolServer.stop();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        this.socket.close();
        this.clientService.shutdownNow();
        this.socket = null;
        this.poolServer = null;
    }

    abstract TProcessor getProcessor();

    abstract TServerTransport getServerSocket() throws TTransportException;

    abstract String getClientThreadPrefix();

    abstract String getServerClientName();

    private TServer createAsyncServer() throws TTransportException {
        this.socket = this.getServerSocket();
        TThreadedSelectorServer.Args poolArgs = new TThreadedSelectorServer.Args((TNonblockingServerTransport)this.socket);
        poolArgs.maxReadBufferBytes = IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize();
        poolArgs.selectorThreads(CommonUtils.getCpuCores());
        int maxConcurrentClientNum = Math.max(CommonUtils.getCpuCores(), this.config.getMaxConcurrentClientNum());
        poolArgs.executorService((ExecutorService)new ThreadPoolExecutor(CommonUtils.getCpuCores(), maxConcurrentClientNum, (long)poolArgs.getStopTimeoutVal(), poolArgs.getStopTimeoutUnit(), new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicLong threadIndex = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, RaftServer.this.getClientThreadPrefix() + this.threadIndex.incrementAndGet());
            }
        }));
        poolArgs.processor(this.getProcessor());
        poolArgs.protocolFactory(this.protocolFactory);
        poolArgs.transportFactory((TTransportFactory)RpcTransportFactory.INSTANCE);
        return new TThreadedSelectorServer(poolArgs);
    }

    private TServer createSyncServer() throws TTransportException {
        this.socket = this.getServerSocket();
        return ClusterUtils.createTThreadPoolServer(this.socket, this.getClientThreadPrefix(), this.getProcessor(), this.protocolFactory);
    }

    private void establishServer() throws TTransportException {
        logger.info("[{}] Cluster node {} begins to set up with {} mode", new Object[]{this.getServerClientName(), this.thisNode, ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? "Async" : "Sync"});
        this.poolServer = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.createAsyncServer() : this.createSyncServer();
        this.clientService = Executors.newSingleThreadExecutor(r -> new Thread(r, this.getServerClientName()));
        this.clientService.submit(() -> this.poolServer.serve());
        logger.info("[{}] Cluster node {} is up", (Object)this.getServerClientName(), (Object)this.thisNode);
    }

    public static void setReadOperationTimeoutMS(int readOperationTimeoutMS) {
        RaftServer.readOperationTimeoutMS = readOperationTimeoutMS;
    }

    public static void setWriteOperationTimeoutMS(int writeOperationTimeoutMS) {
        RaftServer.writeOperationTimeoutMS = writeOperationTimeoutMS;
    }
}

