/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.exception.ConfigInconsistentException;
import org.apache.iotdb.cluster.exception.StartUpCheckFailureException;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.metadata.MetaPuller;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntriesRequest;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.ExecutNonQueryReq;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RefreshReuqest;
import org.apache.iotdb.cluster.rpc.thrift.RequestCommitIndexResponse;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.heartbeat.MetaHeartbeatServer;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.service.MetaAsyncService;
import org.apache.iotdb.cluster.server.service.MetaSyncService;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.RegisterManager;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaClusterServer
extends RaftServer
implements TSMetaService.AsyncIface,
TSMetaService.Iface {
    private static Logger logger = LoggerFactory.getLogger(MetaClusterServer.class);
    private MetaGroupMember member;
    private Coordinator coordinator;
    private IoTDB ioTDB;
    private RegisterManager registerManager = new RegisterManager();
    private MetaAsyncService asyncService;
    private MetaSyncService syncService;
    private MetaHeartbeatServer metaHeartbeatServer = new MetaHeartbeatServer(this.thisNode, this);

    public MetaClusterServer() throws QueryProcessException {
        this.coordinator = new Coordinator();
        this.member = new MetaGroupMember(this.protocolFactory, this.thisNode, this.coordinator);
        this.coordinator.setMetaGroupMember(this.member);
        this.asyncService = new MetaAsyncService(this.member);
        this.syncService = new MetaSyncService(this.member);
        MetaPuller.getInstance().init(this.member);
    }

    @Override
    public void start() throws TTransportException, StartupException {
        super.start();
        this.metaHeartbeatServer.start();
        this.ioTDB = new IoTDB();
        IoTDB.setMetaManager((MManager)CMManager.getInstance());
        IoTDB.setClusterMode();
        ((CMManager)IoTDB.metaManager).setMetaGroupMember(this.member);
        ((CMManager)IoTDB.metaManager).setCoordinator(this.coordinator);
        this.ioTDB.active();
        this.member.start();
        this.registerManager.register((IService)ClusterMonitor.INSTANCE);
    }

    @Override
    public void stop() {
        if (this.ioTDB == null) {
            return;
        }
        this.metaHeartbeatServer.stop();
        super.stop();
        this.ioTDB.stop();
        this.ioTDB = null;
        this.member.stop();
        this.registerManager.deregisterAll();
    }

    public void buildCluster() throws ConfigInconsistentException, StartUpCheckFailureException {
        this.member.buildCluster();
    }

    public void joinCluster() throws ConfigInconsistentException, StartUpCheckFailureException {
        this.member.joinCluster();
    }

    @Override
    TServerTransport getServerSocket() throws TTransportException {
        logger.info("[{}] Cluster node will listen {}:{}", new Object[]{this.getServerClientName(), this.config.getInternalIp(), this.config.getInternalMetaPort()});
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TNonblockingServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.config.getInternalMetaPort()), MetaClusterServer.getConnectionTimeoutInMS());
        }
        return new TServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.config.getInternalMetaPort()));
    }

    @Override
    String getClientThreadPrefix() {
        return "MetaClientThread-";
    }

    @Override
    String getServerClientName() {
        return "MetaServerThread-";
    }

    @Override
    TProcessor getProcessor() {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TSMetaService.AsyncProcessor((TSMetaService.AsyncIface)this);
        }
        return new TSMetaService.Processor((TSMetaService.Iface)this);
    }

    public void addNode(Node node, StartUpStatus startUpStatus, AsyncMethodCallback resultHandler) {
        this.asyncService.addNode(node, startUpStatus, (AsyncMethodCallback<AddNodeResponse>)resultHandler);
    }

    public void sendHeartbeat(HeartBeatRequest request, AsyncMethodCallback resultHandler) {
        this.asyncService.sendHeartbeat(request, (AsyncMethodCallback<HeartBeatResponse>)resultHandler);
    }

    public void startElection(ElectionRequest electionRequest, AsyncMethodCallback resultHandler) {
        this.asyncService.startElection(electionRequest, (AsyncMethodCallback<Long>)resultHandler);
    }

    public void appendEntries(AppendEntriesRequest request, AsyncMethodCallback resultHandler) {
        this.asyncService.appendEntries(request, (AsyncMethodCallback<Long>)resultHandler);
    }

    public void appendEntry(AppendEntryRequest request, AsyncMethodCallback resultHandler) {
        this.asyncService.appendEntry(request, resultHandler);
    }

    public void sendSnapshot(SendSnapshotRequest request, AsyncMethodCallback resultHandler) {
        this.asyncService.sendSnapshot(request, (AsyncMethodCallback<Void>)resultHandler);
    }

    public void executeNonQueryPlan(ExecutNonQueryReq request, AsyncMethodCallback<TSStatus> resultHandler) {
        this.asyncService.executeNonQueryPlan(request, resultHandler);
    }

    public void refreshConnection(RefreshReuqest request, AsyncMethodCallback<Void> resultHandler) {
        resultHandler.onComplete(null);
    }

    public void requestCommitIndex(Node header, AsyncMethodCallback<RequestCommitIndexResponse> resultHandler) {
        this.asyncService.requestCommitIndex(header, resultHandler);
    }

    public void checkAlive(AsyncMethodCallback<Node> resultHandler) {
        this.asyncService.checkAlive(resultHandler);
    }

    public void readFile(String filePath, long offset, int length, AsyncMethodCallback<ByteBuffer> resultHandler) {
        this.asyncService.readFile(filePath, offset, length, resultHandler);
    }

    public void queryNodeStatus(AsyncMethodCallback<TNodeStatus> resultHandler) {
        this.asyncService.queryNodeStatus(resultHandler);
    }

    public MetaGroupMember getMember() {
        return this.member;
    }

    public void checkStatus(StartUpStatus startUpStatus, AsyncMethodCallback<CheckStatusResponse> resultHandler) {
        this.asyncService.checkStatus(startUpStatus, resultHandler);
    }

    public void removeNode(Node node, AsyncMethodCallback<Long> resultHandler) {
        this.asyncService.removeNode(node, resultHandler);
    }

    public void exile(AsyncMethodCallback<Void> resultHandler) {
        this.asyncService.exile(resultHandler);
    }

    public void matchTerm(long index, long term, Node header, AsyncMethodCallback<Boolean> resultHandler) {
        this.asyncService.matchTerm(index, term, header, resultHandler);
    }

    public AddNodeResponse addNode(Node node, StartUpStatus startUpStatus) throws TException {
        return this.syncService.addNode(node, startUpStatus);
    }

    public CheckStatusResponse checkStatus(StartUpStatus startUpStatus) {
        return this.syncService.checkStatus(startUpStatus);
    }

    public long removeNode(Node node) throws TException {
        return this.syncService.removeNode(node);
    }

    public void exile() {
        this.syncService.exile();
    }

    public TNodeStatus queryNodeStatus() {
        return this.syncService.queryNodeStatus();
    }

    public Node checkAlive() {
        return this.syncService.checkAlive();
    }

    public HeartBeatResponse sendHeartbeat(HeartBeatRequest request) {
        return this.syncService.sendHeartbeat(request);
    }

    public long startElection(ElectionRequest request) {
        return this.syncService.startElection(request);
    }

    public long appendEntries(AppendEntriesRequest request) throws TException {
        return this.syncService.appendEntries(request);
    }

    public long appendEntry(AppendEntryRequest request) throws TException {
        return this.syncService.appendEntry(request);
    }

    public void sendSnapshot(SendSnapshotRequest request) throws TException {
        this.syncService.sendSnapshot(request);
    }

    public TSStatus executeNonQueryPlan(ExecutNonQueryReq request) throws TException {
        return this.syncService.executeNonQueryPlan(request);
    }

    public void refreshConnection(RefreshReuqest request) {
    }

    public RequestCommitIndexResponse requestCommitIndex(Node header) throws TException {
        return this.syncService.requestCommitIndex(header);
    }

    public ByteBuffer readFile(String filePath, long offset, int length) throws TException {
        return this.syncService.readFile(filePath, offset, length);
    }

    public boolean matchTerm(long index, long term, Node header) {
        return this.syncService.matchTerm(index, term, header);
    }

    public void removeHardLink(String hardLinkPath) throws TException {
        this.syncService.removeHardLink(hardLinkPath);
    }

    public void removeHardLink(String hardLinkPath, AsyncMethodCallback<Void> resultHandler) {
        this.asyncService.removeHardLink(hardLinkPath, resultHandler);
    }

    public void handshake(Node sender) {
        this.syncService.handshake(sender);
    }

    public void handshake(Node sender, AsyncMethodCallback<Void> resultHandler) {
        this.asyncService.handshake(sender, resultHandler);
    }
}

