/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.snapshot;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.snapshot.FileSnapshot;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.log.snapshot.SnapshotInstaller;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.entity.Role;
import org.apache.iotdb.db.auth.entity.User;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSimpleSnapshot
extends Snapshot {
    private static final Logger logger = LoggerFactory.getLogger(MetaSimpleSnapshot.class);
    private Map<PartialPath, Long> storageGroupTTLMap;
    private Map<String, User> userMap;
    private Map<String, Role> roleMap;
    private ByteBuffer partitionTableBuffer;

    public MetaSimpleSnapshot() {
        this.storageGroupTTLMap = Collections.emptyMap();
        this.userMap = Collections.emptyMap();
        this.roleMap = Collections.emptyMap();
        this.partitionTableBuffer = null;
    }

    public MetaSimpleSnapshot(Map<PartialPath, Long> storageGroupTTLMap, Map<String, User> userMap, Map<String, Role> roleMap, ByteBuffer partitionTableBuffer) {
        this.storageGroupTTLMap = storageGroupTTLMap;
        this.userMap = userMap;
        this.roleMap = roleMap;
        this.partitionTableBuffer = partitionTableBuffer;
    }

    public Map<PartialPath, Long> getStorageGroupTTLMap() {
        return this.storageGroupTTLMap;
    }

    public Map<String, User> getUserMap() {
        return this.userMap;
    }

    public Map<String, Role> getRoleMap() {
        return this.roleMap;
    }

    public ByteBuffer getPartitionTableBuffer() {
        return this.partitionTableBuffer;
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(this.storageGroupTTLMap.size());
            for (Map.Entry<PartialPath, Long> entry : this.storageGroupTTLMap.entrySet()) {
                SerializeUtils.serialize((String)entry.getKey().getFullPath(), (DataOutputStream)dataOutputStream);
                dataOutputStream.writeLong(entry.getValue());
            }
            dataOutputStream.writeInt(this.userMap.size());
            for (Map.Entry<Object, Long> entry : this.userMap.entrySet()) {
                SerializeUtils.serialize((String)((String)entry.getKey()), (DataOutputStream)dataOutputStream);
                logger.info("A user into snapshot: {}", (Object)entry.getValue());
                dataOutputStream.write(((User)entry.getValue()).serialize().array());
            }
            dataOutputStream.writeInt(this.roleMap.size());
            for (Map.Entry<Object, Long> entry : this.roleMap.entrySet()) {
                SerializeUtils.serialize((String)((String)entry.getKey()), (DataOutputStream)dataOutputStream);
                logger.info("A role into snapshot: {}", (Object)entry.getValue());
                dataOutputStream.write(((Role)entry.getValue()).serialize().array());
            }
            dataOutputStream.writeLong(this.lastLogIndex);
            dataOutputStream.writeLong(this.lastLogTerm);
            dataOutputStream.write(this.partitionTableBuffer.array());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int storageGroupTTLMapSize = buffer.getInt();
        this.storageGroupTTLMap = new HashMap<PartialPath, Long>(storageGroupTTLMapSize);
        for (int i = 0; i < storageGroupTTLMapSize; ++i) {
            try {
                this.storageGroupTTLMap.put(new PartialPath(SerializeUtils.deserializeString((ByteBuffer)buffer)), buffer.getLong());
                continue;
            }
            catch (IllegalPathException illegalPathException) {
                // empty catch block
            }
        }
        int userMapSize = buffer.getInt();
        this.userMap = new HashMap<String, User>(userMapSize);
        for (int i = 0; i < userMapSize; ++i) {
            String userName = SerializeUtils.deserializeString((ByteBuffer)buffer);
            User user = new User();
            user.deserialize(buffer);
            this.userMap.put(userName, user);
        }
        int roleMapSize = buffer.getInt();
        this.roleMap = new HashMap<String, Role>(roleMapSize);
        for (int i = 0; i < roleMapSize; ++i) {
            String userName = SerializeUtils.deserializeString((ByteBuffer)buffer);
            Role role = new Role();
            role.deserialize(buffer);
            this.roleMap.put(userName, role);
        }
        this.setLastLogIndex(buffer.getLong());
        this.setLastLogTerm(buffer.getLong());
        this.partitionTableBuffer = buffer;
    }

    public SnapshotInstaller getDefaultInstaller(RaftMember member) {
        return new Installer((MetaGroupMember)member);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaSimpleSnapshot that = (MetaSimpleSnapshot)o;
        return Objects.equals(this.storageGroupTTLMap, that.storageGroupTTLMap) && Objects.equals(this.userMap, that.userMap) && Objects.equals(this.roleMap, that.roleMap) && Objects.equals(this.partitionTableBuffer, that.partitionTableBuffer);
    }

    public int hashCode() {
        return Objects.hash(this.storageGroupTTLMap, this.userMap, this.roleMap, this.partitionTableBuffer);
    }

    public static class Factory
    implements SnapshotFactory<MetaSimpleSnapshot> {
        public static final FileSnapshot.Factory INSTANCE = new FileSnapshot.Factory();

        @Override
        public MetaSimpleSnapshot create() {
            return new MetaSimpleSnapshot();
        }

        @Override
        public MetaSimpleSnapshot copy(MetaSimpleSnapshot origin) {
            MetaSimpleSnapshot metaSimpleSnapshot = this.create();
            metaSimpleSnapshot.lastLogIndex = origin.lastLogIndex;
            metaSimpleSnapshot.lastLogTerm = origin.lastLogTerm;
            metaSimpleSnapshot.partitionTableBuffer = origin.partitionTableBuffer.duplicate();
            metaSimpleSnapshot.roleMap = new HashMap(origin.roleMap);
            metaSimpleSnapshot.userMap = new HashMap(origin.userMap);
            metaSimpleSnapshot.storageGroupTTLMap = new HashMap(origin.storageGroupTTLMap);
            return metaSimpleSnapshot;
        }
    }

    public static class Installer
    implements SnapshotInstaller<MetaSimpleSnapshot> {
        private static final Logger logger = LoggerFactory.getLogger(Installer.class);
        private MetaGroupMember metaGroupMember;

        public Installer(MetaGroupMember metaGroupMember) {
            this.metaGroupMember = metaGroupMember;
        }

        @Override
        public void install(MetaSimpleSnapshot snapshot, int slot) {
            this.installSnapshot(snapshot);
        }

        @Override
        public void install(Map<Integer, MetaSimpleSnapshot> snapshotMap) {
            throw new UnsupportedOperationException("Method unimplemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void installSnapshot(MetaSimpleSnapshot snapshot) {
            Object object = this.metaGroupMember.getSnapshotApplyLock();
            synchronized (object) {
                for (Map.Entry<PartialPath, Long> entry : snapshot.getStorageGroupTTLMap().entrySet()) {
                    PartialPath sgPath = entry.getKey();
                    try {
                        IoTDB.metaManager.setStorageGroup(sgPath);
                    }
                    catch (StorageGroupAlreadySetException storageGroupAlreadySetException) {
                    }
                    catch (MetadataException e) {
                        logger.error("{}: Cannot add storage group {} in snapshot, errMessage:{}", new Object[]{this.metaGroupMember.getName(), entry.getKey(), e.getMessage()});
                    }
                    try {
                        IoTDB.metaManager.setTTL(sgPath, entry.getValue().longValue());
                        StorageEngine.getInstance().setTTL(sgPath, entry.getValue().longValue());
                    }
                    catch (IOException | MetadataException e) {
                        logger.error("{}: Cannot set ttl in storage group {} , errMessage: {}", new Object[]{this.metaGroupMember.getName(), entry.getKey(), e.getMessage()});
                    }
                }
                try {
                    IAuthorizer authorizer = BasicAuthorizer.getInstance();
                    this.installSnapshotUsers(authorizer, snapshot);
                    this.installSnapshotRoles(authorizer, snapshot);
                }
                catch (AuthException e) {
                    logger.error("{}: Cannot get authorizer instance, error is: ", (Object)this.metaGroupMember.getName(), (Object)e);
                }
                this.metaGroupMember.acceptPartitionTable(snapshot.getPartitionTableBuffer(), true);
                RaftLogManager raftLogManager = this.metaGroupMember.getLogManager();
                synchronized (raftLogManager) {
                    this.metaGroupMember.getLogManager().applySnapshot(snapshot);
                }
            }
        }

        private void installSnapshotUsers(IAuthorizer authorizer, MetaSimpleSnapshot snapshot) {
            try {
                authorizer.replaceAllUsers(snapshot.getUserMap());
            }
            catch (AuthException e) {
                logger.error("{}:replace users failed", (Object)this.metaGroupMember.getName(), (Object)e);
            }
        }

        private void installSnapshotRoles(IAuthorizer authorizer, MetaSimpleSnapshot snapshot) {
            try {
                authorizer.replaceAllRoles(snapshot.getRoleMap());
            }
            catch (AuthException e) {
                logger.error("{}:replace roles failed", (Object)this.metaGroupMember.getName(), (Object)e);
            }
        }
    }
}

