/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.cluster.exception.EntryCompactedException;
import org.apache.iotdb.cluster.exception.EntryUnavailableException;
import org.apache.iotdb.cluster.exception.TruncateCommittedEntryException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.logtypes.EmptyContentLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommittedEntryManager {
    private static final Logger logger = LoggerFactory.getLogger(CommittedEntryManager.class);
    private List<Log> entries;
    private long entryTotalMemSize;

    CommittedEntryManager(int maxNumOfLogInMem) {
        this.entries = Collections.synchronizedList(new ArrayList(maxNumOfLogInMem));
        this.entries.add(new EmptyContentLog(-1L, -1L));
        this.entryTotalMemSize = 0L;
    }

    void applyingSnapshot(Snapshot snapshot) {
        long snapIndex;
        long localIndex = this.getDummyIndex();
        if (localIndex >= (snapIndex = snapshot.getLastLogIndex())) {
            logger.info("requested snapshot is older than the existing snapshot");
            return;
        }
        this.entries.clear();
        this.entries.add(new EmptyContentLog(snapshot.getLastLogIndex(), snapshot.getLastLogTerm()));
    }

    Long getDummyIndex() {
        return this.entries.get(0).getCurrLogIndex();
    }

    Long getFirstIndex() {
        return this.getDummyIndex() + 1L;
    }

    Long getLastIndex() {
        return this.getDummyIndex() + (long)this.entries.size() - 1L;
    }

    int getTotalSize() {
        return this.entries.size() - 1;
    }

    public long maybeTerm(long index) throws EntryCompactedException {
        Log log = this.getEntry(index);
        if (log == null) {
            return -1L;
        }
        return log.getCurrLogTerm();
    }

    public List<Log> getEntries(long low, long high) {
        long lastIndex;
        if (low > high) {
            logger.debug("invalid getEntries: parameter: {} > {}", (Object)low, (Object)high);
            return Collections.emptyList();
        }
        long dummyIndex = this.getDummyIndex();
        if (low <= dummyIndex) {
            logger.debug("entries low ({}) is out of bound dummyIndex ({}), adjust parameter 'low' to {}", new Object[]{low, dummyIndex, dummyIndex});
            low = dummyIndex + 1L;
        }
        if (high > (lastIndex = this.getLastIndex().longValue()) + 1L) {
            logger.debug("entries high ({}) is out of bound lastIndex ({}), adjust parameter 'high' to {}", new Object[]{high, lastIndex, lastIndex});
            high = lastIndex + 1L;
        }
        return this.entries.subList((int)(low - dummyIndex), (int)(high - dummyIndex));
    }

    Log getEntry(long index) throws EntryCompactedException {
        long dummyIndex = this.getDummyIndex();
        if (index < dummyIndex) {
            logger.debug("invalid committedEntryManager getEntry: parameter: index({}) < compactIndex({})", (Object)index, (Object)dummyIndex);
            throw new EntryCompactedException(index, dummyIndex);
        }
        if ((int)(index - dummyIndex) >= this.entries.size()) {
            if (logger.isDebugEnabled()) {
                logger.debug("invalid committedEntryManager getEntry : parameter: index({}) > lastIndex({})", (Object)index, (Object)this.getLastIndex());
            }
            return null;
        }
        return this.entries.get((int)(index - dummyIndex));
    }

    void compactEntries(long compactIndex) throws EntryUnavailableException {
        long dummyIndex = this.getDummyIndex();
        if (compactIndex < dummyIndex) {
            logger.info("entries before request index ({}) have been compacted, and the compactIndex is ({})", (Object)compactIndex, (Object)dummyIndex);
            return;
        }
        if (compactIndex > this.getLastIndex()) {
            logger.info("compact ({}) is out of bound lastIndex ({})", (Object)compactIndex, (Object)this.getLastIndex());
            throw new EntryUnavailableException(compactIndex, this.getLastIndex());
        }
        int index = (int)(compactIndex - dummyIndex);
        for (int i = 1; i <= index; ++i) {
            this.entryTotalMemSize -= this.entries.get(i).getByteSize();
        }
        this.entries.set(0, new EmptyContentLog(this.entries.get(index).getCurrLogIndex(), this.entries.get(index).getCurrLogTerm()));
        this.entries.subList(1, index + 1).clear();
    }

    public void append(List<Log> appendingEntries) throws TruncateCommittedEntryException {
        if (appendingEntries.isEmpty()) {
            return;
        }
        long offset = appendingEntries.get(0).getCurrLogIndex() - this.getDummyIndex();
        if ((long)this.entries.size() - offset == 0L) {
            for (int i = 0; i < appendingEntries.size(); ++i) {
                this.entryTotalMemSize += appendingEntries.get(i).getByteSize();
            }
            this.entries.addAll(appendingEntries);
        } else {
            if ((long)this.entries.size() - offset > 0L) {
                logger.error("committed entries cannot be truncated: current entries:{}, appendingEntries {}", this.entries, appendingEntries);
                throw new TruncateCommittedEntryException(appendingEntries.get(0).getCurrLogIndex(), this.getLastIndex());
            }
            logger.error("missing log entry [last: {}, append at: {}]", (Object)this.getLastIndex(), (Object)appendingEntries.get(0).getCurrLogIndex());
        }
    }

    CommittedEntryManager(List<Log> entries) {
        this.entries = entries;
    }

    List<Log> getAllEntries() {
        return this.entries;
    }

    public long getEntryTotalMemSize() {
        return this.entryTotalMemSize;
    }

    public void setEntryTotalMemSize(long entryTotalMemSize) {
        this.entryTotalMemSize = entryTotalMemSize;
    }

    public int maxLogNumShouldReserve(long maxMemSize) {
        long totalSize = 0L;
        for (int i = this.entries.size() - 1; i >= 1; --i) {
            if (totalSize + this.entries.get(i).getByteSize() > maxMemSize) {
                return this.entries.size() - 1 - i;
            }
            totalSize += this.entries.get(i).getByteSize();
        }
        return this.entries.size() - 1;
    }
}

