/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.sync;

import org.apache.iotdb.cluster.client.sync.SyncClientFactory;
import org.apache.iotdb.cluster.client.sync.SyncClientPool;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SyncDataHeartbeatClient
extends SyncDataClient {
    private SyncDataHeartbeatClient(TProtocolFactory protocolFactory, Node node, SyncClientPool pool) throws TTransportException {
        super(protocolFactory.getProtocol(RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, node.getInternalIp(), node.getDataPort() + 1, RaftServer.getConnectionTimeoutInMS()))));
        this.node = node;
        this.pool = pool;
        this.getInputProtocol().getTransport().open();
    }

    @Override
    public String toString() {
        return "SyncHeartbeatDataClient{node=" + super.getNode() + ",dataHeartbeatPort=" + (super.getNode().getDataPort() + 1) + '}';
    }

    public static class FactorySync
    implements SyncClientFactory {
        private TProtocolFactory protocolFactory;

        public FactorySync(TProtocolFactory protocolFactory) {
            this.protocolFactory = protocolFactory;
        }

        public SyncDataHeartbeatClient getSyncClient(Node node, SyncClientPool pool) throws TTransportException {
            return new SyncDataHeartbeatClient(this.protocolFactory, node, pool);
        }
    }
}

