/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client.async;

import java.io.IOException;
import java.util.Date;
import org.apache.iotdb.cluster.client.async.AsyncClientFactory;
import org.apache.iotdb.cluster.client.async.AsyncClientPool;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.async.TAsyncMethodCall;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMetaClient
extends TSMetaService.AsyncClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncMetaClient.class);
    Node node;
    AsyncClientPool pool;

    public AsyncMetaClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, TNonblockingTransport transport) {
        super(protocolFactory, clientManager, transport);
    }

    public AsyncMetaClient(TProtocolFactory protocolFactory, TAsyncClientManager clientManager, Node node, AsyncClientPool pool) throws IOException {
        super(protocolFactory, clientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)node.getInternalIp(), (int)node.getMetaPort(), (int)RaftServer.getConnectionTimeoutInMS()));
        this.node = node;
        this.pool = pool;
    }

    public void onComplete() {
        super.onComplete();
        if (this.pool != null) {
            this.pool.putClient(this.node, (RaftService.AsyncClient)this);
            this.pool.onComplete(this.node);
        }
    }

    public void onError(Exception e) {
        super.onError(e);
        this.pool.recreateClient(this.node);
        this.pool.onError(this.node);
    }

    public String toString() {
        return "MetaClient{node=" + this.node + '}';
    }

    public void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isReady() {
        if (this.___currentMethod != null) {
            logger.warn("Client {} is running {} and will timeout at {}", new Object[]{((Object)((Object)this)).hashCode(), this.___currentMethod, new Date(this.___currentMethod.getTimeoutTimestamp())});
        }
        return this.___currentMethod == null;
    }

    TAsyncMethodCall<Object> getCurrMethod() {
        return this.___currentMethod;
    }

    public static class FactoryAsync
    extends AsyncClientFactory {
        public FactoryAsync(TProtocolFactory protocolFactory) {
            this.protocolFactory = protocolFactory;
        }

        @Override
        public RaftService.AsyncClient getAsyncClient(Node node, AsyncClientPool pool) throws IOException {
            TAsyncClientManager manager = managers[this.clientCnt.incrementAndGet() % managers.length];
            manager = manager == null ? new TAsyncClientManager() : manager;
            return new AsyncMetaClient(this.protocolFactory, manager, node, pool);
        }
    }
}

