/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster;

import java.io.IOException;
import java.util.HashSet;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.ConfigInconsistentException;
import org.apache.iotdb.cluster.exception.StartUpCheckFailureException;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotStrategy;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.MetaClusterServer;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.conf.IoTDBConfigCheck;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.thrift.TException;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMain {
    private static final Logger logger = LoggerFactory.getLogger(ClusterMain.class);
    private static final String MODE_START = "-s";
    private static final String MODE_ADD = "-a";
    private static final String MODE_REMOVE = "-r";
    private static MetaClusterServer metaServer;

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.error("Usage: <-s|-a|-r> [-D{} <configure folder>] \n-s: start the node as a seed\n-a: start the node as a new node\n-r: remove the node out of the cluster\n", (Object)"IOTDB_CONF");
            return;
        }
        try {
            IoTDBConfigCheck.getInstance().checkConfig();
        }
        catch (IOException e) {
            logger.error("meet error when doing start checking", (Throwable)e);
        }
        IoTDBDescriptor.getInstance().getConfig().setSyncEnable(false);
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(false);
        try {
            ClusterDescriptor.getInstance().replaceHostnameWithIp();
        }
        catch (Exception e) {
            logger.error("replace hostname with ip failed, {}", (Object)e.getMessage());
            return;
        }
        String mode = args[0];
        logger.info("Running mode {}", (Object)mode);
        if (MODE_START.equals(mode)) {
            try {
                metaServer = new MetaClusterServer();
                ClusterMain.startServerCheck();
                metaServer.start();
                metaServer.buildCluster();
            }
            catch (ConfigInconsistentException | StartUpCheckFailureException | StartupException | QueryProcessException | TTransportException e) {
                metaServer.stop();
                logger.error("Fail to start meta server", e);
            }
        } else if (MODE_ADD.equals(mode)) {
            try {
                metaServer = new MetaClusterServer();
                metaServer.start();
                metaServer.joinCluster();
            }
            catch (ConfigInconsistentException | StartUpCheckFailureException | StartupException | QueryProcessException | TTransportException e) {
                metaServer.stop();
                logger.error("Fail to join cluster", e);
            }
        } else if (MODE_REMOVE.equals(mode)) {
            try {
                ClusterMain.doRemoveNode(args);
            }
            catch (IOException e) {
                logger.error("Fail to remove node in cluster", (Throwable)e);
            }
        } else {
            logger.error("Unrecognized mode {}", (Object)mode);
        }
    }

    private static void startServerCheck() throws StartupException {
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        if (config.getReplicationNum() <= 0) {
            String message = String.format("ReplicateNum should be greater than 0 instead of %d.", config.getReplicationNum());
            throw new StartupException(metaServer.getMember().getName(), message);
        }
        int quorum = config.getReplicationNum() / 2 + 1;
        if (config.getSeedNodeUrls().size() < quorum) {
            String message = String.format("Seed number less than quorum, seed number: %s, quorum: %s.", config.getSeedNodeUrls().size(), quorum);
            throw new StartupException(metaServer.getMember().getName(), message);
        }
        HashSet<Node> seedNodes = new HashSet<Node>();
        for (String url : config.getSeedNodeUrls()) {
            Node node = ClusterUtils.parseNode(url);
            if (seedNodes.contains(node)) {
                String message = String.format("SeedNodes must not repeat each other. SeedNodes: %s", config.getSeedNodeUrls());
                throw new StartupException(metaServer.getMember().getName(), message);
            }
            seedNodes.add(node);
        }
        if (!metaServer.getMember().getAllNodes().isEmpty()) {
            if (!metaServer.getMember().getAllNodes().contains(metaServer.getMember().getThisNode())) {
                String message = String.format("All nodes in partitionTables must contains local node in start-server mode. LocalNode: %s, AllNodes: %s", metaServer.getMember().getThisNode(), metaServer.getMember().getAllNodes());
                throw new StartupException(metaServer.getMember().getName(), message);
            }
            return;
        }
        Node localNode = new Node();
        localNode.setInternalIp(config.getInternalIp()).setMetaPort(config.getInternalMetaPort()).setDataPort(config.getInternalDataPort()).setClientPort(config.getClusterRpcPort()).setClientIp(IoTDBDescriptor.getInstance().getConfig().getRpcAddress());
        if (!seedNodes.contains(localNode)) {
            String message = String.format("SeedNodes must contains local node in start-server mode. LocalNode: %s ,SeedNodes: %s", localNode.toString(), config.getSeedNodeUrls());
            throw new StartupException(metaServer.getMember().getName(), message);
        }
    }

    private static void doRemoveNode(String[] args) throws IOException {
        if (args.length != 3) {
            logger.error("Usage: -r <ip> <metaPort>");
            return;
        }
        String ip = args[1];
        int metaPort = Integer.parseInt(args[2]);
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        TCompactProtocol.Factory factory = config.isRpcThriftCompressionEnabled() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
        Node nodeToRemove = new Node();
        nodeToRemove.setInternalIp(ip).setMetaPort(metaPort);
        for (String url : config.getSeedNodeUrls()) {
            Node node = ClusterUtils.parseNode(url);
            if (node == null) continue;
            AsyncMetaClient client = new AsyncMetaClient((TProtocolFactory)factory, new TAsyncClientManager(), node, null);
            Long response = null;
            try {
                logger.info("Start removing node {} with the help of node {}", (Object)nodeToRemove, (Object)node);
                response = SyncClientAdaptor.removeNode(client, nodeToRemove);
            }
            catch (TException e) {
                logger.warn("Cannot send remove node request through {}, try next node", (Object)node);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Cannot send remove node request through {}, try next node", (Object)node);
            }
            if (response == null) continue;
            ClusterMain.handleNodeRemovalResp(response, nodeToRemove);
            return;
        }
    }

    private static void handleNodeRemovalResp(Long response, Node nodeToRemove) {
        if (response == -1L) {
            logger.info("Node {} is successfully removed", (Object)nodeToRemove);
        } else if (response == -9L) {
            logger.error("Cluster size is too small, cannot remove any node");
        } else if (response == -3L) {
            logger.error("Node {} is not found in the cluster, please check", (Object)nodeToRemove);
        } else {
            logger.error("Unexpected response {}", (Object)response);
        }
    }

    public static MetaClusterServer getMetaServer() {
        return metaServer;
    }

    private static void preStartCustomize() {
        SlotPartitionTable.setSlotStrategy(new SlotStrategy(){
            SlotStrategy defaultStrategy = new SlotStrategy.DefaultStrategy();
            int k = 3;

            @Override
            public int calculateSlotByTime(String storageGroupName, long timestamp, int maxSlotNum) {
                int sgSerialNum = this.extractSerialNumInSGName(storageGroupName) % this.k;
                if (sgSerialNum >= 0) {
                    return maxSlotNum / this.k * sgSerialNum;
                }
                return this.defaultStrategy.calculateSlotByTime(storageGroupName, timestamp, maxSlotNum);
            }

            @Override
            public int calculateSlotByPartitionNum(String storageGroupName, long partitionId, int maxSlotNum) {
                int sgSerialNum = this.extractSerialNumInSGName(storageGroupName) % this.k;
                if (sgSerialNum >= 0) {
                    return maxSlotNum / this.k * sgSerialNum;
                }
                return this.defaultStrategy.calculateSlotByPartitionNum(storageGroupName, partitionId, maxSlotNum);
            }

            private int extractSerialNumInSGName(String storageGroupName) {
                String[] s = storageGroupName.split("_");
                if (s.length != 2) {
                    return -1;
                }
                try {
                    return Integer.parseInt(s[1]);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        });
    }
}

