/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterFileFlushPolicy
implements TsFileFlushPolicy {
    private static final Logger logger = LoggerFactory.getLogger(ClusterFileFlushPolicy.class);
    private ExecutorService closePartitionExecutor;
    private MetaGroupMember metaGroupMember;

    public ClusterFileFlushPolicy(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
        this.closePartitionExecutor = new ThreadPoolExecutor(16, 1024, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), r -> {
            Thread thread = new Thread(r);
            thread.setName("ClusterFileFlushPolicy-" + thread.getId());
            return thread;
        });
    }

    public void apply(StorageGroupProcessor storageGroupProcessor, TsFileProcessor processor, boolean isSeq) {
        logger.info("The memtable size reaches the threshold, async flush it to tsfile: {}", (Object)processor.getTsFileResource().getTsFile().getAbsolutePath());
        if (processor.shouldClose()) {
            this.closePartitionExecutor.submit(() -> this.metaGroupMember.closePartition(storageGroupProcessor.getVirtualStorageGroupId(), processor.getTimeRangeId(), isSeq));
        }
        processor.asyncFlush();
    }
}

