/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.ByteBuffer;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBNonAlignJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;

public class IoTDBStatement
implements Statement {
    ZoneId zoneId;
    private ResultSet resultSet = null;
    private IoTDBConnection connection;
    private int fetchSize;
    private int queryTimeout;
    protected TSIService.Iface client;
    private List<String> batchSQLList;
    private static final String NOT_SUPPORT_EXECUTE = "Not support execute";
    private static final String NOT_SUPPORT_EXECUTE_UPDATE = "Not support executeUpdate";
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private SQLWarning warningChain = null;
    private long sessionId;
    private long stmtId = -1L;
    private long queryId = -1L;

    IoTDBStatement(IoTDBConnection connection, TSIService.Iface client, long sessionId, int fetchSize, ZoneId zoneId, int seconds) throws SQLException {
        this.connection = connection;
        this.client = client;
        this.sessionId = sessionId;
        this.fetchSize = fetchSize;
        this.batchSQLList = new ArrayList<String>();
        this.zoneId = zoneId;
        this.queryTimeout = seconds;
        this.requestStmtId();
    }

    IoTDBStatement(IoTDBConnection connection, TSIService.Iface client, long sessionId, ZoneId zoneId, int seconds, long statementId) {
        this.connection = connection;
        this.client = client;
        this.sessionId = sessionId;
        this.fetchSize = 5000;
        this.batchSQLList = new ArrayList<String>();
        this.zoneId = zoneId;
        this.queryTimeout = seconds;
        this.stmtId = statementId;
    }

    IoTDBStatement(IoTDBConnection connection, TSIService.Iface client, long sessionId, ZoneId zoneId) throws SQLException {
        this(connection, client, sessionId, 5000, zoneId, 0);
    }

    IoTDBStatement(IoTDBConnection connection, TSIService.Iface client, long sessionId, ZoneId zoneId, int seconds) throws SQLException {
        this(connection, client, sessionId, 5000, zoneId, seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public void addBatch(String sql) {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.queryId != -1L) {
                TSCancelOperationReq closeReq = new TSCancelOperationReq(this.sessionId, this.queryId);
                TSStatus closeResp = this.client.cancelOperation(closeReq);
                RpcUtils.verifySuccess((TSStatus)closeResp);
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when canceling statement.", e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.clear();
    }

    @Override
    public void clearWarnings() {
        this.warningChain = null;
    }

    private void closeClientOperation() throws SQLException {
        try {
            if (this.stmtId != -1L) {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.sessionId);
                closeReq.setStatementId(this.stmtId);
                TSStatus closeResp = this.client.closeOperation(closeReq);
                RpcUtils.verifySuccess((TSStatus)closeResp);
                this.stmtId = -1L;
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when closing statement.", e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Not support closeOnCompletion");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkConnection("execute");
        this.isClosed = false;
        try {
            return this.executeSQL(sql);
        }
        catch (TException e) {
            if (this.reConnect()) {
                throw new SQLException(String.format("Fail to execute %s", sql), e);
            }
            throw new SQLException(String.format("Fail to reconnect to server when executing %s. please check server status", sql), e);
        }
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE);
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE);
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE);
    }

    private boolean executeSQL(String sql) throws TException, SQLException {
        this.isCancelled = false;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.stmtId);
        execReq.setFetchSize(this.fetchSize);
        execReq.setTimeout((long)this.queryTimeout * 1000L);
        TSExecuteStatementResp execResp = this.client.executeStatement(execReq);
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        this.deepCopyResp(execResp);
        if (execResp.isSetColumns()) {
            this.queryId = execResp.getQueryId();
            this.resultSet = execResp.queryDataSet == null ? new IoTDBNonAlignJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.nonAlignQueryDataSet, execReq.timeout) : new IoTDBJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.queryDataSet, execReq.timeout);
            return true;
        }
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkConnection("executeBatch");
        this.isClosed = false;
        try {
            return this.executeBatchSQL();
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeBatchSQL();
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute batch sqls after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when executing batch sqls. please check server status", e);
        }
    }

    private int[] executeBatchSQL() throws TException, BatchUpdateException {
        this.isCancelled = false;
        TSExecuteBatchStatementReq execReq = new TSExecuteBatchStatementReq(this.sessionId, this.batchSQLList);
        TSStatus execResp = this.client.executeBatchStatement(execReq);
        int[] result = new int[this.batchSQLList.size()];
        boolean allSuccess = true;
        StringBuilder message = new StringBuilder("\n");
        for (int i = 0; i < result.length; ++i) {
            if (execResp.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                result[i] = ((TSStatus)execResp.getSubStatus().get((int)i)).code;
                if (result[i] == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result[i] == TSStatusCode.NEED_REDIRECTION.getStatusCode()) continue;
                allSuccess = false;
                message.append(((TSStatus)execResp.getSubStatus().get((int)i)).message + " for SQL: \"" + this.batchSQLList.get(i) + "\"\n");
                continue;
            }
            allSuccess = allSuccess && (execResp.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || execResp.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode());
            result[i] = execResp.getCode();
            message.setLength(0);
            message.append(execResp.getMessage());
        }
        if (!allSuccess) {
            throw new BatchUpdateException(message.toString(), result);
        }
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, (long)this.queryTimeout * 1000L);
    }

    public ResultSet executeQuery(String sql, long timeoutInMS) throws SQLException {
        this.checkConnection("execute query");
        if (timeoutInMS < 0L) {
            throw new SQLException("Timeout must be >= 0, please check and try again.");
        }
        this.isClosed = false;
        try {
            return this.executeQuerySQL(sql, timeoutInMS);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeQuerySQL(sql, timeoutInMS);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to executeQuery " + sql + "after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when execute query " + sql + ". please check server status", e);
        }
    }

    private ResultSet executeQuerySQL(String sql, long timeoutInMS) throws TException, SQLException {
        this.isCancelled = false;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.stmtId);
        execReq.setFetchSize(this.fetchSize);
        execReq.setTimeout(timeoutInMS);
        TSExecuteStatementResp execResp = this.client.executeQueryStatement(execReq);
        this.queryId = execResp.getQueryId();
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        this.deepCopyResp(execResp);
        this.resultSet = execResp.queryDataSet == null ? new IoTDBNonAlignJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.nonAlignQueryDataSet, execReq.timeout) : new IoTDBJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.queryDataSet, execReq.timeout);
        return this.resultSet;
    }

    private void deepCopyResp(TSExecuteStatementResp queryRes) {
        TSQueryDataSet tsQueryDataSet = queryRes.getQueryDataSet();
        TSQueryNonAlignDataSet nonAlignDataSet = queryRes.getNonAlignQueryDataSet();
        if (Objects.nonNull(tsQueryDataSet)) {
            this.deepCopyTsQueryDataSet(tsQueryDataSet);
        } else {
            this.deepCopyNonAlignQueryDataSet(nonAlignDataSet);
        }
    }

    private void deepCopyNonAlignQueryDataSet(TSQueryNonAlignDataSet nonAlignDataSet) {
        if (Objects.isNull(nonAlignDataSet)) {
            return;
        }
        List valueList = nonAlignDataSet.valueList.stream().map(ReadWriteIOUtils::clone).collect(Collectors.toList());
        List timeList = nonAlignDataSet.timeList.stream().map(ReadWriteIOUtils::clone).collect(Collectors.toList());
        nonAlignDataSet.setTimeList(timeList);
        nonAlignDataSet.setValueList(valueList);
    }

    private void deepCopyTsQueryDataSet(TSQueryDataSet tsQueryDataSet) {
        ByteBuffer time = ReadWriteIOUtils.clone((ByteBuffer)tsQueryDataSet.time);
        List valueList = tsQueryDataSet.valueList.stream().map(ReadWriteIOUtils::clone).collect(Collectors.toList());
        List bitmapList = tsQueryDataSet.bitmapList.stream().map(ReadWriteIOUtils::clone).collect(Collectors.toList());
        tsQueryDataSet.setBitmapList(bitmapList);
        tsQueryDataSet.setValueList(valueList);
        tsQueryDataSet.setTime(time);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkConnection("execute update");
        this.isClosed = false;
        try {
            return this.executeUpdateSQL(sql);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeUpdateSQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute update " + sql + "after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when execute update " + sql + ". please check server status", e);
        }
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE_UPDATE);
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE_UPDATE);
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE_UPDATE);
    }

    private int executeUpdateSQL(String sql) throws TException, IoTDBSQLException {
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.stmtId);
        TSExecuteStatementResp execResp = this.client.executeUpdateStatement(execReq);
        if (execResp.isSetQueryId()) {
            this.queryId = execResp.getQueryId();
        }
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        return 0;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException(String.format("direction %d is not supported!", direction));
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.checkConnection("setFetchSize");
        if (fetchSize < 0) {
            throw new SQLException(String.format("fetchSize %d must be >= 0!", fetchSize));
        }
        this.fetchSize = fetchSize == 0 ? 5000 : fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not support getGeneratedKeys");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Not support getMaxFieldSize");
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new SQLException("Not support getMaxFieldSize");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new SQLException("Not support getMaxRows");
    }

    @Override
    public void setMaxRows(int num) throws SQLException {
        throw new SQLException("Not support getMaxRows. Please use the LIMIT clause in a query instead.");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException("Not support getMoreResults");
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new SQLException("Not support getMoreResults");
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkConnection("setQueryTimeout");
        if (seconds < 0) {
            throw new SQLException(String.format("queryTimeout %d must be >= 0!", seconds));
        }
        this.queryTimeout = seconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Not support getResultSetConcurrency");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Not support getResultSetHoldability");
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() {
        return -1;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warningChain;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Not support isCloseOnCompletion");
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Not support isPoolable");
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new SQLException("Not support setPoolable");
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new SQLException("Not support setCursorName");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException("Not support setEscapeProcessing");
    }

    private void checkConnection(String action) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException(String.format("Cannot %s after connection has been closed!", action));
        }
    }

    private void reInit() {
        this.client = this.connection.getClient();
        this.sessionId = this.connection.getSessionId();
    }

    private void requestStmtId() throws SQLException {
        try {
            this.stmtId = this.client.requestStatementId(this.sessionId);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    this.stmtId = this.client.requestStatementId(this.sessionId);
                }
                catch (TException e2) {
                    throw new SQLException("Cannot get id for statement after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Cannot get id for statement after reconnecting. please check server status", e);
        }
    }

    private boolean reConnect() {
        boolean flag = this.connection.reconnect();
        this.reInit();
        return flag;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getStmtId() {
        return this.stmtId;
    }
}

