<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
    
        http://www.apache.org/licenses/LICENSE-2.0
    
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# 成为Committer

Apache IoTDB [Committer](https://www.apache.org/foundation/how-it-works.html#committers) 拥有代码库的写权限，可以合并PR，但是您不必成为代码贡献者才能成为Committer。成为一个Committer意味着你获得了项目的信任。阅读[ASF文档](https://www.apache.org/dev/committers.html#committer-responsibilities) 以获取有关成为Apache Software Foundation中的提交者的更多信息。

项目管理委员会 [PMC](https://www.apache.org/foundation/how-it-works.html#pmc-members) 通过提名、讨论、并投票（且多数人投赞成票）来将某人增选为Committer。我们会使用尽可能多的数据来源来解释为什么增选某人。例如：

- IoTDB技术专家且是布道者（贡献文档、博客等）
- 公开活动
- PMC推荐

对于想成为Committer的贡献者，PMC制定了以下的指导准则

## Apache IoTDB Committer

### 采取多种形式

除了贡献代码之外，还有许多其他形式可以提高我们对贡献者的信任，例如代码审查，设计讨论，为其他用户提供支持，发展社区，改善IoTDB基础设施，文档，项目管理等。

### 知道、支持并不断强化Apache Software Foundation的行为准则

请参阅[ASF文档](https://www.apache.org/foundation/policies/conduct.html)。特别是，他们显然致力于：

- 开放
- 善解人意
- 热情
- 友善
- 有耐心
- 团队协作力强
- 好奇心强
- 注意言行

### 知道、支持并不断强化作为Apache Software Foundation提交者的职责

请参阅[ASF文档](https://www.apache.org/dev/committers.html#committer-responsibilities)。

- 他们帮助创造的是一个产品，而不仅仅是某个贡献者的兴趣
- 他们维护Apache社区的健康，并帮助社区成长
- 他们帮忙做一些周边工作，例如维护网站、维护文档。
- 他们帮助用户
- 可以信任他们来决定何时准备发布代码，或何时需要别人一起做出判断。
- 可以信任他们来决定何时合并代码（如果是代码贡献者），或何时需要别人一起做出判断。

### 知道、支持并不断强化IoTDB社区的实践

- 他们对项目有坚定的承诺
- 他们与社区分享他们的想法
- 他们接受社区反馈并将其整合到他们的计划，设计，代码等中。
- 他们认真地尝试通过贡献使IoTDB更好
- 特别是，如果代码贡献者：
  - 他们认真尝试用自己的代码使IoTDB更好
  - 他们认真地尝试通过代码审查使IoTDB更好
  - 他们接受并整合有关其代码的反馈
  - 他们在查看/合并代码（样式，文档，测试，向后兼容性等）时了解、遵守并不断优化IoTDB的最佳实践。



这个指导文档修改于[Apache Beam](https://beam.apache.org/contribute/become-a-committer/)