/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.iotdb.cluster.ClusterMain;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.MetaClusterServer;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMonitor
implements ClusterMonitorMBean,
IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMonitor.class);
    public static final ClusterMonitor INSTANCE = new ClusterMonitor();
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());

    public void start() throws StartupException {
        try {
            JMXService.registerMBean((Object)INSTANCE, (String)this.mbeanName);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to start %s because of %s", this.getID().getName(), e.getMessage());
            throw new StartupException(errorMessage);
        }
    }

    @Override
    public List<Node> getRing() {
        PartitionTable partitionTable = this.getPartitionTable();
        return partitionTable != null ? partitionTable.getAllNodes() : null;
    }

    @Override
    public MultiKeyMap<Long, PartitionGroup> getDataPartition(String path, long startTime, long endTime) {
        PartitionTable partitionTable = this.getPartitionTable();
        if (partitionTable == null) {
            return null;
        }
        try {
            return partitionTable.partitionByPathRangeTime(new PartialPath(path), startTime, endTime);
        }
        catch (MetadataException e) {
            LOGGER.error("The storage group of path {} doesn't exist.", (Object)path, (Object)e);
            return new MultiKeyMap();
        }
    }

    @Override
    public PartitionGroup getMetaPartition(String path) {
        PartitionTable partitionTable = this.getPartitionTable();
        if (partitionTable == null) {
            return null;
        }
        try {
            return partitionTable.partitionByPathTime(new PartialPath(path), 0L);
        }
        catch (MetadataException e) {
            LOGGER.error("The storage group of path {} doesn't exist.", (Object)path, (Object)e);
            return new PartitionGroup();
        }
    }

    @Override
    public Map<PartitionGroup, Integer> getSlotNumOfCurNode() {
        PartitionTable partitionTable = this.getPartitionTable();
        if (partitionTable == null || partitionTable.getLocalGroups() == null) {
            return null;
        }
        List<PartitionGroup> localGroups = partitionTable.getLocalGroups();
        Map<Node, List<Integer>> nodeSlotMap = ((SlotPartitionTable)partitionTable).getAllNodeSlots();
        HashMap<PartitionGroup, Integer> raftGroupMapSlotNum = new HashMap<PartitionGroup, Integer>();
        for (PartitionGroup group : localGroups) {
            raftGroupMapSlotNum.put(group, nodeSlotMap.get(group.getHeader()).size());
        }
        return raftGroupMapSlotNum;
    }

    @Override
    public Map<PartitionGroup, Integer> getSlotNumOfAllNode() {
        PartitionTable partitionTable = this.getPartitionTable();
        if (partitionTable == null) {
            return null;
        }
        List<Node> allNodes = partitionTable.getAllNodes();
        Map<Node, List<Integer>> nodeSlotMap = ((SlotPartitionTable)partitionTable).getAllNodeSlots();
        HashMap<PartitionGroup, Integer> raftGroupMapSlotNum = new HashMap<PartitionGroup, Integer>();
        for (Node header : allNodes) {
            raftGroupMapSlotNum.put(partitionTable.getHeaderGroup(header), nodeSlotMap.get(header).size());
        }
        return raftGroupMapSlotNum;
    }

    @Override
    public Map<Node, Boolean> getAllNodeStatus() {
        MetaGroupMember metaGroupMember = this.getMetaGroupMember();
        if (metaGroupMember == null) {
            return null;
        }
        return metaGroupMember.getAllNodeStatus();
    }

    private MetaGroupMember getMetaGroupMember() {
        MetaClusterServer metaClusterServer = ClusterMain.getMetaServer();
        if (metaClusterServer == null) {
            return null;
        }
        return metaClusterServer.getMember();
    }

    private PartitionTable getPartitionTable() {
        MetaGroupMember metaGroupMember = this.getMetaGroupMember();
        if (metaGroupMember == null) {
            return null;
        }
        return metaGroupMember.getPartitionTable();
    }

    public void stop() {
        JMXService.deregisterMBean((String)this.mbeanName);
    }

    public ServiceType getID() {
        return ServiceType.CLUSTER_MONITOR_SERVICE;
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    @Override
    public String getInstrumentingInfo() {
        return Timer.getReport();
    }

    @Override
    public void resetInstrumenting() {
        Timer.Statistic.resetAll();
    }
}

