/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.applier;

import java.util.Collections;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.query.ClusterPlanExecutor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.metadata.UndefinedTemplateException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.BatchPlan;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseApplier
implements LogApplier {
    private static final Logger logger = LoggerFactory.getLogger(BaseApplier.class);
    MetaGroupMember metaGroupMember;
    private PlanExecutor queryExecutor;

    BaseApplier(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    void applyPhysicalPlan(PhysicalPlan plan, DataGroupMember dataGroupMember) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        if (plan instanceof InsertPlan) {
            this.processPlanWithTolerance((InsertPlan)plan, dataGroupMember);
        } else if (plan != null && !plan.isQuery()) {
            try {
                this.getQueryExecutor().processNonQuery(plan);
            }
            catch (BatchProcessException e) {
                this.handleBatchProcessException(e, plan);
            }
            catch (QueryProcessException e) {
                if (e.getCause() instanceof StorageGroupNotSetException || e.getCause() instanceof UndefinedTemplateException) {
                    this.executeAfterSync(plan);
                }
                throw e;
            }
            catch (StorageGroupNotSetException e) {
                this.executeAfterSync(plan);
            }
        } else if (plan != null) {
            logger.error("Unsupported physical plan: {}", (Object)plan);
        }
    }

    private void handleBatchProcessException(BatchProcessException e, PhysicalPlan plan) throws QueryProcessException, StorageEngineException, StorageGroupNotSetException {
        TSStatus[] failingStatus = e.getFailingStatus();
        boolean needThrow = false;
        for (int i = 0; i < failingStatus.length; ++i) {
            TSStatus status = failingStatus[i];
            if (status != null && status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && plan instanceof BatchPlan) {
                ((BatchPlan)plan).setIsExecuted(i);
            }
            if (!(plan instanceof DeleteTimeSeriesPlan) || status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            if (status.getCode() == TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode()) {
                logger.info("{} doesn't exist, it may has been deleted.", plan.getPaths().get(i));
                continue;
            }
            needThrow = true;
        }
        boolean needRetry = false;
        int failingStatusLength = failingStatus.length;
        for (int i = 0; i < failingStatusLength; ++i) {
            TSStatus status = failingStatus[i];
            if (status == null || status.getCode() != TSStatusCode.METADATA_ERROR.getStatusCode() || !(plan instanceof BatchPlan)) continue;
            ((BatchPlan)plan).unsetIsExecuted(i);
            needRetry = true;
        }
        if (needRetry) {
            this.executeAfterSync(plan);
            return;
        }
        if (!(plan instanceof DeleteTimeSeriesPlan) || needThrow) {
            throw e;
        }
    }

    private void executeAfterSync(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(true);
        }
        catch (CheckConsistencyException ce) {
            throw new QueryProcessException(ce.getMessage());
        }
        this.getQueryExecutor().processNonQuery(plan);
    }

    private void processPlanWithTolerance(InsertPlan plan, DataGroupMember dataGroupMember) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        try {
            this.getQueryExecutor().processNonQuery((PhysicalPlan)plan);
        }
        catch (StorageEngineException | StorageGroupNotSetException | QueryProcessException e) {
            Throwable metaMissingException = SchemaUtils.findMetaMissingException((Throwable)e);
            boolean causedByPathNotExist = metaMissingException instanceof PathNotExistException;
            if (causedByPathNotExist) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Timeseries is not found locally[{}], try pulling it from another group: {}", (Object)this.metaGroupMember.getName(), (Object)e.getCause().getMessage());
                }
                this.pullTimeseriesSchema(plan, dataGroupMember.getHeader());
                plan.recoverFromFailure();
                this.getQueryExecutor().processNonQuery((PhysicalPlan)plan);
            }
            throw e;
        }
    }

    private void pullTimeseriesSchema(InsertPlan plan, Node ignoredGroup) throws QueryProcessException {
        try {
            PartialPath path = plan.getDeviceId();
            ((CMManager)IoTDB.metaManager).pullTimeSeriesSchemas(Collections.singletonList(path), ignoredGroup);
        }
        catch (MetadataException e1) {
            throw new QueryProcessException((IoTDBException)e1);
        }
    }

    private PlanExecutor getQueryExecutor() throws QueryProcessException {
        if (this.queryExecutor == null) {
            this.queryExecutor = new ClusterPlanExecutor(this.metaGroupMember);
        }
        return this.queryExecutor;
    }
}

