/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.series;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;

public class FileSeriesReaderByTimestamp {
    protected IChunkLoader chunkLoader;
    protected List<ChunkMetadata> chunkMetadataList;
    private int currentChunkIndex = 0;
    private ChunkReader chunkReader;
    private long currentTimestamp;
    private BatchData data = null;

    public FileSeriesReaderByTimestamp(IChunkLoader chunkLoader, List<ChunkMetadata> chunkMetadataList) {
        this.chunkLoader = chunkLoader;
        this.chunkMetadataList = chunkMetadataList;
        this.currentTimestamp = Long.MIN_VALUE;
    }

    public TSDataType getDataType() {
        return this.chunkMetadataList.get(0).getDataType();
    }

    public Object getValueInTimestamp(long timestamp) throws IOException {
        this.currentTimestamp = timestamp;
        if (this.chunkReader == null) {
            if (!this.constructNextSatisfiedChunkReader()) {
                return null;
            }
            if (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
            } else {
                return null;
            }
        }
        while (this.data != null) {
            while (this.data.hasCurrent() && this.data.currentTime() < timestamp) {
                this.data.next();
            }
            if (this.data.hasCurrent()) {
                if (this.data.currentTime() == timestamp) {
                    Object value = this.data.currentValue();
                    this.data.next();
                    return value;
                }
                return null;
            }
            if (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
                continue;
            }
            if (this.constructNextSatisfiedChunkReader()) continue;
            return null;
        }
        return null;
    }

    public boolean hasNext() throws IOException {
        if (this.chunkReader != null) {
            if (this.data != null && this.data.hasCurrent()) {
                return true;
            }
            while (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
                if (this.data == null || !this.data.hasCurrent()) continue;
                return true;
            }
        }
        while (this.constructNextSatisfiedChunkReader()) {
            while (this.chunkReader.hasNextSatisfiedPage()) {
                this.data = this.chunkReader.nextPageData();
                if (this.data == null || !this.data.hasCurrent()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean constructNextSatisfiedChunkReader() throws IOException {
        while (this.currentChunkIndex < this.chunkMetadataList.size()) {
            ChunkMetadata chunkMetaData;
            if (!this.chunkSatisfied(chunkMetaData = this.chunkMetadataList.get(this.currentChunkIndex++))) continue;
            this.initChunkReader(chunkMetaData);
            ((ChunkReaderByTimestamp)this.chunkReader).setCurrentTimestamp(this.currentTimestamp);
            return true;
        }
        return false;
    }

    private void initChunkReader(ChunkMetadata chunkMetaData) throws IOException {
        Chunk chunk = this.chunkLoader.loadChunk(chunkMetaData);
        this.chunkReader = new ChunkReaderByTimestamp(chunk);
    }

    private boolean chunkSatisfied(ChunkMetadata chunkMetaData) {
        return chunkMetaData.getEndTime() >= this.currentTimestamp;
    }
}

