/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.recover;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.sync.receiver.recover.ISyncReceiverLogger;

public class SyncReceiverLogger
implements ISyncReceiverLogger {
    private BufferedWriter bw;

    public SyncReceiverLogger(File logFile) throws IOException {
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        this.bw = new BufferedWriter(new FileWriter(logFile));
    }

    @Override
    public void startSyncDeletedFilesName() throws IOException {
        this.bw.write("sync deleted file names start");
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void finishSyncDeletedFileName(File file) throws IOException {
        this.bw.write(file.getAbsolutePath());
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void startSyncTsFiles() throws IOException {
        this.bw.write("sync tsfile start");
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void finishSyncTsfile(File file) throws IOException {
        this.bw.write(file.getAbsolutePath());
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.bw != null) {
            this.bw.close();
            this.bw = null;
        }
    }
}

