/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemTableManager {
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(MemTableManager.class);
    private static final int WAIT_TIME = 100;
    public static final int MEMTABLE_NUM_FOR_EACH_PARTITION = 4;
    private int currentMemtableNumber = 0;

    private MemTableManager() {
    }

    public static MemTableManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public synchronized IMemTable getAvailableMemTable(String storageGroup) throws WriteProcessException {
        if (!this.reachMaxMemtableNumber()) {
            ++this.currentMemtableNumber;
            return new PrimitiveMemTable();
        }
        int waitCount = 1;
        while (true) {
            if (!this.reachMaxMemtableNumber()) {
                ++this.currentMemtableNumber;
                return new PrimitiveMemTable();
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                logger.error("{} fails to wait for memtables {}, continue to wait", (Object)storageGroup, (Object)e);
                Thread.currentThread().interrupt();
                throw new WriteProcessException(e);
            }
            if (waitCount++ % 10 != 0) continue;
            logger.info("{} has waited for a memtable for {}ms", (Object)storageGroup, (Object)(waitCount * 100));
        }
    }

    public int getCurrentMemtableNumber() {
        return this.currentMemtableNumber;
    }

    public synchronized void addMemtableNumber() {
        ++this.currentMemtableNumber;
    }

    public synchronized void decreaseMemtableNumber() {
        --this.currentMemtableNumber;
        this.notifyAll();
    }

    private boolean reachMaxMemtableNumber() {
        return this.currentMemtableNumber >= CONFIG.getMaxMemtableNumber();
    }

    public synchronized void addOrDeleteStorageGroup(int diff) {
        int maxMemTableNum = CONFIG.getMaxMemtableNumber();
        CONFIG.setMaxMemtableNumber(maxMemTableNum += 4 * CONFIG.getConcurrentWritingTimePartition() * diff);
        this.notifyAll();
    }

    public synchronized void close() {
        this.currentMemtableNumber = 0;
    }

    private static class InstanceHolder {
        private static final MemTableManager INSTANCE = new MemTableManager();

        private InstanceHolder() {
        }
    }
}

