/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.executor;

import java.time.ZoneId;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.core.context.UDFContext;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;

public class UDTFExecutor {
    protected final UDFContext context;
    protected final UDTFConfigurations configurations;
    protected UDTF udtf;
    protected ElasticSerializableTVList collector;

    public UDTFExecutor(UDFContext context, ZoneId zoneId) {
        this.context = context;
        this.configurations = new UDTFConfigurations(zoneId);
    }

    public void beforeStart(long queryId, float collectorMemoryBudgetInMB) throws QueryProcessException {
        this.udtf = (UDTF)UDFRegistrationService.getInstance().reflect(this.context);
        UDFParameters parameters = new UDFParameters(this.context.getPaths(), this.context.getAttributes());
        try {
            this.udtf.validate(new UDFParameterValidator(parameters));
        }
        catch (Exception e) {
            this.onError("validate(UDFParameterValidator)", e);
        }
        try {
            this.udtf.beforeStart(parameters, this.configurations);
        }
        catch (Exception e) {
            this.onError("beforeStart(UDFParameters, UDTFConfigurations)", e);
        }
        this.configurations.check();
        this.collector = ElasticSerializableTVList.newElasticSerializableTVList(this.configurations.getOutputDataType(), queryId, collectorMemoryBudgetInMB, 1);
    }

    public void execute(Row row) throws QueryProcessException {
        try {
            this.udtf.transform(row, (PointCollector)this.collector);
        }
        catch (Exception e) {
            this.onError("transform(Row, PointCollector)", e);
        }
    }

    public void execute(RowWindow rowWindow) throws QueryProcessException {
        try {
            this.udtf.transform(rowWindow, (PointCollector)this.collector);
        }
        catch (Exception e) {
            this.onError("transform(RowWindow, PointCollector)", e);
        }
    }

    public void terminate() throws QueryProcessException {
        try {
            this.udtf.terminate(this.collector);
        }
        catch (Exception e) {
            this.onError("terminate(PointCollector)", e);
        }
    }

    public void beforeDestroy() {
        this.udtf.beforeDestroy();
    }

    private void onError(String methodName, Exception e) throws QueryProcessException {
        throw new QueryProcessException(String.format("Error occurred during executing UDTF#%s: %s", methodName, System.lineSeparator()) + e);
    }

    public UDFContext getContext() {
        return this.context;
    }

    public UDTFConfigurations getConfigurations() {
        return this.configurations;
    }

    public ElasticSerializableTVList getCollector() {
        return this.collector;
    }
}

