/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.input.InputLayer;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.transformer.RawQueryPointTransformer;
import org.apache.iotdb.db.query.udf.core.transformer.Transformer;
import org.apache.iotdb.db.query.udf.core.transformer.UDFQueryRowTransformer;
import org.apache.iotdb.db.query.udf.core.transformer.UDFQueryRowWindowTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public abstract class UDTFDataSet
extends QueryDataSet {
    protected static final float UDF_READER_MEMORY_BUDGET_IN_MB = IoTDBDescriptor.getInstance().getConfig().getUdfReaderMemoryBudgetInMB();
    protected static final float UDF_TRANSFORMER_MEMORY_BUDGET_IN_MB = IoTDBDescriptor.getInstance().getConfig().getUdfTransformerMemoryBudgetInMB();
    protected static final float UDF_COLLECTOR_MEMORY_BUDGET_IN_MB = IoTDBDescriptor.getInstance().getConfig().getUdfCollectorMemoryBudgetInMB();
    protected final long queryId;
    protected final UDTFPlan udtfPlan;
    protected final InputLayer inputLayer;
    protected LayerPointReader[] transformers;

    protected UDTFDataSet(QueryContext queryContext, UDTFPlan udtfPlan, List<PartialPath> deduplicatedPaths, List<TSDataType> deduplicatedDataTypes, TimeGenerator timestampGenerator, List<IReaderByTimestamp> readersOfSelectedSeries, List<Boolean> cached) throws QueryProcessException, IOException {
        super(new ArrayList<PartialPath>(deduplicatedPaths), deduplicatedDataTypes);
        this.queryId = queryContext.getQueryId();
        this.udtfPlan = udtfPlan;
        this.inputLayer = new InputLayer(this.queryId, UDF_READER_MEMORY_BUDGET_IN_MB, deduplicatedPaths, deduplicatedDataTypes, timestampGenerator, readersOfSelectedSeries, cached);
        udtfPlan.initializeUdfExecutors(this.queryId, UDF_COLLECTOR_MEMORY_BUDGET_IN_MB);
        this.initTransformers(UDF_TRANSFORMER_MEMORY_BUDGET_IN_MB);
    }

    protected UDTFDataSet(QueryContext queryContext, UDTFPlan udtfPlan, List<PartialPath> deduplicatedPaths, List<TSDataType> deduplicatedDataTypes, List<ManagedSeriesReader> readersOfSelectedSeries) throws QueryProcessException, IOException, InterruptedException {
        super(new ArrayList<PartialPath>(deduplicatedPaths), deduplicatedDataTypes);
        this.queryId = queryContext.getQueryId();
        this.udtfPlan = udtfPlan;
        this.inputLayer = new InputLayer(this.queryId, UDF_READER_MEMORY_BUDGET_IN_MB, deduplicatedPaths, deduplicatedDataTypes, readersOfSelectedSeries);
        udtfPlan.initializeUdfExecutors(this.queryId, UDF_COLLECTOR_MEMORY_BUDGET_IN_MB);
        this.initTransformers(UDF_TRANSFORMER_MEMORY_BUDGET_IN_MB);
    }

    protected void initTransformers(float memoryBudgetInMB) throws QueryProcessException, IOException {
        int i;
        int size = this.udtfPlan.getPathToIndex().size();
        this.transformers = new Transformer[size];
        int windowTransformerCount = 0;
        block7: for (i = 0; i < size; ++i) {
            if (!this.udtfPlan.isUdfColumn(i)) continue;
            AccessStrategy accessStrategy = this.udtfPlan.getExecutorByDataSetOutputColumnIndex(i).getConfigurations().getAccessStrategy();
            switch (accessStrategy.getAccessStrategyType()) {
                case SLIDING_SIZE_WINDOW: 
                case SLIDING_TIME_WINDOW: {
                    ++windowTransformerCount;
                    continue block7;
                }
            }
        }
        memoryBudgetInMB /= (float)Math.max(windowTransformerCount, 1);
        for (i = 0; i < size; ++i) {
            if (this.udtfPlan.isUdfColumn(i)) {
                UDTFExecutor executor = this.udtfPlan.getExecutorByDataSetOutputColumnIndex(i);
                int[] readerIndexes = this.calculateReaderIndexes(executor);
                AccessStrategy accessStrategy = executor.getConfigurations().getAccessStrategy();
                switch (accessStrategy.getAccessStrategyType()) {
                    case ROW_BY_ROW: {
                        this.transformers[i] = new UDFQueryRowTransformer(this.inputLayer.constructRowReader(readerIndexes), executor);
                        break;
                    }
                    case SLIDING_SIZE_WINDOW: 
                    case SLIDING_TIME_WINDOW: {
                        this.transformers[i] = new UDFQueryRowWindowTransformer(this.inputLayer.constructRowWindowReader(readerIndexes, accessStrategy, memoryBudgetInMB), executor);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported transformer access strategy");
                    }
                }
                continue;
            }
            this.transformers[i] = new RawQueryPointTransformer(this.inputLayer.constructPointReader(this.udtfPlan.getReaderIndex(this.udtfPlan.getRawQueryColumnNameByDatasetOutputColumnIndex(i))));
        }
    }

    private int[] calculateReaderIndexes(UDTFExecutor executor) {
        List<PartialPath> paths = executor.getContext().getPaths();
        int[] readerIndexes = new int[paths.size()];
        for (int i = 0; i < readerIndexes.length; ++i) {
            readerIndexes[i] = this.udtfPlan.getReaderIndex(paths.get(i).getFullPath());
        }
        return readerIndexes;
    }

    public void finalizeUDFs(long queryId) {
        this.udtfPlan.finalizeUDFExecutors(queryId);
    }
}

