/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.crud.CreateTemplatePlan;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class Template {
    private String name;
    private Map<String, MeasurementSchema> schemaMap = new HashMap<String, MeasurementSchema>();

    public Template(CreateTemplatePlan plan) {
        this.name = plan.getName();
        for (int i = 0; i < plan.getMeasurements().size(); ++i) {
            MeasurementSchema curSchema = new MeasurementSchema(plan.getMeasurements().get(i).get(0), plan.getDataTypes().get(i).get(0), plan.getEncodings().get(i).get(0), plan.getCompressors().get(i));
            String path = plan.getSchemaNames().get(i);
            if (this.schemaMap.containsKey(path)) {
                throw new IllegalArgumentException("Duplicate measurement name in create template plan. Name is :" + path);
            }
            this.schemaMap.put(path, curSchema);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, MeasurementSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public void setSchemaMap(Map<String, MeasurementSchema> schemaMap) {
        this.schemaMap = schemaMap;
    }

    public boolean isCompatible(PartialPath path) {
        return !this.schemaMap.containsKey(path.getMeasurement());
    }

    public List<MeasurementMNode> getMeasurementMNode() {
        HashSet<MeasurementSchema> deduplicateSchema = new HashSet<MeasurementSchema>();
        ArrayList<MeasurementMNode> res = new ArrayList<MeasurementMNode>();
        for (MeasurementSchema measurementSchema : this.schemaMap.values()) {
            if (!deduplicateSchema.add(measurementSchema)) continue;
            MeasurementMNode measurementMNode = null;
            measurementMNode = new MeasurementMNode(null, measurementSchema.getMeasurementId(), measurementSchema, null);
            res.add(measurementMNode);
        }
        return res;
    }

    public String getMeasurementNodeName(String measurementName) {
        return this.schemaMap.get(measurementName).getMeasurementId();
    }

    public HashMap<String, List<String>> getAllPath() {
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        for (Map.Entry<String, MeasurementSchema> schemaEntry : this.schemaMap.entrySet()) {
            res.put(schemaEntry.getKey(), new ArrayList());
        }
        return res;
    }

    public boolean equals(Object t) {
        if (this == t) {
            return true;
        }
        if (t == null || this.getClass() != t.getClass()) {
            return false;
        }
        Template that = (Template)t;
        return this.name.equals(that.name) && this.schemaMap.equals(that.schemaMap);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append(this.schemaMap).toHashCode();
    }
}

