/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;

public class RowRecord {
    private final long timestamp;
    private final List<Field> fields;
    private boolean hasNullField = false;
    private boolean allNull = true;

    public RowRecord(long timestamp) {
        this.timestamp = timestamp;
        this.fields = new ArrayList<Field>();
    }

    public RowRecord(long timestamp, List<Field> fields) {
        this.timestamp = timestamp;
        this.fields = fields;
        for (Field field : fields) {
            if (field == null || field.getDataType() == null) {
                this.hasNullField = true;
                continue;
            }
            this.allNull = false;
        }
    }

    public void addField(Field f) {
        this.fields.add(f);
        if (f == null || f.getDataType() == null) {
            this.hasNullField = true;
        } else {
            this.allNull = false;
        }
    }

    public void addField(Object value, TSDataType dataType) {
        this.fields.add(Field.getField(value, dataType));
        if (value == null || dataType == null) {
            this.hasNullField = true;
        } else {
            this.allNull = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp);
        for (Field f : this.fields) {
            sb.append("\t");
            sb.append(f);
        }
        return sb.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setField(int index, Field field) {
        this.fields.set(index, field);
    }

    public boolean hasNullField() {
        return this.hasNullField;
    }

    public boolean isAllNull() {
        return this.allNull;
    }

    public void resetNullFlag() {
        this.hasNullField = false;
        this.allNull = true;
    }
}

