/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.time.ZoneId;
import java.util.List;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionConnection {
    private static final Logger logger = LoggerFactory.getLogger(SessionConnection.class);
    public static final String MSG_RECONNECTION_FAIL = "Fail to reconnect to server. Please check server status";
    private Session session;
    private TTransport transport;
    private TSIService.Iface client;
    private long sessionId;
    private long statementId;
    private ZoneId zoneId;
    private EndPoint endPoint;
    private boolean enableRedirect = false;

    public SessionConnection() {
    }

    public SessionConnection(Session session, EndPoint endPoint, ZoneId zoneId) throws IoTDBConnectionException {
        this.session = session;
        this.endPoint = endPoint;
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        this.init(endPoint);
    }

    private void init(EndPoint endPoint) throws IoTDBConnectionException {
        RpcTransportFactory.setDefaultBufferCapacity((int)this.session.thriftDefaultBufferSize);
        RpcTransportFactory.setThriftMaxFrameSize((int)this.session.thriftMaxFrameSize);
        try {
            this.transport = RpcTransportFactory.INSTANCE.getTransport((TTransport)new TSocket(TConfigurationConst.defaultTConfiguration, endPoint.getIp(), endPoint.getPort(), this.session.connectionTimeoutInMs));
            this.transport.open();
        }
        catch (TTransportException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
        this.client = this.session.enableRPCCompression ? new TSIService.Client((TProtocol)new TCompactProtocol(this.transport)) : new TSIService.Client((TProtocol)new TBinaryProtocol(this.transport));
        this.client = RpcUtils.newSynchronizedClient((TSIService.Iface)this.client);
        TSOpenSessionReq openReq = new TSOpenSessionReq();
        openReq.setUsername(this.session.username);
        openReq.setPassword(this.session.password);
        openReq.setZoneId(this.zoneId.toString());
        try {
            TSOpenSessionResp openResp = this.client.openSession(openReq);
            RpcUtils.verifySuccess((TSStatus)openResp.getStatus());
            if (Session.protocolVersion.getValue() != openResp.getServerProtocolVersion().getValue()) {
                logger.warn("Protocol differ, Client version is {}}, but Server version is {}", (Object)Session.protocolVersion.getValue(), (Object)openResp.getServerProtocolVersion().getValue());
                if (openResp.getServerProtocolVersion().getValue() == 0) {
                    throw new TException(String.format("Protocol not supported, Client version is %s, but Server version is %s", Session.protocolVersion.getValue(), openResp.getServerProtocolVersion().getValue()));
                }
            }
            this.sessionId = openResp.getSessionId();
            this.statementId = this.client.requestStatementId(this.sessionId);
        }
        catch (Exception e) {
            this.transport.close();
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void close() throws IoTDBConnectionException {
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionId);
        try {
            this.client.closeSession(req);
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Error occurs when closing session at server. Maybe server is down.", (Throwable)e);
        }
        finally {
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    protected void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        TSStatus resp;
        TSSetTimeZoneReq req = new TSSetTimeZoneReq(this.sessionId, zoneId);
        try {
            resp = this.client.setTimeZone(req);
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    req.setSessionId(this.sessionId);
                    resp = this.client.setTimeZone(req);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
        RpcUtils.verifySuccess((TSStatus)resp);
        this.zoneId = ZoneId.of(zoneId);
    }

    protected String getTimeZone() {
        if (this.zoneId == null) {
            this.zoneId = ZoneId.systemDefault();
        }
        return this.zoneId.toString();
    }

    protected void setStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        try {
            RpcUtils.verifySuccessWithRedirection((TSStatus)this.client.setStorageGroup(this.sessionId, storageGroup));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    RpcUtils.verifySuccess((TSStatus)this.client.setStorageGroup(this.sessionId, storageGroup));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void deleteStorageGroups(List<String> storageGroups) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        try {
            RpcUtils.verifySuccessWithRedirection((TSStatus)this.client.deleteStorageGroups(this.sessionId, storageGroups));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    RpcUtils.verifySuccess((TSStatus)this.client.deleteStorageGroups(this.sessionId, storageGroups));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void createTimeseries(TSCreateTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.createTimeseries(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.createTimeseries(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void createMultiTimeseries(TSCreateMultiTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.createMultiTimeseries(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.createMultiTimeseries(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkTimeseriesExists(String path, long timeout) throws IoTDBConnectionException, StatementExecutionException {
        SessionDataSet dataSet = null;
        try {
            try {
                dataSet = this.executeQueryStatement(String.format("SHOW TIMESERIES %s", path), timeout);
            }
            catch (RedirectException e) {
                throw new StatementExecutionException("need to redirect query, should not see this.", (Throwable)e);
            }
            boolean bl = dataSet.hasNext();
            return bl;
        }
        finally {
            if (dataSet != null) {
                dataSet.closeOperationHandle();
            }
        }
    }

    protected SessionDataSet executeQueryStatement(String sql, long timeout) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSExecuteStatementResp execResp;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        execReq.setFetchSize(this.session.fetchSize);
        execReq.setTimeout(timeout);
        try {
            execReq.setEnableRedirectQuery(this.enableRedirect);
            execResp = this.client.executeQueryStatement(execReq);
            RpcUtils.verifySuccessWithRedirection((TSStatus)execResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    execReq.setSessionId(this.sessionId);
                    execReq.setStatementId(this.statementId);
                    execResp = this.client.executeQueryStatement(execReq);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
        RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        return new SessionDataSet(sql, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.statementId, this.client, this.sessionId, execResp.queryDataSet, execResp.isIgnoreTimeStamp(), timeout);
    }

    protected void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        try {
            execReq.setEnableRedirectQuery(this.enableRedirect);
            TSExecuteStatementResp execResp = this.client.executeUpdateStatement(execReq);
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    execReq.setSessionId(this.sessionId);
                    execReq.setStatementId(this.statementId);
                    RpcUtils.verifySuccess((TSStatus)this.client.executeUpdateStatement((TSExecuteStatementReq)execReq).status);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSExecuteStatementResp execResp;
        TSRawDataQueryReq execReq = new TSRawDataQueryReq(this.sessionId, paths, startTime, endTime, this.statementId);
        execReq.setFetchSize(this.session.fetchSize);
        try {
            execReq.setEnableRedirectQuery(this.enableRedirect);
            execResp = this.client.executeRawDataQuery(execReq);
            RpcUtils.verifySuccessWithRedirection((TSStatus)execResp.getStatus());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    execReq.setSessionId(this.sessionId);
                    execReq.setStatementId(this.statementId);
                    execResp = this.client.executeRawDataQuery(execReq);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
        RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        return new SessionDataSet("", execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.statementId, this.client, this.sessionId, execResp.queryDataSet, execResp.isIgnoreTimeStamp());
    }

    protected void insertRecord(TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccessWithRedirection((TSStatus)this.client.insertRecord(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.insertRecord(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void insertRecord(TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccessWithRedirection((TSStatus)this.client.insertStringRecord(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.insertStringRecord(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void insertRecords(TSInsertRecordsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccessWithRedirectionForMultiDevices((TSStatus)this.client.insertRecords(request), (List)request.getDeviceIds());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.insertRecords(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void insertRecords(TSInsertStringRecordsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccessWithRedirectionForMultiDevices((TSStatus)this.client.insertStringRecords(request), (List)request.getDeviceIds());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.insertStringRecords(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccessWithRedirection((TSStatus)this.client.insertRecordsOfOneDevice(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.insertRecordsOfOneDevice(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void insertTablet(TSInsertTabletReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccessWithRedirection((TSStatus)this.client.insertTablet(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.insertTablet(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void insertTablets(TSInsertTabletsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccessWithRedirectionForMultiDevices((TSStatus)this.client.insertTablets(request), (List)request.getDeviceIds());
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.insertTablets(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.deleteTimeseries(this.sessionId, paths));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    RpcUtils.verifySuccess((TSStatus)this.client.deleteTimeseries(this.sessionId, paths));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    public void deleteData(TSDeleteDataReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.deleteData(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.deleteData(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void testInsertRecord(TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertStringRecord(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.testInsertStringRecord(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void testInsertRecord(TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertRecord(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.testInsertRecord(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    public void testInsertRecords(TSInsertStringRecordsReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertStringRecords(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.testInsertStringRecords(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    public void testInsertRecords(TSInsertRecordsReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertRecords(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.testInsertRecords(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void testInsertTablet(TSInsertTabletReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertTablet(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.testInsertTablet(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    protected void testInsertTablets(TSInsertTabletsReq request) throws IoTDBConnectionException, StatementExecutionException {
        request.setSessionId(this.sessionId);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertTablets(request));
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    request.setSessionId(this.sessionId);
                    RpcUtils.verifySuccess((TSStatus)this.client.testInsertTablets(request));
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException((Throwable)tException);
                }
            }
            throw new IoTDBConnectionException(MSG_RECONNECTION_FAIL);
        }
    }

    private boolean reconnect() {
        boolean flag = false;
        for (int i = 1; i <= 3; ++i) {
            try {
                if (this.transport == null) continue;
                this.close();
                this.init(this.endPoint);
                flag = true;
                continue;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error("reconnect is interrupted.", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return flag;
    }

    public boolean isEnableRedirect() {
        return this.enableRedirect;
    }

    public void setEnableRedirect(boolean enableRedirect) {
        this.enableRedirect = enableRedirect;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(EndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public String toString() {
        return "SessionConnection{ endPoint=" + this.endPoint + "}";
    }
}

