/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MeasurementMNodePlan
extends MNodePlan {
    private MeasurementSchema schema;
    private String alias;
    private long offset;

    public MeasurementMNodePlan() {
        super(false, Operator.OperatorType.MEASUREMENT_MNODE);
    }

    public MeasurementMNodePlan(String name, String alias, long offset, int childSize, MeasurementSchema schema) {
        super(false, Operator.OperatorType.MEASUREMENT_MNODE);
        this.name = name;
        this.alias = alias;
        this.offset = offset;
        this.childSize = childSize;
        this.schema = schema;
    }

    @Override
    public List<PartialPath> getPaths() {
        return new ArrayList<PartialPath>();
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.MEASUREMENT_MNODE.ordinal());
        this.putString(buffer, this.name);
        this.putString(buffer, this.alias);
        buffer.putLong(this.offset);
        buffer.putInt(this.childSize);
        this.schema.serializeTo(buffer);
        buffer.putLong(this.index);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.MEASUREMENT_MNODE.ordinal());
        this.putString(stream, this.name);
        this.putString(stream, this.alias);
        stream.writeLong(this.offset);
        stream.writeInt(this.childSize);
        this.schema.serializeTo((OutputStream)stream);
        stream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.name = this.readString(buffer);
        this.alias = this.readString(buffer);
        this.offset = buffer.getLong();
        this.childSize = buffer.getInt();
        this.schema = MeasurementSchema.deserializeFrom((ByteBuffer)buffer);
        this.index = buffer.getLong();
    }

    public MeasurementSchema getSchema() {
        return this.schema;
    }

    public void setSchema(MeasurementSchema schema) {
        this.schema = schema;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public String toString() {
        return "MeasurementMNode{" + this.name + "," + this.alias + "," + this.schema + "," + this.offset + "," + this.childSize + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementMNodePlan that = (MeasurementMNodePlan)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.alias, that.alias) && Objects.equals(this.schema, that.schema) && Objects.equals(this.offset, that.offset) && Objects.equals(this.childSize, that.childSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.alias, this.schema, this.offset, this.childSize);
    }
}

