/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class DeleteStorageGroupPlan
extends PhysicalPlan {
    private List<PartialPath> deletePathList;

    public DeleteStorageGroupPlan(List<PartialPath> deletePathList) {
        super(false, Operator.OperatorType.DELETE_STORAGE_GROUP);
        this.deletePathList = deletePathList;
    }

    public DeleteStorageGroupPlan() {
        super(false, Operator.OperatorType.DELETE_STORAGE_GROUP);
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.deletePathList;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.DELETE_STORAGE_GROUP.ordinal();
        stream.writeByte((byte)type);
        stream.writeInt(this.getPaths().size());
        for (PartialPath path : this.getPaths()) {
            this.putString(stream, path.getFullPath());
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.DELETE_STORAGE_GROUP.ordinal();
        buffer.put((byte)type);
        buffer.putInt(this.getPaths().size());
        for (PartialPath path : this.getPaths()) {
            this.putString(buffer, path.getFullPath());
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        int pathNum = buffer.getInt();
        this.deletePathList = new ArrayList<PartialPath>();
        for (int i = 0; i < pathNum; ++i) {
            this.deletePathList.add(new PartialPath(this.readString(buffer)));
        }
        this.index = buffer.getLong();
    }
}

