/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.rescon.CachedStringPool;

public class MNode
implements Serializable {
    private static final long serialVersionUID = -770028375899514063L;
    private static Map<String, String> cachedPathPool = CachedStringPool.getInstance().getCachedPool();
    protected String name;
    protected MNode parent;
    protected String fullPath;
    protected volatile transient Map<String, MNode> children = null;
    private volatile transient Map<String, MNode> aliasChildren = null;

    public MNode(MNode parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey(name) || this.aliasChildren != null && this.aliasChildren.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(String name, MNode child) {
        if (this.children == null) {
            MNode mNode = this;
            synchronized (mNode) {
                if (this.children == null) {
                    this.children = new ConcurrentHashMap<String, MNode>();
                }
            }
        }
        child.parent = this;
        this.children.putIfAbsent(name, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MNode addChild(MNode child) {
        if (this.children == null) {
            MNode mNode = this;
            synchronized (mNode) {
                if (this.children == null) {
                    this.children = new ConcurrentHashMap<String, MNode>();
                }
            }
        }
        child.parent = this;
        this.children.putIfAbsent(child.getName(), child);
        return child;
    }

    public void deleteChild(String name) {
        if (this.children != null) {
            this.children.remove(name);
        }
    }

    public void deleteAliasChild(String alias) {
        if (this.aliasChildren != null) {
            this.aliasChildren.remove(alias);
        }
    }

    public MNode getChild(String name) {
        MNode child = null;
        if (this.children != null) {
            child = this.children.get(name);
        }
        if (child != null) {
            return child;
        }
        return this.aliasChildren == null ? null : this.aliasChildren.get(name);
    }

    public int getMeasurementMNodeCount() {
        if (this.children == null) {
            return 1;
        }
        int measurementMNodeCount = 0;
        if (this instanceof MeasurementMNode) {
            ++measurementMNodeCount;
        }
        for (MNode child : this.children.values()) {
            measurementMNodeCount += child.getMeasurementMNodeCount();
        }
        return measurementMNodeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAlias(String alias, MNode child) {
        if (this.aliasChildren == null) {
            MNode mNode = this;
            synchronized (mNode) {
                if (this.aliasChildren == null) {
                    this.aliasChildren = new ConcurrentHashMap<String, MNode>();
                }
            }
        }
        return this.aliasChildren.computeIfAbsent(alias, aliasName -> child) == child;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath();
            String cachedFullPath = cachedPathPool.get(this.fullPath);
            if (cachedFullPath == null) {
                cachedPathPool.put(this.fullPath, this.fullPath);
            } else {
                this.fullPath = cachedFullPath;
            }
        }
        return this.fullPath;
    }

    public PartialPath getPartialPath() {
        ArrayList<String> detachedPath = new ArrayList<String>();
        MNode temp = this;
        detachedPath.add(temp.getName());
        while (temp.getParent() != null) {
            temp = temp.getParent();
            detachedPath.add(0, temp.getName());
        }
        return new PartialPath(detachedPath.toArray(new String[0]));
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.name);
        MNode curr = this;
        while (curr.getParent() != null) {
            curr = curr.getParent();
            builder.insert(0, '.').insert(0, curr.name);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getName();
    }

    public MNode getParent() {
        return this.parent;
    }

    public void setParent(MNode parent) {
        this.parent = parent;
    }

    public Map<String, MNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyMap();
        }
        return this.children;
    }

    public Map<String, MNode> getAliasChildren() {
        if (this.aliasChildren == null) {
            return Collections.emptyMap();
        }
        return this.aliasChildren;
    }

    public void setChildren(Map<String, MNode> children) {
        this.children = children;
    }

    private void setAliasChildren(Map<String, MNode> aliasChildren) {
        this.aliasChildren = aliasChildren;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void serializeTo(MLogWriter logWriter) throws IOException {
        this.serializeChildren(logWriter);
        logWriter.serializeMNode(this);
    }

    void serializeChildren(MLogWriter logWriter) throws IOException {
        if (this.children == null) {
            return;
        }
        for (Map.Entry<String, MNode> entry : this.children.entrySet()) {
            entry.getValue().serializeTo(logWriter);
        }
    }

    public void replaceChild(String measurement, MNode newChildNode) {
        MNode oldChildNode = this.getChild(measurement);
        if (oldChildNode == null) {
            return;
        }
        Map<String, MNode> grandChildren = oldChildNode.getChildren();
        newChildNode.setChildren(grandChildren);
        grandChildren.forEach((grandChildName, grandChildNode) -> grandChildNode.setParent(newChildNode));
        Map<String, MNode> grandAliasChildren = oldChildNode.getAliasChildren();
        newChildNode.setAliasChildren(grandAliasChildren);
        grandAliasChildren.forEach((grandAliasChildName, grandAliasChild) -> grandAliasChild.setParent(newChildNode));
        newChildNode.setParent(this);
        this.deleteChild(measurement);
        this.addChild(newChildNode.getName(), newChildNode);
    }
}

