/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.session.SessionConnection;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.session.SessionUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    protected static final TSProtocolVersion protocolVersion = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    public static final String MSG_UNSUPPORTED_DATA_TYPE = "Unsupported data type:";
    public static final String MSG_DONOT_ENABLE_REDIRECT = "Query do not enable redirect, please confirm the session and server conf.";
    protected String username;
    protected String password;
    protected int fetchSize;
    private long timeout = 0L;
    protected boolean enableRPCCompression;
    protected int connectionTimeoutInMs;
    protected ZoneId zoneId;
    protected int thriftDefaultBufferSize;
    protected int thriftMaxFrameSize;
    protected EndPoint defaultEndPoint;
    protected SessionConnection defaultSessionConnection;
    private boolean isClosed = true;
    protected boolean enableCacheLeader;
    protected SessionConnection metaSessionConnection;
    protected Map<String, EndPoint> deviceIdToEndpoint;
    protected Map<EndPoint, SessionConnection> endPointToSessionConnection;
    private AtomicReference<IoTDBConnectionException> tmp = new AtomicReference();
    protected boolean enableQueryRedirection = false;

    public Session(String host, int rpcPort) {
        this(host, rpcPort, "root", "root", 5000, null, 1024, 0x4000000, false);
    }

    public Session(String host, String rpcPort, String username, String password) {
        this(host, Integer.parseInt(rpcPort), username, password, 5000, null, 1024, 0x4000000, false);
    }

    public Session(String host, int rpcPort, String username, String password) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, false);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, false);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, long timeoutInMs) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, false);
        this.timeout = timeoutInMs;
    }

    public Session(String host, int rpcPort, String username, String password, ZoneId zoneId) {
        this(host, rpcPort, username, password, 5000, zoneId, 1024, 0x4000000, false);
    }

    public Session(String host, int rpcPort, String username, String password, boolean enableCacheLeader) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, enableCacheLeader);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, boolean enableCacheLeader) {
        this(host, rpcPort, username, password, fetchSize, zoneId, 1024, 0x4000000, enableCacheLeader);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean enableCacheLeader) {
        this.defaultEndPoint = new EndPoint(host, rpcPort);
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.zoneId = zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.enableCacheLeader = enableCacheLeader;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public synchronized void open() throws IoTDBConnectionException {
        this.open(false, 0);
    }

    public synchronized void open(boolean enableRPCCompression) throws IoTDBConnectionException {
        this.open(enableRPCCompression, 0);
    }

    private synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        this.enableRPCCompression = enableRPCCompression;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.defaultSessionConnection = this.constructSessionConnection(this, this.defaultEndPoint, this.zoneId);
        this.defaultSessionConnection.setEnableRedirect(this.enableQueryRedirection);
        this.metaSessionConnection = this.defaultSessionConnection;
        this.isClosed = false;
        if (this.enableCacheLeader || this.enableQueryRedirection) {
            this.deviceIdToEndpoint = new HashMap<String, EndPoint>();
            this.endPointToSessionConnection = new HashMap<EndPoint, SessionConnection>();
            this.endPointToSessionConnection.put(this.defaultEndPoint, this.defaultSessionConnection);
        }
    }

    public synchronized void close() throws IoTDBConnectionException {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.enableCacheLeader) {
                for (SessionConnection sessionConnection : this.endPointToSessionConnection.values()) {
                    sessionConnection.close();
                }
            } else {
                this.defaultSessionConnection.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    public SessionConnection constructSessionConnection(Session session, EndPoint endpoint, ZoneId zoneId) throws IoTDBConnectionException {
        return new SessionConnection(session, endpoint, zoneId);
    }

    public synchronized String getTimeZone() {
        return this.defaultSessionConnection.getTimeZone();
    }

    public synchronized void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        this.defaultSessionConnection.setTimeZone(zoneId);
    }

    public void setStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.metaSessionConnection.setStorageGroup(storageGroup);
        }
        catch (RedirectException e) {
            this.handleMetaRedirection(storageGroup, e);
        }
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.metaSessionConnection.deleteStorageGroups(Collections.singletonList(storageGroup));
        }
        catch (RedirectException e) {
            this.handleMetaRedirection(storageGroup, e);
        }
    }

    public void deleteStorageGroups(List<String> storageGroups) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.metaSessionConnection.deleteStorageGroups(storageGroups);
        }
        catch (RedirectException e) {
            this.handleMetaRedirection(storageGroups.toString(), e);
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, null, null, null, null);
        this.defaultSessionConnection.createTimeseries(request);
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
        this.defaultSessionConnection.createTimeseries(request);
    }

    private TSCreateTimeseriesReq genTSCreateTimeseriesReq(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) {
        TSCreateTimeseriesReq request = new TSCreateTimeseriesReq();
        request.setPath(path);
        request.setDataType(dataType.ordinal());
        request.setEncoding(encoding.ordinal());
        request.setCompressor(compressor.ordinal());
        request.setProps(props);
        request.setTags(tags);
        request.setAttributes(attributes);
        request.setMeasurementAlias(measurementAlias);
        return request;
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateMultiTimeseriesReq request = this.genTSCreateMultiTimeseriesReq(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
        this.defaultSessionConnection.createMultiTimeseries(request);
    }

    private TSCreateMultiTimeseriesReq genTSCreateMultiTimeseriesReq(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) {
        TSCreateMultiTimeseriesReq request = new TSCreateMultiTimeseriesReq();
        request.setPaths(paths);
        ArrayList<Integer> dataTypeOrdinals = new ArrayList<Integer>(paths.size());
        for (TSDataType tSDataType : dataTypes) {
            dataTypeOrdinals.add(tSDataType.ordinal());
        }
        request.setDataTypes(dataTypeOrdinals);
        ArrayList<Integer> encodingOrdinals = new ArrayList<Integer>(paths.size());
        for (TSEncoding encoding : encodings) {
            encodingOrdinals.add(encoding.ordinal());
        }
        request.setEncodings(encodingOrdinals);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(paths.size());
        for (CompressionType compression : compressors) {
            arrayList.add(compression.ordinal());
        }
        request.setCompressors(arrayList);
        request.setPropsList(propsList);
        request.setTagsList(tagsList);
        request.setAttributesList(attributesList);
        request.setMeasurementAliasList(measurementAliasList);
        return request;
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        return this.defaultSessionConnection.checkTimeseriesExists(path, this.timeout);
    }

    public void setTimeout(long timeoutInMs) throws StatementExecutionException {
        if (timeoutInMs < 0L) {
            throw new StatementExecutionException("Timeout must be >= 0, please check and try again.");
        }
        this.timeout = timeoutInMs;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public SessionDataSet executeQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeStatementMayRedirect(sql, this.timeout);
    }

    public SessionDataSet executeQueryStatement(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        if (timeoutInMs < 0L) {
            throw new StatementExecutionException("Timeout must be >= 0, please check and try again.");
        }
        return this.executeStatementMayRedirect(sql, timeoutInMs);
    }

    private SessionDataSet executeStatementMayRedirect(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        try {
            logger.info("{} execute sql {}", (Object)this.defaultSessionConnection.getEndPoint(), (Object)sql);
            return this.defaultSessionConnection.executeQueryStatement(sql, timeoutInMs);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                logger.debug("{} redirect query {} to {}", new Object[]{this.defaultSessionConnection.getEndPoint(), sql, e.getEndPoint()});
                try {
                    return this.defaultSessionConnection.executeQueryStatement(sql, this.timeout);
                }
                catch (RedirectException redirectException) {
                    logger.error("{} redirect twice", (Object)sql, (Object)redirectException);
                    throw new StatementExecutionException(sql + " redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.executeNonQueryStatement(sql);
    }

    public SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.defaultSessionConnection.executeRawDataQuery(paths, startTime, endTime);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                logger.debug("redirect query {} to {}", paths, (Object)e.getEndPoint());
                try {
                    return this.defaultSessionConnection.executeRawDataQuery(paths, startTime, endTime);
                }
                catch (RedirectException redirectException) {
                    logger.error("Redirect twice", (Throwable)redirectException);
                    throw new StatementExecutionException("Redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, Object ... values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, Arrays.asList(values));
        this.insertRecord(deviceId, request);
    }

    private void insertRecord(String deviceId, TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(deviceId).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    private void insertRecord(String deviceId, TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(deviceId).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    private SessionConnection getSessionConnection(String deviceId) {
        EndPoint endPoint;
        if (this.enableCacheLeader && (endPoint = this.deviceIdToEndpoint.get(deviceId)) != null) {
            return this.endPointToSessionConnection.get(endPoint);
        }
        return this.defaultSessionConnection;
    }

    private void removeBrokenSessionConnection(SessionConnection sessionConnection) {
        if (this.enableCacheLeader) {
            Map.Entry<Object, SessionConnection> entry;
            EndPoint endPoint = null;
            Iterator<Map.Entry<Object, SessionConnection>> it = this.endPointToSessionConnection.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getValue().equals(sessionConnection)) continue;
                endPoint = entry.getKey();
                it.remove();
                break;
            }
            it = this.deviceIdToEndpoint.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!((EndPoint)entry.getValue()).equals(endPoint)) continue;
                it.remove();
            }
        }
    }

    private void handleMetaRedirection(String storageGroup, RedirectException e) throws IoTDBConnectionException {
        if (this.enableCacheLeader) {
            logger.debug("storageGroup[{}]:{}", (Object)storageGroup, (Object)e.getMessage());
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(e.getEndPoint(), k -> {
                try {
                    return this.constructSessionConnection(this, e.getEndPoint(), this.zoneId);
                }
                catch (IoTDBConnectionException ex) {
                    this.tmp.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                throw new IoTDBConnectionException((Throwable)this.tmp.get());
            }
            this.metaSessionConnection = connection;
        }
    }

    private void handleRedirection(String deviceId, EndPoint endpoint) throws IoTDBConnectionException {
        if (this.enableCacheLeader) {
            this.deviceIdToEndpoint.put(deviceId, endpoint);
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(endpoint, k -> {
                try {
                    return this.constructSessionConnection(this, endpoint, this.zoneId);
                }
                catch (IoTDBConnectionException ex) {
                    this.tmp.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                throw new IoTDBConnectionException((Throwable)this.tmp.get());
            }
        }
    }

    private void handleQueryRedirection(EndPoint endPoint) throws IoTDBConnectionException {
        if (this.enableQueryRedirection) {
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(endPoint, k -> {
                try {
                    SessionConnection sessionConnection = this.constructSessionConnection(this, endPoint, this.zoneId);
                    sessionConnection.setEnableRedirect(this.enableQueryRedirection);
                    return sessionConnection;
                }
                catch (IoTDBConnectionException ex) {
                    this.tmp.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                throw new IoTDBConnectionException((Throwable)this.tmp.get());
            }
            this.defaultSessionConnection = connection;
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, values);
        this.insertRecord(deviceId, request);
    }

    private TSInsertRecordReq genTSInsertRecordReq(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        TSInsertRecordReq request = new TSInsertRecordReq();
        request.setDeviceId(deviceId);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateLength(types, values));
        this.putValues(types, values, buffer);
        request.setValues(buffer);
        return request;
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request = this.genTSInsertStringRecordReq(deviceId, time, measurements, values);
        this.insertRecord(deviceId, request);
    }

    private TSInsertStringRecordReq genTSInsertStringRecordReq(String deviceId, long time, List<String> measurements, List<String> values) {
        TSInsertStringRecordReq request = new TSInsertStringRecordReq();
        request.setDeviceId(deviceId);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        request.setValues(values);
        return request;
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableCacheLeader) {
            this.insertStringRecordsWithLeaderCache(deviceIds, times, measurementsList, valuesList);
        } else {
            TSInsertStringRecordsReq request = this.genTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList);
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void insertStringRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertStringRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertStringRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            EndPoint endPoint = this.deviceIdToEndpoint.get(deviceIds.get(i));
            SessionConnection connection = endPoint != null ? this.endPointToSessionConnection.get(endPoint) : this.defaultSessionConnection;
            TSInsertStringRecordsReq request = recordsGroup.computeIfAbsent(connection, k -> new TSInsertStringRecordsReq());
            this.updateTSInsertStringRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), valuesList.get(i));
        }
        StringBuilder errMsgBuilder = new StringBuilder();
        for (Map.Entry entry : recordsGroup.entrySet()) {
            try {
                ((SessionConnection)entry.getKey()).insertRecords((TSInsertStringRecordsReq)entry.getValue());
            }
            catch (RedirectException e) {
                for (Map.Entry deviceEndPointEntry : e.getDeviceEndPointMap().entrySet()) {
                    this.handleRedirection((String)deviceEndPointEntry.getKey(), (EndPoint)deviceEndPointEntry.getValue());
                }
            }
            catch (StatementExecutionException e) {
                errMsgBuilder.append(e.getMessage());
            }
            catch (IoTDBConnectionException e) {
                this.removeBrokenSessionConnection((SessionConnection)entry.getKey());
                throw e;
            }
        }
        String errMsg = errMsgBuilder.toString();
        if (!errMsg.isEmpty()) {
            throw new StatementExecutionException(errMsg);
        }
    }

    private TSInsertStringRecordsReq genTSInsertStringRecordsReq(List<String> deviceId, List<Long> time, List<List<String>> measurements, List<List<String>> values) {
        TSInsertStringRecordsReq request = new TSInsertStringRecordsReq();
        request.setDeviceIds(deviceId);
        request.setTimestamps(time);
        request.setMeasurementsList(measurements);
        request.setValuesList(values);
        return request;
    }

    private void updateTSInsertStringRecordsReq(TSInsertStringRecordsReq request, String deviceId, long time, List<String> measurements, List<String> values) {
        request.addToDeviceIds(deviceId);
        request.addToTimestamps(time);
        request.addToMeasurementsList(measurements);
        request.addToValuesList(values);
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableCacheLeader) {
            this.insertRecordsWithLeaderCache(deviceIds, times, measurementsList, typesList, valuesList);
        } else {
            TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList);
            try {
                this.defaultSessionConnection.insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        TSInsertRecordsOfOneDeviceReq request = this.genTSInsertRecordsOfOneDeviceReq(deviceId, times, measurementsList, typesList, valuesList, haveSorted);
        try {
            this.getSessionConnection(deviceId).insertRecordsOfOneDevice(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
    }

    private TSInsertRecordsOfOneDeviceReq genTSInsertRecordsOfOneDeviceReq(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, BatchExecutionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, measurementsList and valuesList's size should be equal");
        }
        if (haveSorted) {
            if (!this.checkSorted(times)) {
                throw new BatchExecutionException("Times in InsertOneDeviceRecords are not in ascending order");
            }
        } else {
            Integer[] index = new Integer[times.size()];
            for (int i = 0; i < times.size(); ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(times::get));
            times.sort(Long::compareTo);
            measurementsList = this.sortList(measurementsList, index);
            typesList = this.sortList(typesList, index);
            valuesList = this.sortList(valuesList, index);
        }
        TSInsertRecordsOfOneDeviceReq request = new TSInsertRecordsOfOneDeviceReq();
        request.setDeviceId(deviceId);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList);
        request.setValuesList(buffersList);
        return request;
    }

    private List sortList(List source, Integer[] index) {
        Object[] result = new Object[source.size()];
        for (int i = 0; i < index.length; ++i) {
            result[i] = source.get(index[i]);
        }
        return Arrays.asList(result);
    }

    private List<ByteBuffer> objectValuesListToByteBufferList(List<List<Object>> valuesList, List<List<TSDataType>> typesList) throws IoTDBConnectionException {
        ArrayList<ByteBuffer> buffersList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < valuesList.size(); ++i) {
            ByteBuffer buffer = ByteBuffer.allocate(this.calculateLength(typesList.get(i), valuesList.get(i)));
            this.putValues(typesList.get(i), valuesList.get(i), buffer);
            buffersList.add(buffer);
        }
        return buffersList;
    }

    private void insertRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            EndPoint endPoint = this.deviceIdToEndpoint.get(deviceIds.get(i));
            SessionConnection connection = endPoint != null ? this.endPointToSessionConnection.get(endPoint) : this.defaultSessionConnection;
            TSInsertRecordsReq request = recordsGroup.computeIfAbsent(connection, k -> new TSInsertRecordsReq());
            this.updateTSInsertRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), typesList.get(i), valuesList.get(i));
        }
        StringBuilder errMsgBuilder = new StringBuilder();
        for (Map.Entry entry : recordsGroup.entrySet()) {
            try {
                ((SessionConnection)entry.getKey()).insertRecords((TSInsertRecordsReq)entry.getValue());
            }
            catch (RedirectException e) {
                for (Map.Entry deviceEndPointEntry : e.getDeviceEndPointMap().entrySet()) {
                    this.handleRedirection((String)deviceEndPointEntry.getKey(), (EndPoint)deviceEndPointEntry.getValue());
                }
            }
            catch (StatementExecutionException e) {
                errMsgBuilder.append(e.getMessage());
            }
            catch (IoTDBConnectionException e) {
                this.removeBrokenSessionConnection((SessionConnection)entry.getKey());
                throw e;
            }
        }
        String errMsg = errMsgBuilder.toString();
        if (!errMsg.isEmpty()) {
            throw new StatementExecutionException(errMsg);
        }
    }

    private TSInsertRecordsReq genTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException {
        TSInsertRecordsReq request = new TSInsertRecordsReq();
        request.setDeviceIds(deviceIds);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList);
        request.setValuesList(buffersList);
        return request;
    }

    private void updateTSInsertRecordsReq(TSInsertRecordsReq request, String deviceId, Long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        request.addToDeviceIds(deviceId);
        request.addToTimestamps(time.longValue());
        request.addToMeasurementsList(measurements);
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateLength(types, values));
        this.putValues(types, values, buffer);
        request.addToValuesList(buffer);
    }

    public void insertTablet(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, false);
        try {
            EndPoint endPoint;
            if (this.enableCacheLeader && (endPoint = this.deviceIdToEndpoint.get(tablet.deviceId)) != null) {
                this.endPointToSessionConnection.get(endPoint).insertTablet(request);
            } else {
                this.defaultSessionConnection.insertTablet(request);
            }
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.deviceId, e.getEndPoint());
        }
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted);
        try {
            EndPoint endPoint;
            if (this.enableCacheLeader && (endPoint = this.deviceIdToEndpoint.get(tablet.deviceId)) != null) {
                this.endPointToSessionConnection.get(endPoint).insertTablet(request);
            } else {
                this.defaultSessionConnection.insertTablet(request);
            }
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.deviceId, e.getEndPoint());
        }
    }

    private TSInsertTabletReq genTSInsertTabletReq(Tablet tablet, boolean sorted) throws BatchExecutionException {
        if (sorted) {
            this.checkSortedThrowable(tablet);
        } else {
            this.sortTablet(tablet);
        }
        TSInsertTabletReq request = new TSInsertTabletReq();
        request.setDeviceId(tablet.deviceId);
        for (MeasurementSchema measurementSchema : tablet.getSchemas()) {
            request.addToMeasurements(measurementSchema.getMeasurementId());
            request.addToTypes(measurementSchema.getType().ordinal());
        }
        request.setTimestamps(SessionUtils.getTimeBuffer(tablet));
        request.setValues(SessionUtils.getValueBuffer(tablet));
        request.setSize(tablet.rowSize);
        return request;
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        if (this.enableCacheLeader) {
            this.insertTabletsWithLeaderCache(tablets, sorted);
        } else {
            TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted);
            try {
                this.defaultSessionConnection.insertTablets(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void insertTabletsWithLeaderCache(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertTabletsReq> tabletGroup = new HashMap<SessionConnection, TSInsertTabletsReq>();
        for (Map.Entry<String, Tablet> entry : tablets.entrySet()) {
            EndPoint endPoint = this.deviceIdToEndpoint.get(entry.getKey());
            SessionConnection connection = endPoint != null ? this.endPointToSessionConnection.get(endPoint) : this.defaultSessionConnection;
            TSInsertTabletsReq tSInsertTabletsReq = tabletGroup.computeIfAbsent(connection, k -> new TSInsertTabletsReq());
            this.updateTSInsertTabletsReq(tSInsertTabletsReq, (Tablet)entry.getValue(), sorted);
        }
        StringBuilder errMsgBuilder = new StringBuilder();
        for (Map.Entry entry : tabletGroup.entrySet()) {
            try {
                ((SessionConnection)entry.getKey()).insertTablets((TSInsertTabletsReq)entry.getValue());
            }
            catch (RedirectException e) {
                for (Map.Entry deviceEndPointEntry : e.getDeviceEndPointMap().entrySet()) {
                    this.handleRedirection((String)deviceEndPointEntry.getKey(), (EndPoint)deviceEndPointEntry.getValue());
                }
            }
            catch (StatementExecutionException e) {
                errMsgBuilder.append(e.getMessage());
            }
            catch (IoTDBConnectionException e) {
                this.removeBrokenSessionConnection((SessionConnection)entry.getKey());
                throw e;
            }
        }
        String errMsg = errMsgBuilder.toString();
        if (!errMsg.isEmpty()) {
            throw new StatementExecutionException(errMsg);
        }
    }

    private TSInsertTabletsReq genTSInsertTabletsReq(List<Tablet> tablets, boolean sorted) throws BatchExecutionException {
        TSInsertTabletsReq request = new TSInsertTabletsReq();
        for (Tablet tablet : tablets) {
            this.updateTSInsertTabletsReq(request, tablet, sorted);
        }
        return request;
    }

    private void updateTSInsertTabletsReq(TSInsertTabletsReq request, Tablet tablet, boolean sorted) throws BatchExecutionException {
        if (sorted) {
            this.checkSortedThrowable(tablet);
        } else {
            this.sortTablet(tablet);
        }
        request.addToDeviceIds(tablet.deviceId);
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        for (MeasurementSchema measurementSchema : tablet.getSchemas()) {
            measurements.add(measurementSchema.getMeasurementId());
            dataTypes.add(measurementSchema.getType().ordinal());
        }
        request.addToMeasurementsList(measurements);
        request.addToTypesList(dataTypes);
        request.addToTimestampsList(SessionUtils.getTimeBuffer(tablet));
        request.addToValuesList(SessionUtils.getValueBuffer(tablet));
        request.addToSizeList(tablet.rowSize);
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablet(tablet, false);
    }

    public void testInsertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted);
        this.defaultSessionConnection.testInsertTablet(request);
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablets(tablets, false);
    }

    public void testInsertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted);
        this.defaultSessionConnection.testInsertTablets(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsReq request = this.genTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList);
        this.defaultSessionConnection.testInsertRecords(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList);
        this.defaultSessionConnection.testInsertRecords(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request = this.genTSInsertStringRecordReq(deviceId, time, measurements, values);
        this.defaultSessionConnection.testInsertRecord(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, values);
        this.defaultSessionConnection.testInsertRecord(request);
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteTimeseries(Collections.singletonList(path));
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        this.defaultSessionConnection.deleteTimeseries(paths);
    }

    public void deleteData(String path, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(Collections.singletonList(path), Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(paths, Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        TSDeleteDataReq request = this.genTSDeleteDataReq(paths, startTime, endTime);
        this.defaultSessionConnection.deleteData(request);
    }

    private TSDeleteDataReq genTSDeleteDataReq(List<String> paths, long startTime, long endTime) {
        TSDeleteDataReq request = new TSDeleteDataReq();
        request.setPaths(paths);
        request.setStartTime(startTime);
        request.setEndTime(endTime);
        return request;
    }

    private int calculateLength(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        int res = 0;
        block8: for (int i = 0; i < types.size(); ++i) {
            ++res;
            switch (types.get(i)) {
                case BOOLEAN: {
                    ++res;
                    continue block8;
                }
                case INT32: {
                    res += 4;
                    continue block8;
                }
                case INT64: {
                    res += 8;
                    continue block8;
                }
                case FLOAT: {
                    res += 4;
                    continue block8;
                }
                case DOUBLE: {
                    res += 8;
                    continue block8;
                }
                case TEXT: {
                    res += 4;
                    res += ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET).length;
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException(MSG_UNSUPPORTED_DATA_TYPE + types.get(i));
                }
            }
        }
        return res;
    }

    private void putValues(List<TSDataType> types, List<Object> values, ByteBuffer buffer) throws IoTDBConnectionException {
        block8: for (int i = 0; i < values.size(); ++i) {
            ReadWriteIOUtils.write((TSDataType)types.get(i), (ByteBuffer)buffer);
            switch (types.get(i)) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)values.get(i)).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    byte[] bytes = ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET);
                    ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                    buffer.put(bytes);
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException(MSG_UNSUPPORTED_DATA_TYPE + types.get(i));
                }
            }
        }
        buffer.flip();
    }

    private boolean checkSorted(Tablet tablet) {
        for (int i = 1; i < tablet.rowSize; ++i) {
            if (tablet.timestamps[i] >= tablet.timestamps[i - 1]) continue;
            return false;
        }
        return true;
    }

    private boolean checkSorted(List<Long> times) {
        for (int i = 1; i < times.size(); ++i) {
            if (times.get(i) >= times.get(i - 1)) continue;
            return false;
        }
        return true;
    }

    private void checkSortedThrowable(Tablet tablet) throws BatchExecutionException {
        if (!this.checkSorted(tablet)) {
            throw new BatchExecutionException("Times in Tablet are not in ascending order");
        }
    }

    protected void sortTablet(Tablet tablet) {
        int i;
        Integer[] index = new Integer[tablet.rowSize];
        for (i = 0; i < tablet.rowSize; ++i) {
            index[i] = i;
        }
        Arrays.sort(index, Comparator.comparingLong(o -> tablet.timestamps[o]));
        Arrays.sort(tablet.timestamps, 0, tablet.rowSize);
        for (i = 0; i < tablet.getSchemas().size(); ++i) {
            tablet.values[i] = this.sortList(tablet.values[i], ((MeasurementSchema)tablet.getSchemas().get(i)).getType(), index);
        }
    }

    private Object sortList(Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] sortedValues = new boolean[boolValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedValues[i] = boolValues[index[i]];
                }
                return sortedValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] sortedIntValues = new int[intValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedIntValues[i] = intValues[index[i]];
                }
                return sortedIntValues;
            }
            case INT64: {
                long[] longValues = (long[])valueList;
                long[] sortedLongValues = new long[longValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedLongValues[i] = longValues[index[i]];
                }
                return sortedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] sortedFloatValues = new float[floatValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedFloatValues[i] = floatValues[index[i]];
                }
                return sortedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] sortedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedDoubleValues[i] = doubleValues[index[i]];
                }
                return sortedDoubleValues;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] sortedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedBinaryValues[i] = binaryValues[index[i]];
                }
                return sortedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(MSG_UNSUPPORTED_DATA_TYPE + dataType);
    }

    public boolean isEnableQueryRedirection() {
        return this.enableQueryRedirection;
    }

    public void setEnableQueryRedirection(boolean enableQueryRedirection) {
        this.enableQueryRedirection = enableQueryRedirection;
    }
}

