/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.upgrade;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.v2.read.TsFileSequenceReaderForV2;
import org.apache.iotdb.tsfile.v2.read.reader.page.PageReaderV2;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileOnlineUpgradeTool
extends TsFileRewriteTool {
    private static final Logger logger = LoggerFactory.getLogger(TsFileOnlineUpgradeTool.class);

    public TsFileOnlineUpgradeTool(TsFileResource resourceToBeUpgraded) throws IOException {
        super(resourceToBeUpgraded, true);
    }

    public static void upgradeOneTsFile(TsFileResource resourceToBeUpgraded, List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        try (TsFileOnlineUpgradeTool updater = new TsFileOnlineUpgradeTool(resourceToBeUpgraded);){
            updater.upgradeFile(upgradedResources);
        }
    }

    private void upgradeFile(List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        if (!this.fileCheck()) {
            return;
        }
        int headerLength = "TsFile".getBytes().length + "000002".getBytes().length;
        this.reader.position((long)headerLength);
        ArrayList<List<PageHeader>> pageHeadersInChunkGroup = new ArrayList<List<PageHeader>>();
        ArrayList<List<ByteBuffer>> pageDataInChunkGroup = new ArrayList<List<ByteBuffer>>();
        ArrayList<List<Boolean>> needToDecodeInfoInChunkGroup = new ArrayList<List<Boolean>>();
        ArrayList<MeasurementSchema> measurementSchemaList = new ArrayList<MeasurementSchema>();
        try {
            byte marker;
            block10: while ((marker = this.reader.readMarker()) != 2) {
                switch (marker) {
                    case 1: {
                        PageHeader pageHeader;
                        ChunkHeader header = ((TsFileSequenceReaderForV2)this.reader).readChunkHeader();
                        MeasurementSchema measurementSchema = new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
                        measurementSchemaList.add(measurementSchema);
                        TSDataType dataType = header.getDataType();
                        TSEncoding encoding = header.getEncodingType();
                        ArrayList<PageHeader> pageHeadersInChunk = new ArrayList<PageHeader>();
                        ArrayList<ByteBuffer> dataInChunk = new ArrayList<ByteBuffer>();
                        ArrayList<Boolean> needToDecodeInfo = new ArrayList<Boolean>();
                        for (int dataSize = header.getDataSize(); dataSize > 0; dataSize -= 32 + (pageHeader.getStatistics().getStatsSize() - (dataType == TSDataType.BOOLEAN ? 8 : 0)) + pageHeader.getCompressedSize()) {
                            pageHeader = ((TsFileSequenceReaderForV2)this.reader).readPageHeader(dataType);
                            boolean needToDecode = this.checkIfNeedToDecode(dataType, encoding, pageHeader);
                            needToDecodeInfo.add(needToDecode);
                            ByteBuffer pageData = !needToDecode ? ((TsFileSequenceReaderForV2)this.reader).readCompressedPage(pageHeader) : this.reader.readPage(pageHeader, header.getCompressionType());
                            pageHeadersInChunk.add(pageHeader);
                            dataInChunk.add(pageData);
                        }
                        pageHeadersInChunkGroup.add(pageHeadersInChunk);
                        pageDataInChunkGroup.add(dataInChunk);
                        needToDecodeInfoInChunkGroup.add(needToDecodeInfo);
                        continue block10;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupFooter = ((TsFileSequenceReaderForV2)this.reader).readChunkGroupFooter();
                        String deviceID = chunkGroupFooter.getDeviceID();
                        this.rewrite(deviceID, measurementSchemaList, pageHeadersInChunkGroup, pageDataInChunkGroup, needToDecodeInfoInChunkGroup);
                        pageHeadersInChunkGroup.clear();
                        pageDataInChunkGroup.clear();
                        measurementSchemaList.clear();
                        needToDecodeInfoInChunkGroup.clear();
                        continue block10;
                    }
                    case 3: {
                        long version = ((TsFileSequenceReaderForV2)this.reader).readVersion();
                        if (this.oldModification != null && this.modsIterator.hasNext()) {
                            if (this.currentMod == null) {
                                this.currentMod = (Deletion)this.modsIterator.next();
                            }
                            if (this.currentMod.getFileOffset() <= version) {
                                for (Map.Entry entry : this.fileModificationMap.entrySet()) {
                                    TsFileIOWriter tsFileIOWriter = (TsFileIOWriter)entry.getKey();
                                    ModificationFile newMods = (ModificationFile)entry.getValue();
                                    newMods.write(new Deletion(this.currentMod.getPath(), tsFileIOWriter.getFile().length(), this.currentMod.getStartTime(), this.currentMod.getEndTime()));
                                }
                                this.currentMod = null;
                            }
                        }
                        for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                            tsFileIOWriter.writePlanIndices();
                        }
                        continue block10;
                    }
                }
                throw new IOException("Unrecognized marker detected, this file may be corrupted");
            }
            for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                upgradedResources.add(this.endFileAndGenerateResource(tsFileIOWriter));
            }
            if (this.oldModification != null) {
                while (this.currentMod != null || this.modsIterator.hasNext()) {
                    if (this.currentMod == null) {
                        this.currentMod = (Deletion)this.modsIterator.next();
                    }
                    for (Map.Entry entry : this.fileModificationMap.entrySet()) {
                        TsFileIOWriter tsFileIOWriter = (TsFileIOWriter)entry.getKey();
                        ModificationFile newMods = (ModificationFile)entry.getValue();
                        newMods.write(new Deletion(this.currentMod.getPath(), tsFileIOWriter.getFile().length(), this.currentMod.getStartTime(), this.currentMod.getEndTime()));
                    }
                    this.currentMod = null;
                }
            }
        }
        catch (IOException e2) {
            throw new IOException("TsFile upgrade process cannot proceed at position " + this.reader.position() + "because: " + e2.getMessage());
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    @Override
    public String upgradeTsFileName(String oldTsFileName) {
        String[] name = oldTsFileName.split(".tsfile");
        return name[0] + "-0" + ".tsfile";
    }

    @Override
    protected boolean checkIfNeedToDecode(TSDataType dataType, TSEncoding encoding, PageHeader pageHeader) {
        return dataType == TSDataType.BOOLEAN || dataType == TSDataType.TEXT || dataType == TSDataType.INT32 && encoding == TSEncoding.PLAIN || StorageEngine.getTimePartition(pageHeader.getStartTime()) != StorageEngine.getTimePartition(pageHeader.getEndTime());
    }

    @Override
    protected void decodeAndWritePageInToFiles(MeasurementSchema schema, ByteBuffer pageData, Map<Long, Map<MeasurementSchema, ChunkWriterImpl>> chunkWritersInChunkGroup) throws IOException {
        this.valueDecoder.reset();
        PageReaderV2 pageReader = new PageReaderV2(pageData, schema.getType(), this.valueDecoder, this.defaultTimeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        this.rewritePageIntoFiles(batchData, schema, chunkWritersInChunkGroup);
    }

    @Override
    protected boolean fileCheck() throws IOException {
        String magic = this.reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        String versionNumber = ((TsFileSequenceReaderForV2)this.reader).readVersionNumberV2();
        if (!versionNumber.equals("000002")) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        if (!this.reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        return true;
    }
}

