/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveArrayManager {
    private static final Map<TSDataType, ArrayDeque<Object>> bufferedArraysMap = new EnumMap<TSDataType, ArrayDeque<Object>>(TSDataType.class);
    private static final Map<TSDataType, Integer> bufferedArraysNumMap = new EnumMap<TSDataType, Integer>(TSDataType.class);
    private static final Map<TSDataType, Double> bufferedArraysNumRatio = new EnumMap<TSDataType, Double>(TSDataType.class);
    private static final Logger logger = LoggerFactory.getLogger(PrimitiveArrayManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final int ARRAY_SIZE = config.getPrimitiveArraySize();
    private static final double BUFFERED_ARRAY_SIZE_THRESHOLD = (double)config.getAllocateMemoryForWrite() * config.getBufferedArraysMemoryProportion();
    private static AtomicLong bufferedArraysRamSize = new AtomicLong();
    private static AtomicLong outOfBufferArraysRamSize = new AtomicLong();

    private PrimitiveArrayManager() {
        logger.info("BufferedArraySizeThreshold is {}", (Object)BUFFERED_ARRAY_SIZE_THRESHOLD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getPrimitiveArraysByType(TSDataType dataType) {
        if ((double)(bufferedArraysRamSize.get() + (long)(ARRAY_SIZE * dataType.getDataTypeSize())) > BUFFERED_ARRAY_SIZE_THRESHOLD) {
            outOfBufferArraysRamSize.addAndGet((long)ARRAY_SIZE * (long)dataType.getDataTypeSize());
            return PrimitiveArrayManager.createPrimitiveArray(dataType);
        }
        ArrayDeque<Object> arrayDeque = bufferedArraysMap.get(dataType);
        synchronized (arrayDeque) {
            Object dataArray = bufferedArraysMap.get(dataType).poll();
            if (dataArray != null) {
                return dataArray;
            }
            bufferedArraysNumMap.put(dataType, bufferedArraysNumMap.getOrDefault(dataType, 0) + 1);
            bufferedArraysRamSize.addAndGet((long)ARRAY_SIZE * (long)dataType.getDataTypeSize());
        }
        return PrimitiveArrayManager.createPrimitiveArray(dataType);
    }

    private static Object createPrimitiveArray(TSDataType dataType) {
        Object[] dataArray;
        switch (dataType) {
            case BOOLEAN: {
                dataArray = new boolean[ARRAY_SIZE];
                break;
            }
            case INT32: {
                dataArray = new int[ARRAY_SIZE];
                break;
            }
            case INT64: {
                dataArray = new long[ARRAY_SIZE];
                break;
            }
            case FLOAT: {
                dataArray = new float[ARRAY_SIZE];
                break;
            }
            case DOUBLE: {
                dataArray = new double[ARRAY_SIZE];
                break;
            }
            case TEXT: {
                dataArray = new Binary[ARRAY_SIZE];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(dataType.toString());
            }
        }
        return dataArray;
    }

    public static Object createDataListsByType(TSDataType dataType, int size) {
        int arrayNumber = (int)Math.ceil((float)size / (float)ARRAY_SIZE);
        switch (dataType) {
            case BOOLEAN: {
                boolean[][] booleans = new boolean[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    booleans[i] = new boolean[ARRAY_SIZE];
                }
                return booleans;
            }
            case INT32: {
                int[][] ints = new int[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    ints[i] = new int[ARRAY_SIZE];
                }
                return ints;
            }
            case INT64: {
                long[][] longs = new long[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    longs[i] = new long[ARRAY_SIZE];
                }
                return longs;
            }
            case FLOAT: {
                float[][] floats = new float[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    floats[i] = new float[ARRAY_SIZE];
                }
                return floats;
            }
            case DOUBLE: {
                double[][] doubles = new double[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    doubles[i] = new double[ARRAY_SIZE];
                }
                return doubles;
            }
            case TEXT: {
                Binary[][] binaries = new Binary[arrayNumber][];
                for (int i = 0; i < arrayNumber; ++i) {
                    binaries[i] = new Binary[ARRAY_SIZE];
                }
                return binaries;
            }
        }
        return null;
    }

    public static void release(Object dataArray) {
        TSDataType dataType;
        if (dataArray instanceof boolean[]) {
            dataType = TSDataType.BOOLEAN;
        } else if (dataArray instanceof int[]) {
            dataType = TSDataType.INT32;
        } else if (dataArray instanceof long[]) {
            dataType = TSDataType.INT64;
        } else if (dataArray instanceof float[]) {
            dataType = TSDataType.FLOAT;
        } else if (dataArray instanceof double[]) {
            dataType = TSDataType.DOUBLE;
        } else if (dataArray instanceof Binary[]) {
            Arrays.fill((Binary[])dataArray, null);
            dataType = TSDataType.TEXT;
        } else {
            throw new UnSupportedDataTypeException("Unknown data array type");
        }
        if (outOfBufferArraysRamSize.get() > 0L && PrimitiveArrayManager.isCurrentDataTypeExceeded(dataType)) {
            PrimitiveArrayManager.bringBackOOBArray(dataType, ARRAY_SIZE);
        } else if (outOfBufferArraysRamSize.get() > 0L && !PrimitiveArrayManager.isCurrentDataTypeExceeded(dataType)) {
            TSDataType replacedDataType = null;
            for (Map.Entry<TSDataType, Integer> entry : bufferedArraysNumMap.entrySet()) {
                if (!PrimitiveArrayManager.isCurrentDataTypeExceeded(entry.getKey())) continue;
                replacedDataType = entry.getKey();
                PrimitiveArrayManager.bringBackOOBArray(replacedDataType, ARRAY_SIZE);
                break;
            }
            if (replacedDataType != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The ratio of {} in buffered array has not reached the schema ratio. Replaced by {}", (Object)dataType, replacedDataType);
                }
                PrimitiveArrayManager.bringBackBufferedArray(dataType, dataArray);
            } else {
                PrimitiveArrayManager.bringBackOOBArray(dataType, ARRAY_SIZE);
            }
        } else {
            PrimitiveArrayManager.bringBackBufferedArray(dataType, dataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bringBackBufferedArray(TSDataType dataType, Object dataArray) {
        ArrayDeque<Object> arrayDeque = bufferedArraysMap.get(dataType);
        synchronized (arrayDeque) {
            bufferedArraysMap.get(dataType).add(dataArray);
            bufferedArraysNumMap.put(dataType, bufferedArraysNumMap.getOrDefault(dataType, 0) + 1);
        }
        bufferedArraysRamSize.addAndGet((long)(-ARRAY_SIZE) * (long)dataType.getDataTypeSize());
    }

    private static void bringBackOOBArray(TSDataType dataType, int size) {
        outOfBufferArraysRamSize.addAndGet((long)(-size) * (long)dataType.getDataTypeSize());
    }

    public static void updateSchemaDataTypeNum(Map<TSDataType, Integer> schemaDataTypeNumMap, long total) {
        for (Map.Entry<TSDataType, Integer> entry : schemaDataTypeNumMap.entrySet()) {
            TSDataType dataType = entry.getKey();
            bufferedArraysNumRatio.put(dataType, (double)schemaDataTypeNumMap.get(dataType).intValue() / (double)total);
        }
    }

    private static boolean isCurrentDataTypeExceeded(TSDataType dataType) {
        int total = 0;
        for (int num : bufferedArraysNumMap.values()) {
            total += num;
        }
        return total != 0 && (double)bufferedArraysNumMap.getOrDefault(dataType, 0).intValue() / (double)total > bufferedArraysNumRatio.getOrDefault(dataType, 0.0);
    }

    public static void close() {
        for (ArrayDeque<Object> dataListQueue : bufferedArraysMap.values()) {
            dataListQueue.clear();
        }
        bufferedArraysNumMap.clear();
        bufferedArraysNumRatio.clear();
        bufferedArraysRamSize.set(0L);
        outOfBufferArraysRamSize.set(0L);
    }

    static {
        bufferedArraysMap.put(TSDataType.BOOLEAN, new ArrayDeque());
        bufferedArraysMap.put(TSDataType.INT32, new ArrayDeque());
        bufferedArraysMap.put(TSDataType.INT64, new ArrayDeque());
        bufferedArraysMap.put(TSDataType.FLOAT, new ArrayDeque());
        bufferedArraysMap.put(TSDataType.DOUBLE, new ArrayDeque());
        bufferedArraysMap.put(TSDataType.TEXT, new ArrayDeque());
    }
}

