/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public enum BasicOperatorType {
    EQ{

        @Override
        public <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path path, T value) {
            if (path.equals("time")) {
                return new GlobalTimeExpression((Filter)TimeFilter.eq((long)((Long)value)));
            }
            return new SingleSeriesExpression(path, (Filter)ValueFilter.eq(value));
        }

        @Override
        public <T extends Comparable<T>> Filter getValueFilter(T value) {
            return ValueFilter.eq(value);
        }

        @Override
        public Filter getTimeFilter(long value) {
            return TimeFilter.eq((long)value);
        }
    }
    ,
    LTEQ{

        @Override
        public <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path path, T value) {
            if (path.equals("time")) {
                return new GlobalTimeExpression((Filter)TimeFilter.ltEq((long)((Long)value)));
            }
            return new SingleSeriesExpression(path, (Filter)ValueFilter.ltEq(value));
        }

        @Override
        public <T extends Comparable<T>> Filter getValueFilter(T value) {
            return ValueFilter.ltEq(value);
        }

        @Override
        public Filter getTimeFilter(long value) {
            return TimeFilter.ltEq((long)value);
        }
    }
    ,
    LT{

        @Override
        public <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path path, T value) {
            if (path.equals("time")) {
                return new GlobalTimeExpression((Filter)TimeFilter.lt((long)((Long)value)));
            }
            return new SingleSeriesExpression(path, (Filter)ValueFilter.lt(value));
        }

        @Override
        public <T extends Comparable<T>> Filter getValueFilter(T value) {
            return ValueFilter.lt(value);
        }

        @Override
        public Filter getTimeFilter(long value) {
            return TimeFilter.lt((long)value);
        }
    }
    ,
    GTEQ{

        @Override
        public <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path path, T value) {
            if (path.equals("time")) {
                return new GlobalTimeExpression((Filter)TimeFilter.gtEq((long)((Long)value)));
            }
            return new SingleSeriesExpression(path, (Filter)ValueFilter.gtEq(value));
        }

        @Override
        public <T extends Comparable<T>> Filter getValueFilter(T value) {
            return ValueFilter.gtEq(value);
        }

        @Override
        public Filter getTimeFilter(long value) {
            return TimeFilter.gtEq((long)value);
        }
    }
    ,
    GT{

        @Override
        public <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path path, T value) {
            if (path.equals("time")) {
                return new GlobalTimeExpression((Filter)TimeFilter.gt((long)((Long)value)));
            }
            return new SingleSeriesExpression(path, (Filter)ValueFilter.gt(value));
        }

        @Override
        public <T extends Comparable<T>> Filter getValueFilter(T value) {
            return ValueFilter.gt(value);
        }

        @Override
        public Filter getTimeFilter(long value) {
            return TimeFilter.gt((long)value);
        }
    }
    ,
    NOTEQUAL{

        @Override
        public <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path path, T value) {
            if (path.equals("time")) {
                return new GlobalTimeExpression((Filter)TimeFilter.notEq((long)((Long)value)));
            }
            return new SingleSeriesExpression(path, (Filter)ValueFilter.notEq(value));
        }

        @Override
        public <T extends Comparable<T>> Filter getValueFilter(T value) {
            return ValueFilter.notEq(value);
        }

        @Override
        public Filter getTimeFilter(long value) {
            return TimeFilter.notEq((long)value);
        }
    };


    public static BasicOperatorType getBasicOpBySymbol(int tokenIntType) throws SQLParserException {
        switch (tokenIntType) {
            case 154: {
                return EQ;
            }
            case 158: {
                return LTEQ;
            }
            case 157: {
                return LT;
            }
            case 156: {
                return GTEQ;
            }
            case 155: {
                return GT;
            }
            case 159: {
                return NOTEQUAL;
            }
        }
        throw new SQLParserException("unsupported type:{}" + SQLConstant.tokenNames.get(tokenIntType));
    }

    public abstract <T extends Comparable<T>> IUnaryExpression getUnaryExpression(Path var1, T var2);

    public abstract <T extends Comparable<T>> Filter getValueFilter(T var1);

    public abstract Filter getTimeFilter(long var1);
}

