/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.db.writelog.io.LogWriter;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MLogWriter.class);
    private final File logFile;
    private LogWriter logWriter;
    private int logNum;
    private static final String DELETE_FAILED_FORMAT = "Deleting %s failed with exception %s";
    private final ByteBuffer mlogBuffer = ByteBuffer.allocate(IoTDBDescriptor.getInstance().getConfig().getMlogBufferSize());
    private static final String LOG_TOO_LARGE_INFO = "Log cannot fit into buffer, please increase mlog_buffer_size";

    public MLogWriter(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            if (metadataDir.mkdirs()) {
                logger.info("create schema folder {}.", (Object)metadataDir);
            } else {
                logger.warn("create schema folder {} failed.", (Object)metadataDir);
            }
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.logWriter = new LogWriter(this.logFile, false);
    }

    public MLogWriter(String logFilePath) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.logWriter = new LogWriter(this.logFile, false);
    }

    @Override
    public void close() throws IOException {
        this.logWriter.close();
    }

    private void sync() {
        try {
            this.logWriter.write(this.mlogBuffer);
        }
        catch (IOException e) {
            logger.error("MLog {} sync failed, change system mode to read-only", (Object)this.logFile.getAbsoluteFile(), (Object)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        this.mlogBuffer.clear();
    }

    private synchronized void putLog(PhysicalPlan plan) throws IOException {
        try {
            plan.serialize(this.mlogBuffer);
            this.sync();
            ++this.logNum;
        }
        catch (BufferOverflowException e) {
            throw new IOException(LOG_TOO_LARGE_INFO, e);
        }
    }

    public void createTimeseries(CreateTimeSeriesPlan createTimeSeriesPlan) throws IOException {
        this.putLog(createTimeSeriesPlan);
    }

    public void deleteTimeseries(DeleteTimeSeriesPlan deleteTimeSeriesPlan) throws IOException {
        this.putLog(deleteTimeSeriesPlan);
    }

    public void setStorageGroup(PartialPath storageGroup) throws IOException {
        SetStorageGroupPlan plan = new SetStorageGroupPlan(storageGroup);
        this.putLog(plan);
    }

    public void deleteStorageGroup(PartialPath storageGroup) throws IOException {
        DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(Collections.singletonList(storageGroup));
        this.putLog(plan);
    }

    public void setTTL(PartialPath storageGroup, long ttl) throws IOException {
        SetTTLPlan plan = new SetTTLPlan(storageGroup, ttl);
        this.putLog(plan);
    }

    public void changeOffset(PartialPath path, long offset) throws IOException {
        ChangeTagOffsetPlan plan = new ChangeTagOffsetPlan(path, offset);
        this.putLog(plan);
    }

    public void changeAlias(PartialPath path, String alias) throws IOException {
        ChangeAliasPlan plan = new ChangeAliasPlan(path, alias);
        this.putLog(plan);
    }

    public void serializeMNode(MNode node) throws IOException {
        int childSize = 0;
        if (node.getChildren() != null) {
            childSize = node.getChildren().size();
        }
        MNodePlan plan = new MNodePlan(node.getName(), childSize);
        this.putLog(plan);
    }

    public void serializeMeasurementMNode(MeasurementMNode node) throws IOException {
        int childSize = 0;
        if (node.getChildren() != null) {
            childSize = node.getChildren().size();
        }
        MeasurementMNodePlan plan = new MeasurementMNodePlan(node.getName(), node.getAlias(), node.getOffset(), childSize, node.getSchema());
        this.putLog(plan);
    }

    public void serializeStorageGroupMNode(StorageGroupMNode node) throws IOException {
        int childSize = 0;
        if (node.getChildren() != null) {
            childSize = node.getChildren().size();
        }
        StorageGroupMNodePlan plan = new StorageGroupMNodePlan(node.getName(), node.getDataTTL(), childSize);
        this.putLog(plan);
    }

    /*
     * Exception decompiling
     */
    public static void upgradeTxtToBin(String schemaDir, String oldFileName, String newFileName, boolean isSnapshot) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void upgradeMLog() throws IOException {
        String schemaDir = IoTDBDescriptor.getInstance().getConfig().getSchemaDir();
        MLogWriter.upgradeTxtToBin(schemaDir, "mlog.txt", "mlog.bin", false);
        MLogWriter.upgradeTxtToBin(schemaDir, "mtree-1.snapshot", "mtree-1.snapshot.bin", true);
    }

    public synchronized void clear() throws IOException {
        this.sync();
        this.logWriter.close();
        this.mlogBuffer.clear();
        if (this.logFile != null && this.logFile.exists()) {
            Files.delete(this.logFile.toPath());
        }
        this.logNum = 0;
        this.logWriter = new LogWriter(this.logFile, false);
    }

    public int getLogNum() {
        return this.logNum;
    }

    public void setLogNum(int number) {
        this.logNum = number;
    }

    public void operation(String cmd, boolean isSnapshot) throws IOException, MetadataException {
        if (!isSnapshot) {
            this.operation(cmd);
        } else {
            PhysicalPlan plan = MLogWriter.convertFromString(cmd);
            if (plan != null) {
                this.putLog(plan);
            }
        }
    }

    public void operation(String cmd) throws IOException, MetadataException {
        String[] args = cmd.trim().split(",", -1);
        switch (args[0]) {
            case "0": {
                if (args.length > 8) {
                    int i;
                    String[] tmpArgs = new String[8];
                    tmpArgs[0] = args[0];
                    tmpArgs[1] = "";
                    for (i = 1; i < args.length - 7; ++i) {
                        tmpArgs[1] = tmpArgs[1] + args[i] + ",";
                    }
                    tmpArgs[1] = tmpArgs[1] + args[i++];
                    for (int j = 2; j < 8; ++j) {
                        tmpArgs[j] = args[i++];
                    }
                    args = tmpArgs;
                }
                HashMap<String, String> props = null;
                if (!args[5].isEmpty()) {
                    String[] keyValues = args[5].split("&");
                    props = new HashMap<String, String>();
                    for (String keyValue : keyValues) {
                        String[] kv = keyValue.split("=");
                        props.put(kv[0], kv[1]);
                    }
                }
                String alias = null;
                if (!args[6].isEmpty()) {
                    alias = args[6];
                }
                long offset = -1L;
                if (!args[7].isEmpty()) {
                    offset = Long.parseLong(args[7]);
                }
                CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(new PartialPath(args[1]), TSDataType.deserialize((byte)((byte)Short.parseShort(args[2]))), TSEncoding.deserialize((byte)((byte)Short.parseShort(args[3]))), CompressionType.deserialize((byte)((byte)Short.parseShort(args[4]))), props, null, null, alias);
                plan.setTagOffset(offset);
                this.createTimeseries(plan);
                break;
            }
            case "1": {
                if (args.length > 2) {
                    StringBuilder tmp = new StringBuilder();
                    for (int i = 1; i < args.length - 1; ++i) {
                        tmp.append(args[i]).append(",");
                    }
                    tmp.append(args[args.length - 1]);
                    args[1] = tmp.toString();
                }
                this.deleteTimeseries(new DeleteTimeSeriesPlan(Collections.singletonList(new PartialPath(args[1]))));
                break;
            }
            case "2": {
                try {
                    this.setStorageGroup(new PartialPath(args[1]));
                }
                catch (MetadataException e) {
                    logger.info("concurrently operate set storage group cmd {} twice", (Object)cmd);
                }
                break;
            }
            case "11": {
                this.deleteStorageGroup(new PartialPath(args[1]));
                break;
            }
            case "10": {
                this.setTTL(new PartialPath(args[1]), Long.parseLong(args[2]));
                break;
            }
            case "12": {
                this.changeOffset(new PartialPath(args[1]), Long.parseLong(args[2]));
                break;
            }
            case "13": {
                this.changeAlias(new PartialPath(args[1]), args[2]);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)cmd);
            }
        }
    }

    public void force() throws IOException {
        this.logWriter.force();
    }

    public static PhysicalPlan convertFromString(String str) {
        String[] words = str.split(",");
        switch (words[0]) {
            case "2": {
                return new MeasurementMNodePlan(words[1], words[2].equals("") ? null : words[2], Long.parseLong(words[words.length - 2]), Integer.parseInt(words[words.length - 1]), new MeasurementSchema(words[1], TSDataType.values()[Integer.parseInt(words[3])], TSEncoding.values()[Integer.parseInt(words[4])], CompressionType.values()[Integer.parseInt(words[5])]));
            }
            case "1": {
                return new StorageGroupMNodePlan(words[1], Long.parseLong(words[2]), Integer.parseInt(words[3]));
            }
            case "0": {
                return new MNodePlan(words[1], Integer.parseInt(words[2]));
            }
        }
        logger.error("unknown cmd {}", (Object)str);
        return null;
    }
}

