/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.level;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogAnalyzer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionLogger;
import org.apache.iotdb.db.engine.compaction.utils.CompactionUtils;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelCompactionTsFileManagement
extends TsFileManagement {
    private static final Logger logger = LoggerFactory.getLogger(LevelCompactionTsFileManagement.class);
    private final int seqLevelNum = Math.max(IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum(), 1);
    private final int seqFileNumInEachLevel = Math.max(IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel(), 1);
    private final int unseqLevelNum = Math.max(IoTDBDescriptor.getInstance().getConfig().getUnseqLevelNum(), 1);
    private final int unseqFileNumInEachLevel = Math.max(IoTDBDescriptor.getInstance().getConfig().getUnseqFileNumInEachLevel(), 1);
    private final boolean enableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
    private final Map<Long, List<SortedSet<TsFileResource>>> sequenceTsFileResources = new HashMap<Long, List<SortedSet<TsFileResource>>>();
    private final Map<Long, List<List<TsFileResource>>> unSequenceTsFileResources = new HashMap<Long, List<List<TsFileResource>>>();
    private final List<List<TsFileResource>> forkedSequenceTsFileResources = new ArrayList<List<TsFileResource>>();
    private final List<List<TsFileResource>> forkedUnSequenceTsFileResources = new ArrayList<List<TsFileResource>>();
    private final List<TsFileResource> sequenceRecoverTsFileResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSequenceRecoverTsFileResources = new ArrayList<TsFileResource>();

    public LevelCompactionTsFileManagement(String storageGroupName, String storageGroupDir) {
        super(storageGroupName, storageGroupDir);
        this.clear();
    }

    public void renameLevelFilesMods(Collection<Modification> filterModification, Collection<TsFileResource> mergeTsFiles, TsFileResource targetTsFile) throws IOException {
        logger.debug("{} [compaction] merge starts to rename real file's mod", (Object)this.storageGroupName);
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            try (ModificationFile sourceModificationFile = new ModificationFile(mergeTsFile.getTsFilePath() + ".mods");){
                modifications.addAll(sourceModificationFile.getModifications());
                if (!sourceModificationFile.exists()) continue;
                sourceModificationFile.remove();
            }
        }
        modifications.removeAll(filterModification);
        if (!modifications.isEmpty()) {
            try (ModificationFile modificationFile = new ModificationFile(targetTsFile.getTsFilePath() + ".mods");){
                for (Modification modification : modifications) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    modificationFile.write(modification);
                }
            }
        }
    }

    private void deleteLevelFilesInDisk(Collection<TsFileResource> mergeTsFiles) {
        logger.debug("{} [compaction] merge starts to delete real file", (Object)this.storageGroupName);
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            this.deleteLevelFile(mergeTsFile);
            logger.debug("{} [Compaction] delete TsFile {}", (Object)this.storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
    }

    private void deleteLevelFilesInList(long timePartitionId, Collection<TsFileResource> mergeTsFiles, int level, boolean sequence) {
        logger.debug("{} [compaction] merge starts to delete file list", (Object)this.storageGroupName);
        if (sequence) {
            if (this.sequenceTsFileResources.containsKey(timePartitionId) && this.sequenceTsFileResources.get(timePartitionId).size() > level) {
                this.sequenceTsFileResources.get(timePartitionId).get(level).removeAll(mergeTsFiles);
            }
        } else if (this.unSequenceTsFileResources.containsKey(timePartitionId) && this.unSequenceTsFileResources.get(timePartitionId).size() > level) {
            this.unSequenceTsFileResources.get(timePartitionId).get(level).removeAll(mergeTsFiles);
        }
    }

    private void deleteLevelFile(TsFileResource seqFile) {
        seqFile.writeLock();
        try {
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            seqFile.setDeleted(true);
            seqFile.delete();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            seqFile.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public List<TsFileResource> getTsFileList(boolean sequence) {
        this.readLock();
        try {
            Object object;
            ArrayList<TsFileResource> result = new ArrayList<TsFileResource>();
            if (sequence) {
                object = this.sequenceTsFileResources.keySet().iterator();
                while (object.hasNext()) {
                    long timePartition = object.next();
                    result.addAll(this.getTsFileListByTimePartition(true, timePartition));
                }
            } else {
                object = this.unSequenceTsFileResources.keySet().iterator();
                while (object.hasNext()) {
                    long timePartition = object.next();
                    result.addAll(this.getTsFileListByTimePartition(false, timePartition));
                }
            }
            object = result;
            return object;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TsFileResource> getTsFileListByTimePartition(boolean sequence, long timePartition) {
        this.readLock();
        try {
            ArrayList<TsFileResource> result = new ArrayList<TsFileResource>();
            if (sequence) {
                List<SortedSet<TsFileResource>> sequenceTsFileList = this.sequenceTsFileResources.get(timePartition);
                for (int i = sequenceTsFileList.size() - 1; i >= 0; --i) {
                    result.addAll((Collection)sequenceTsFileList.get(i));
                }
            } else {
                List<List<TsFileResource>> unSequenceTsFileList = this.unSequenceTsFileResources.get(timePartition);
                for (int i = unSequenceTsFileList.size() - 1; i >= 0; --i) {
                    result.addAll((Collection)unSequenceTsFileList.get(i));
                }
            }
            ArrayList<TsFileResource> arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public Iterator<TsFileResource> getIterator(boolean sequence) {
        this.readLock();
        try {
            Iterator<TsFileResource> iterator = this.getTsFileList(sequence).iterator();
            return iterator;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock();
        try {
            if (sequence) {
                for (SortedSet<TsFileResource> sequenceTsFileResource : this.sequenceTsFileResources.get(tsFileResource.getTimePartition())) {
                    sequenceTsFileResource.remove(tsFileResource);
                }
            } else {
                for (List<TsFileResource> unSequenceTsFileResource : this.unSequenceTsFileResources.get(tsFileResource.getTimePartition())) {
                    unSequenceTsFileResource.remove(tsFileResource);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock();
        try {
            if (sequence) {
                for (List<SortedSet<TsFileResource>> partitionSequenceTsFileResource : this.sequenceTsFileResources.values()) {
                    for (SortedSet<TsFileResource> levelTsFileResource : partitionSequenceTsFileResource) {
                        levelTsFileResource.removeAll(tsFileResourceList);
                    }
                }
            } else {
                for (List<List<TsFileResource>> partitionUnSequenceTsFileResource : this.unSequenceTsFileResources.values()) {
                    for (List<TsFileResource> levelTsFileResource : partitionUnSequenceTsFileResource) {
                        levelTsFileResource.removeAll(tsFileResourceList);
                    }
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TsFileResource tsFileResource, boolean sequence) throws IOException {
        this.writeLock();
        try {
            long timePartitionId = tsFileResource.getTimePartition();
            int level = TsFileResource.getMergeLevel(tsFileResource.getTsFile().getName());
            if (sequence) {
                if (level <= this.seqLevelNum - 1) {
                    ((SortedSet)this.sequenceTsFileResources.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).get(level)).add(tsFileResource);
                } else {
                    ((SortedSet)this.sequenceTsFileResources.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).get(this.seqLevelNum - 1)).add(tsFileResource);
                }
            } else if (level <= this.unseqLevelNum - 1) {
                ((List)this.unSequenceTsFileResources.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).get(level)).add(tsFileResource);
            } else {
                ((List)this.unSequenceTsFileResources.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).get(this.unseqLevelNum - 1)).add(tsFileResource);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void addRecover(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            this.sequenceRecoverTsFileResources.add(tsFileResource);
        } else {
            this.unSequenceRecoverTsFileResources.add(tsFileResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) throws IOException {
        this.writeLock();
        try {
            for (TsFileResource tsFileResource : tsFileResourceList) {
                this.add(tsFileResource, sequence);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        this.readLock();
        try {
            if (sequence) {
                for (SortedSet sequenceTsFileResource : this.sequenceTsFileResources.computeIfAbsent(tsFileResource.getTimePartition(), this::newSequenceTsFileResources)) {
                    if (!sequenceTsFileResource.contains(tsFileResource)) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                for (List unSequenceTsFileResource : this.unSequenceTsFileResources.computeIfAbsent(tsFileResource.getTimePartition(), this::newUnSequenceTsFileResources)) {
                    if (!unSequenceTsFileResource.contains(tsFileResource)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void clear() {
        this.writeLock();
        try {
            this.sequenceTsFileResources.clear();
            this.unSequenceTsFileResources.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(boolean sequence) {
        this.readLock();
        try {
            if (sequence) {
                for (List<SequencedCollection<TsFileResource>> list : this.sequenceTsFileResources.values()) {
                    for (SortedSet sortedSet : list) {
                        if (sortedSet.isEmpty()) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            } else {
                for (List<SequencedCollection<TsFileResource>> list : this.unSequenceTsFileResources.values()) {
                    for (List list2 : list) {
                        if (list2.isEmpty()) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(boolean sequence) {
        this.readLock();
        try {
            int result = 0;
            if (sequence) {
                for (List<SequencedCollection<TsFileResource>> list : this.sequenceTsFileResources.values()) {
                    for (int i = this.seqLevelNum - 1; i >= 0; --i) {
                        result += ((SortedSet)list.get(i)).size();
                    }
                }
            } else {
                for (List<SequencedCollection<TsFileResource>> list : this.unSequenceTsFileResources.values()) {
                    for (int i = this.unseqLevelNum - 1; i >= 0; --i) {
                        result += ((List)list.get(i)).size();
                    }
                }
            }
            int n = result;
            return n;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover() {
        block34: {
            File logFile = FSFactoryProducer.getFSFactory().getFile(this.storageGroupDir, this.storageGroupName + ".compaction.log");
            try {
                if (!logFile.exists()) break block34;
                CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(logFile);
                logAnalyzer.analyze();
                Set<String> deviceSet = logAnalyzer.getDeviceSet();
                List<String> sourceFileList = logAnalyzer.getSourceFiles();
                long offset = logAnalyzer.getOffset();
                String targetFile = logAnalyzer.getTargetFile();
                boolean fullMerge = logAnalyzer.isFullMerge();
                boolean isSeq = logAnalyzer.isSeq();
                if (targetFile == null || sourceFileList.isEmpty()) {
                    return;
                }
                File target = new File(targetFile);
                if (deviceSet.isEmpty()) {
                    if (target.exists()) {
                        Files.delete(target.toPath());
                    }
                    return;
                }
                if (fullMerge) {
                    TsFileResource targetTsFileResource = this.getRecoverTsFileResource(targetFile, isSeq);
                    long timePartition = targetTsFileResource.getTimePartition();
                    RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(target);
                    if (writer.hasCrashed()) {
                        if (offset > 0L) {
                            writer.getIOWriterOut().truncate(offset - 1L);
                        }
                        writer.close();
                        CompactionLogger compactionLogger = new CompactionLogger(this.storageGroupDir, this.storageGroupName);
                        ArrayList<Modification> modifications = new ArrayList<Modification>();
                        CompactionUtils.merge(targetTsFileResource, this.getTsFileList(isSeq), this.storageGroupName, compactionLogger, deviceSet, isSeq, modifications);
                        compactionLogger.close();
                    } else {
                        writer.close();
                    }
                    this.deleteAllSubLevelFiles(isSeq, timePartition);
                    break block34;
                }
                TsFileResource targetResource = this.getRecoverTsFileResource(targetFile, isSeq);
                long timePartition = targetResource.getTimePartition();
                ArrayList<TsFileResource> sourceTsFileResources = new ArrayList<TsFileResource>();
                for (String file : sourceFileList) {
                    sourceTsFileResources.add(this.getTsFileResource(file, isSeq));
                }
                int level = TsFileResource.getMergeLevel(new File(sourceFileList.get(0)).getName());
                RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(target);
                if (writer.hasCrashed()) {
                    if (offset > 0L) {
                        writer.getIOWriterOut().truncate(offset - 1L);
                    }
                    writer.close();
                    CompactionLogger compactionLogger = new CompactionLogger(this.storageGroupDir, this.storageGroupName);
                    ArrayList<Modification> modifications = new ArrayList<Modification>();
                    CompactionUtils.merge(targetResource, sourceTsFileResources, this.storageGroupName, compactionLogger, deviceSet, isSeq, modifications);
                    this.writeLock();
                    try {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException(String.format("%s [Compaction] abort", this.storageGroupName));
                        }
                        int targetLevel = TsFileResource.getMergeLevel(targetResource.getTsFile().getName());
                        if (isSeq) {
                            this.sequenceTsFileResources.get(timePartition).get(targetLevel).add(targetResource);
                            this.sequenceRecoverTsFileResources.clear();
                        } else {
                            this.unSequenceTsFileResources.get(timePartition).get(targetLevel).add(targetResource);
                            this.unSequenceRecoverTsFileResources.clear();
                        }
                        this.deleteLevelFilesInList(timePartition, sourceTsFileResources, level, isSeq);
                    }
                    finally {
                        this.writeUnlock();
                    }
                    this.deleteLevelFilesInDisk(sourceTsFileResources);
                    this.renameLevelFilesMods(modifications, sourceTsFileResources, targetResource);
                    compactionLogger.close();
                    break block34;
                }
                writer.close();
            }
            catch (IOException | InterruptedException | IllegalPathException e) {
                logger.error("recover level tsfile management error ", (Throwable)e);
            }
            finally {
                if (logFile.exists()) {
                    try {
                        Files.delete(logFile.toPath());
                    }
                    catch (IOException e) {
                        logger.error("delete level tsfile management log file error ", (Throwable)e);
                    }
                }
            }
        }
    }

    private void deleteAllSubLevelFiles(boolean isSeq, long timePartition) {
        if (isSeq) {
            for (int level = 0; level < this.sequenceTsFileResources.get(timePartition).size(); ++level) {
                SortedSet<TsFileResource> currLevelMergeFile = this.sequenceTsFileResources.get(timePartition).get(level);
                this.deleteLevelFilesInDisk(currLevelMergeFile);
                this.deleteLevelFilesInList(timePartition, currLevelMergeFile, level, isSeq);
            }
        } else {
            for (int level = 0; level < this.unSequenceTsFileResources.get(timePartition).size(); ++level) {
                SortedSet<TsFileResource> currLevelMergeFile = this.sequenceTsFileResources.get(timePartition).get(level);
                this.deleteLevelFilesInDisk(currLevelMergeFile);
                this.deleteLevelFilesInList(timePartition, currLevelMergeFile, level, isSeq);
            }
        }
    }

    @Override
    public void forkCurrentFileList(long timePartition) {
        this.readLock();
        try {
            this.forkTsFileList(this.forkedSequenceTsFileResources, this.sequenceTsFileResources.computeIfAbsent(timePartition, this::newSequenceTsFileResources), this.seqLevelNum);
            this.forkTsFileList(this.forkedUnSequenceTsFileResources, this.unSequenceTsFileResources.computeIfAbsent(timePartition, this::newUnSequenceTsFileResources), this.unseqLevelNum + 1);
        }
        finally {
            this.readUnLock();
        }
    }

    private void forkTsFileList(List<List<TsFileResource>> forkedTsFileResources, List rawTsFileResources, int currMaxLevel) {
        forkedTsFileResources.clear();
        for (int i = 0; i < currMaxLevel - 1; ++i) {
            ArrayList<TsFileResource> forkedLevelTsFileResources = new ArrayList<TsFileResource>();
            Collection levelRawTsFileResources = (Collection)rawTsFileResources.get(i);
            for (TsFileResource tsFileResource : levelRawTsFileResources) {
                if (!tsFileResource.isClosed()) continue;
                forkedLevelTsFileResources.add(tsFileResource);
            }
            forkedTsFileResources.add(forkedLevelTsFileResources);
        }
    }

    @Override
    protected void merge(long timePartition) {
        this.isMergeExecutedInCurrentTask = this.merge(this.forkedSequenceTsFileResources, true, timePartition, this.seqLevelNum, this.seqFileNumInEachLevel);
        this.isMergeExecutedInCurrentTask = this.enableUnseqCompaction && this.unseqLevelNum <= 1 && this.forkedUnSequenceTsFileResources.get(0).size() > 0 ? this.merge(this.isForceFullMerge, this.getTsFileListByTimePartition(true, timePartition), this.forkedUnSequenceTsFileResources.get(0), Long.MAX_VALUE) || this.isMergeExecutedInCurrentTask : this.merge(this.forkedUnSequenceTsFileResources, false, timePartition, this.unseqLevelNum, this.unseqFileNumInEachLevel) || this.isMergeExecutedInCurrentTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean merge(List<List<TsFileResource>> mergeResources, boolean sequence, long timePartition, int currMaxLevel, int currMaxFileNumInEachLevel) {
        while (this.isUnseqMerging) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.error("{} [Compaction] shutdown", (Object)this.storageGroupName, (Object)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
        this.isSeqMerging = true;
        long startTimeMillis = System.currentTimeMillis();
        boolean isMergeExecutedInCurrentTask = false;
        CompactionLogger compactionLogger = null;
        try {
            logger.debug("{} start to filter compaction condition", (Object)this.storageGroupName);
            for (int i = 0; i < currMaxLevel - 1; ++i) {
                List<TsFileResource> currLevelTsFileResource = mergeResources.get(i);
                if (currMaxFileNumInEachLevel > currLevelTsFileResource.size()) continue;
                isMergeExecutedInCurrentTask = true;
                if (this.enableUnseqCompaction && !sequence && i == currMaxLevel - 2) {
                    this.isSeqMerging = false;
                    isMergeExecutedInCurrentTask = this.merge(this.isForceFullMerge, this.getTsFileListByTimePartition(true, timePartition), mergeResources.get(i), Long.MAX_VALUE);
                    continue;
                }
                compactionLogger = new CompactionLogger(this.storageGroupDir, this.storageGroupName);
                for (TsFileResource mergeResource : mergeResources.get(i)) {
                    mergeResource.setMerging(true);
                    compactionLogger.logFile("source", mergeResource.getTsFile());
                }
                File newLevelFile = TsFileResource.modifyTsFileNameMergeCnt(mergeResources.get(i).get(0).getTsFile());
                compactionLogger.logSequence(sequence);
                compactionLogger.logFile("target", newLevelFile);
                List<TsFileResource> toMergeTsFiles = mergeResources.get(i).subList(0, currMaxFileNumInEachLevel);
                logger.info("{} [Compaction] merge level-{}'s {} TsFiles to next level", new Object[]{this.storageGroupName, i, toMergeTsFiles.size()});
                for (TsFileResource toMergeTsFile : toMergeTsFiles) {
                    logger.info("{} [Compaction] start to merge TsFile {}", (Object)this.storageGroupName, (Object)toMergeTsFile);
                }
                TsFileResource newResource = new TsFileResource(newLevelFile);
                ArrayList<Modification> modifications = new ArrayList<Modification>();
                CompactionUtils.merge(newResource, toMergeTsFiles, this.storageGroupName, compactionLogger, new HashSet<String>(), sequence, modifications);
                logger.info("{} [Compaction] merged level-{}'s {} TsFiles to next level, and start to delete old files", new Object[]{this.storageGroupName, i, toMergeTsFiles.size()});
                this.writeLock();
                try {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException(String.format("%s [Compaction] abort", this.storageGroupName));
                    }
                    if (sequence) {
                        this.sequenceTsFileResources.get(timePartition).get(i + 1).add(newResource);
                    } else {
                        this.unSequenceTsFileResources.get(timePartition).get(i + 1).add(newResource);
                    }
                    this.deleteLevelFilesInList(timePartition, toMergeTsFiles, i, sequence);
                    if (mergeResources.size() > i + 1) {
                        mergeResources.get(i + 1).add(newResource);
                    }
                }
                finally {
                    this.writeUnlock();
                }
                this.deleteLevelFilesInDisk(toMergeTsFiles);
                this.renameLevelFilesMods(modifications, toMergeTsFiles, newResource);
                compactionLogger.close();
                File logFile = FSFactoryProducer.getFSFactory().getFile(this.storageGroupDir, this.storageGroupName + ".compaction.log");
                if (!logFile.exists()) continue;
                Files.delete(logFile.toPath());
            }
            this.isSeqMerging = false;
        }
        catch (Exception e) {
            try {
                if (compactionLogger != null) {
                    try {
                        compactionLogger.close();
                    }
                    catch (IOException ioException) {
                        logger.error("{} Compaction log close fail", (Object)(this.storageGroupName + ".compaction.log"));
                    }
                }
                isMergeExecutedInCurrentTask = false;
                this.restoreCompaction();
                logger.error("Error occurred in Compaction Merge thread", (Throwable)e);
                this.isSeqMerging = false;
            }
            catch (Throwable throwable) {
                this.isSeqMerging = false;
                logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
                throw throwable;
            }
            logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
        }
        logger.info("{} [Compaction] merge end time isSeq = {}, consumption: {} ms", new Object[]{this.storageGroupName, sequence, System.currentTimeMillis() - startTimeMillis});
        return isMergeExecutedInCurrentTask;
    }

    private List<SortedSet<TsFileResource>> newSequenceTsFileResources(Long k) {
        ArrayList<SortedSet<TsFileResource>> newSequenceTsFileResources = new ArrayList<SortedSet<TsFileResource>>();
        for (int i = 0; i < this.seqLevelNum; ++i) {
            newSequenceTsFileResources.add(new TreeSet((o1, o2) -> {
                try {
                    int rangeCompare = Long.compare(Long.parseLong(o1.getTsFile().getParentFile().getName()), Long.parseLong(o2.getTsFile().getParentFile().getName()));
                    return rangeCompare == 0 ? LevelCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile()) : rangeCompare;
                }
                catch (NumberFormatException e) {
                    return LevelCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile());
                }
            }));
        }
        return newSequenceTsFileResources;
    }

    private List<List<TsFileResource>> newUnSequenceTsFileResources(Long k) {
        ArrayList<List<TsFileResource>> newUnSequenceTsFileResources = new ArrayList<List<TsFileResource>>();
        for (int i = 0; i < this.unseqLevelNum; ++i) {
            newUnSequenceTsFileResources.add(new ArrayList());
        }
        return newUnSequenceTsFileResources;
    }

    private TsFileResource getRecoverTsFileResource(String filePath, boolean isSeq) throws IOException {
        if (isSeq) {
            for (TsFileResource tsFileResource : this.sequenceRecoverTsFileResources) {
                if (!Files.isSameFile(tsFileResource.getTsFile().toPath(), new File(filePath).toPath())) continue;
                return tsFileResource;
            }
        } else {
            for (TsFileResource tsFileResource : this.unSequenceRecoverTsFileResources) {
                if (!Files.isSameFile(tsFileResource.getTsFile().toPath(), new File(filePath).toPath())) continue;
                return tsFileResource;
            }
        }
        logger.error("cannot get tsfile resource path: {}", (Object)filePath);
        throw new IOException();
    }

    private TsFileResource getTsFileResource(String filePath, boolean isSeq) throws IOException {
        if (isSeq) {
            for (List<SortedSet<TsFileResource>> tsFileResourcesWithLevel : this.sequenceTsFileResources.values()) {
                for (SortedSet<TsFileResource> tsFileResources : tsFileResourcesWithLevel) {
                    for (TsFileResource tsFileResource : tsFileResources) {
                        if (!Files.isSameFile(tsFileResource.getTsFile().toPath(), new File(filePath).toPath())) continue;
                        return tsFileResource;
                    }
                }
            }
        } else {
            for (List<List<TsFileResource>> tsFileResourcesWithLevel : this.unSequenceTsFileResources.values()) {
                for (List<TsFileResource> tsFileResources : tsFileResourcesWithLevel) {
                    for (TsFileResource tsFileResource : tsFileResources) {
                        if (!Files.isSameFile(tsFileResource.getTsFile().toPath(), new File(filePath).toPath())) continue;
                        return tsFileResource;
                    }
                }
            }
        }
        logger.error("cannot get tsfile resource path: {}", (Object)filePath);
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCompaction() {
        File logFile = FSFactoryProducer.getFSFactory().getFile(this.storageGroupDir, this.storageGroupName + ".compaction.log");
        try {
            if (logFile.exists()) {
                File targetFile;
                CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(logFile);
                logAnalyzer.analyze();
                String targetFilePath = logAnalyzer.getTargetFile();
                List<String> sourceFileList = logAnalyzer.getSourceFiles();
                boolean isSeq = logAnalyzer.isSeq();
                for (String file : sourceFileList) {
                    TsFileResource fileResource = this.getTsFileResource(file, isSeq);
                    fileResource.setMerging(false);
                }
                if (targetFilePath != null && (targetFile = new File(targetFilePath)).exists()) {
                    targetFile.delete();
                }
            }
        }
        catch (IOException e) {
            logger.error("restore compaction failed", (Throwable)e);
        }
        finally {
            if (logFile.exists()) {
                try {
                    Files.delete(logFile.toPath());
                }
                catch (IOException e) {
                    logger.error("delete compaction log file error ", (Throwable)e);
                }
            }
        }
    }

    public Map<Long, List<SortedSet<TsFileResource>>> getSequenceTsFileResources() {
        return this.sequenceTsFileResources;
    }
}

