/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;

public class ClusterQueryUtils {
    private ClusterQueryUtils() {
    }

    public static void checkPathExistence(String path) throws QueryProcessException {
        try {
            ClusterQueryUtils.checkPathExistence(new PartialPath(path));
        }
        catch (IllegalPathException e) {
            throw new QueryProcessException((IoTDBException)e);
        }
    }

    public static void checkPathExistence(PartialPath path) throws QueryProcessException {
        if (!IoTDB.metaManager.isPathExist(path)) {
            try {
                ((CMManager)IoTDB.metaManager).pullTimeSeriesSchemas(Collections.singletonList(path), null);
            }
            catch (MetadataException e) {
                throw new QueryProcessException((IoTDBException)e);
            }
        }
    }

    public static void checkPathExistence(List<PartialPath> paths) throws QueryProcessException {
        for (PartialPath path : paths) {
            ClusterQueryUtils.checkPathExistence(path);
        }
    }
}

