/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.exception.AddSelfException;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TNodeStatus;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.service.BaseSyncService;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSyncService
extends BaseSyncService
implements TSMetaService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(MetaSyncService.class);
    private MetaGroupMember metaGroupMember;

    public MetaSyncService(MetaGroupMember metaGroupMember) {
        super(metaGroupMember);
        this.metaGroupMember = metaGroupMember;
    }

    @Override
    public long appendEntry(AppendEntryRequest request) throws TException {
        if (this.metaGroupMember.getPartitionTable() == null) {
            logger.debug("This node is blind to the cluster and cannot accept logs");
            return -4L;
        }
        return super.appendEntry(request);
    }

    public AddNodeResponse addNode(Node node, StartUpStatus startUpStatus) throws TException {
        AddNodeResponse addNodeResponse;
        try {
            addNodeResponse = this.metaGroupMember.addNode(node, startUpStatus);
        }
        catch (AddSelfException | LogExecutionException e) {
            throw new TException((Throwable)e);
        }
        if (addNodeResponse != null) {
            return addNodeResponse;
        }
        if (this.member.getCharacter() == NodeCharacter.FOLLOWER && this.member.getLeader() != null) {
            logger.info("Forward the join request of {} to leader {}", (Object)node, (Object)this.member.getLeader());
            addNodeResponse = this.forwardAddNode(node, startUpStatus);
            if (addNodeResponse != null) {
                return addNodeResponse;
            }
        }
        throw new TException((Throwable)new LeaderUnknownException(this.member.getAllNodes()));
    }

    public void sendSnapshot(SendSnapshotRequest request) throws TException {
        try {
            this.metaGroupMember.receiveSnapshot(request);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public CheckStatusResponse checkStatus(StartUpStatus startUpStatus) {
        return ClusterUtils.checkStatus(startUpStatus, this.metaGroupMember.getStartUpStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddNodeResponse forwardAddNode(Node node, StartUpStatus startUpStatus) {
        SyncMetaClient client = (SyncMetaClient)this.metaGroupMember.getSyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                AddNodeResponse addNodeResponse = client.addNode(node, startUpStatus);
                return addNodeResponse;
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
        }
        return null;
    }

    public TNodeStatus queryNodeStatus() {
        return new TNodeStatus();
    }

    public Node checkAlive() {
        return this.metaGroupMember.getThisNode();
    }

    public long removeNode(Node node) throws TException {
        long result;
        try {
            result = this.metaGroupMember.removeNode(node);
        }
        catch (LogExecutionException | PartitionTableUnavailableException e) {
            throw new TException((Throwable)e);
        }
        if (result != Long.MIN_VALUE) {
            return result;
        }
        if (this.metaGroupMember.getCharacter() == NodeCharacter.FOLLOWER && this.metaGroupMember.getLeader() != null) {
            logger.info("Forward the node removal request of {} to leader {}", (Object)node, (Object)this.metaGroupMember.getLeader());
            Long rst = this.forwardRemoveNode(node);
            if (rst != null) {
                return rst;
            }
        }
        throw new TException((Throwable)new LeaderUnknownException(this.metaGroupMember.getAllNodes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long forwardRemoveNode(Node node) {
        SyncMetaClient client = (SyncMetaClient)this.metaGroupMember.getSyncClient(this.metaGroupMember.getLeader());
        if (client != null) {
            try {
                Long l = client.removeNode(node);
                return l;
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                logger.warn("Cannot connect to node {}", (Object)node, (Object)e);
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
        }
        return null;
    }

    public void exile() {
        this.metaGroupMember.applyRemoveNode(this.metaGroupMember.getThisNode());
    }

    public void handshake(Node sender) {
        this.metaGroupMember.handleHandshake(sender);
    }
}

