/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.ReaderNotFoundException;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.rpc.thrift.GetAggrResultRequest;
import org.apache.iotdb.cluster.rpc.thrift.GetAllPathsResult;
import org.apache.iotdb.cluster.rpc.thrift.GroupByRequest;
import org.apache.iotdb.cluster.rpc.thrift.LastQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.MultSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PreviousFillRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.service.BaseAsyncService;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAsyncService
extends BaseAsyncService
implements TSDataService.AsyncIface {
    private static final Logger logger = LoggerFactory.getLogger(DataAsyncService.class);
    private DataGroupMember dataGroupMember;

    public DataAsyncService(DataGroupMember member) {
        super(member);
        this.dataGroupMember = member;
    }

    public void sendSnapshot(SendSnapshotRequest request, AsyncMethodCallback<Void> resultHandler) {
        try {
            this.dataGroupMember.receiveSnapshot(request);
            resultHandler.onComplete(null);
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    public void pullSnapshot(PullSnapshotRequest request, AsyncMethodCallback<PullSnapshotResp> resultHandler) {
        PullSnapshotResp pullSnapshotResp = null;
        try {
            pullSnapshotResp = this.dataGroupMember.getSnapshot(request);
        }
        catch (IOException e) {
            resultHandler.onError((Exception)e);
        }
        if (pullSnapshotResp == null) {
            this.forwardPullSnapshot(request, resultHandler);
        } else {
            resultHandler.onComplete((Object)pullSnapshotResp);
        }
    }

    private void forwardPullSnapshot(PullSnapshotRequest request, AsyncMethodCallback<PullSnapshotResp> resultHandler) {
        if (this.dataGroupMember.getLeader() != null) {
            logger.debug("{} forwarding a pull snapshot request to the leader {}", (Object)this.name, (Object)this.dataGroupMember.getLeader());
            AsyncDataClient client = (AsyncDataClient)this.dataGroupMember.getAsyncClient(this.dataGroupMember.getLeader());
            try {
                client.pullSnapshot(request, resultHandler);
            }
            catch (TException e) {
                resultHandler.onError((Exception)((Object)e));
            }
        } else {
            resultHandler.onError((Exception)new LeaderUnknownException(this.dataGroupMember.getAllNodes()));
        }
    }

    public void pullTimeSeriesSchema(PullSchemaRequest request, AsyncMethodCallback<PullSchemaResp> resultHandler) {
        AsyncDataClient leaderClient;
        if (this.dataGroupMember.getCharacter() == NodeCharacter.LEADER) {
            try {
                resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().queryTimeSeriesSchema(request));
                return;
            }
            catch (CheckConsistencyException | MetadataException e) {
                resultHandler.onError((Exception)e);
            }
        }
        if ((leaderClient = this.getLeaderClient()) == null) {
            resultHandler.onError((Exception)new LeaderUnknownException(this.dataGroupMember.getAllNodes()));
            return;
        }
        try {
            leaderClient.pullTimeSeriesSchema(request, resultHandler);
        }
        catch (TException e1) {
            resultHandler.onError((Exception)((Object)e1));
        }
    }

    private AsyncDataClient getLeaderClient() {
        this.dataGroupMember.waitLeader();
        return (AsyncDataClient)this.dataGroupMember.getAsyncClient(this.dataGroupMember.getLeader());
    }

    public void pullMeasurementSchema(PullSchemaRequest request, AsyncMethodCallback<PullSchemaResp> resultHandler) {
        AsyncDataClient leaderClient;
        if (this.dataGroupMember.getCharacter() == NodeCharacter.LEADER) {
            try {
                resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().queryMeasurementSchema(request));
                return;
            }
            catch (CheckConsistencyException | MetadataException e) {
                resultHandler.onError((Exception)e);
            }
        }
        if ((leaderClient = this.getLeaderClient()) == null) {
            resultHandler.onError((Exception)new LeaderUnknownException(this.dataGroupMember.getAllNodes()));
            return;
        }
        try {
            leaderClient.pullMeasurementSchema(request, resultHandler);
        }
        catch (TException e1) {
            resultHandler.onError((Exception)((Object)e1));
        }
    }

    public void querySingleSeries(SingleSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().querySingleSeries(request));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    public void queryMultSeries(MultSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) throws TException {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().queryMultSeries(request));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    public void querySingleSeriesByTimestamp(SingleSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().querySingleSeriesByTimestamp(request));
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
    }

    public void endQuery(Node header, Node requester, long queryId, AsyncMethodCallback<Void> resultHandler) {
        try {
            this.dataGroupMember.getQueryManager().endQuery(requester, queryId);
            resultHandler.onComplete(null);
        }
        catch (StorageEngineException e) {
            resultHandler.onError((Exception)((Object)e));
        }
    }

    public void fetchSingleSeries(Node header, long readerId, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().fetchSingleSeries(readerId));
        }
        catch (IOException | ReaderNotFoundException e) {
            resultHandler.onError(e);
        }
    }

    public void fetchMultSeries(Node header, long readerId, List<String> paths, AsyncMethodCallback<Map<String, ByteBuffer>> resultHandler) throws TException {
        try {
            resultHandler.onComplete(this.dataGroupMember.getLocalQueryExecutor().fetchMultSeries(readerId, paths));
        }
        catch (IOException | ReaderNotFoundException e) {
            resultHandler.onError(e);
        }
    }

    public void fetchSingleSeriesByTimestamps(Node header, long readerId, List<Long> timestamps, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().fetchSingleSeriesByTimestamps(readerId, timestamps.stream().mapToLong(k -> k).toArray(), timestamps.size()));
        }
        catch (IOException | ReaderNotFoundException e) {
            resultHandler.onError(e);
        }
    }

    public void getAllPaths(Node header, List<String> paths, boolean withAlias, AsyncMethodCallback<GetAllPathsResult> resultHandler) {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            resultHandler.onComplete((Object)((CMManager)IoTDB.metaManager).getAllPaths(paths, withAlias));
        }
        catch (CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getAllDevices(Node header, List<String> path, AsyncMethodCallback<Set<String>> resultHandler) {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            resultHandler.onComplete(((CMManager)IoTDB.metaManager).getAllDevices(path));
        }
        catch (CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getDevices(Node header, ByteBuffer planBinary, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().getDevices(planBinary));
        }
        catch (IOException | CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getNodeList(Node header, String path, int nodeLevel, AsyncMethodCallback<List<String>> resultHandler) {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            resultHandler.onComplete(((CMManager)IoTDB.metaManager).getNodeList(path, nodeLevel));
        }
        catch (CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getChildNodeInNextLevel(Node header, String path, AsyncMethodCallback<Set<String>> resultHandler) {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            resultHandler.onComplete(((CMManager)IoTDB.metaManager).getChildNodeInNextLevel(path));
        }
        catch (CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getChildNodePathInNextLevel(Node header, String path, AsyncMethodCallback<Set<String>> resultHandler) {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
            resultHandler.onComplete(((CMManager)IoTDB.metaManager).getChildNodePathInNextLevel(path));
        }
        catch (CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getAllMeasurementSchema(Node header, ByteBuffer planBinary, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().getAllMeasurementSchema(planBinary));
        }
        catch (IOException | CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getAggrResult(GetAggrResultRequest request, AsyncMethodCallback<List<ByteBuffer>> resultHandler) {
        try {
            resultHandler.onComplete(this.dataGroupMember.getLocalQueryExecutor().getAggrResult(request));
        }
        catch (IOException | StorageEngineException | QueryProcessException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getUnregisteredTimeseries(Node header, List<String> timeseriesList, AsyncMethodCallback<List<String>> resultHandler) {
        try {
            resultHandler.onComplete(this.dataGroupMember.getLocalQueryExecutor().getUnregisteredTimeseries(timeseriesList));
        }
        catch (CheckConsistencyException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getGroupByExecutor(GroupByRequest request, AsyncMethodCallback<Long> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().getGroupByExecutor(request));
        }
        catch (StorageEngineException | QueryProcessException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getGroupByResult(Node header, long executorId, long startTime, long endTime, AsyncMethodCallback<List<ByteBuffer>> resultHandler) {
        try {
            resultHandler.onComplete(this.dataGroupMember.getLocalQueryExecutor().getGroupByResult(executorId, startTime, endTime));
        }
        catch (IOException | ReaderNotFoundException | QueryProcessException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void previousFill(PreviousFillRequest request, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().previousFill(request));
        }
        catch (IOException | StorageEngineException | IllegalPathException | QueryProcessException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void last(LastQueryRequest request, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().last(request));
        }
        catch (IOException | CheckConsistencyException | StorageEngineException | IllegalPathException | QueryProcessException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void getPathCount(Node header, List<String> pathsToQuery, int level, AsyncMethodCallback<Integer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().getPathCount(pathsToQuery, level));
        }
        catch (CheckConsistencyException | MetadataException e) {
            resultHandler.onError((Exception)e);
        }
    }

    public void onSnapshotApplied(Node header, List<Integer> slots, AsyncMethodCallback<Boolean> resultHandler) {
        resultHandler.onComplete((Object)this.dataGroupMember.onSnapshotInstalled(slots));
    }

    public void peekNextNotNullValue(Node header, long executorId, long startTime, long endTime, AsyncMethodCallback<ByteBuffer> resultHandler) {
        try {
            resultHandler.onComplete((Object)this.dataGroupMember.getLocalQueryExecutor().peekNextNotNullValue(executorId, startTime, endTime));
        }
        catch (IOException | ReaderNotFoundException e) {
            resultHandler.onError(e);
        }
    }
}

