/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.service;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.exception.LeaderUnknownException;
import org.apache.iotdb.cluster.exception.UnknownLogTypeException;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntriesRequest;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.ExecutNonQueryReq;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.RequestCommitIndexResponse;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.cluster.utils.IOUtils;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSyncService
implements RaftService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(BaseSyncService.class);
    RaftMember member;
    String name;

    BaseSyncService(RaftMember member) {
        this.member = member;
        this.name = member.getName();
    }

    public HeartBeatResponse sendHeartbeat(HeartBeatRequest request) {
        return this.member.processHeartbeatRequest(request);
    }

    public long startElection(ElectionRequest request) {
        return this.member.processElectionRequest(request);
    }

    public long appendEntry(AppendEntryRequest request) throws TException {
        try {
            return this.member.appendEntry(request);
        }
        catch (UnknownLogTypeException e) {
            throw new TException((Throwable)e);
        }
    }

    public long appendEntries(AppendEntriesRequest request) throws TException {
        try {
            return this.member.appendEntries(request);
        }
        catch (BufferUnderflowException e) {
            logger.error("Underflow buffers {} of logs from {}", (Object)request.getEntries(), (Object)(request.getPrevLogIndex() + 1L));
            throw new TException((Throwable)e);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestCommitIndexResponse requestCommitIndex(Node header) throws TException {
        long curTerm;
        long commitTerm;
        long commitIndex;
        AtomicLong atomicLong = this.member.getTerm();
        synchronized (atomicLong) {
            commitIndex = this.member.getLogManager().getCommitLogIndex();
            commitTerm = this.member.getLogManager().getCommitLogTerm();
            curTerm = this.member.getTerm().get();
        }
        RequestCommitIndexResponse response = new RequestCommitIndexResponse(curTerm, commitIndex, commitTerm);
        if (commitIndex != Long.MIN_VALUE) {
            return response;
        }
        this.member.waitLeader();
        RaftService.Client client = this.member.getSyncClient(this.member.getLeader());
        if (client == null) {
            throw new TException((Throwable)new LeaderUnknownException(this.member.getAllNodes()));
        }
        try {
            response = client.requestCommitIndex(header);
        }
        catch (TException e) {
            client.getInputProtocol().getTransport().close();
            throw e;
        }
        finally {
            ClientUtils.putBackSyncClient(client);
        }
        return response;
    }

    public ByteBuffer readFile(String filePath, long offset, int length) throws TException {
        try {
            return IOUtils.readFile(filePath, offset, length);
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
    }

    public void removeHardLink(String hardLinkPath) throws TException {
        try {
            Files.deleteIfExists(new File(hardLinkPath).toPath());
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
    }

    public boolean matchTerm(long index, long term, Node header) {
        return this.member.matchLog(index, term);
    }

    public TSStatus executeNonQueryPlan(ExecutNonQueryReq request) throws TException {
        if (this.member.getCharacter() != NodeCharacter.LEADER) {
            RaftService.Client client = this.member.getSyncClient(this.member.getLeader());
            if (client != null) {
                TSStatus status;
                try {
                    status = client.executeNonQueryPlan(request);
                }
                catch (TException e) {
                    client.getInputProtocol().getTransport().close();
                    throw e;
                }
                finally {
                    ClientUtils.putBackSyncClient(client);
                }
                return status;
            }
            return StatusUtils.NO_LEADER;
        }
        try {
            return this.member.executeNonQueryPlan(request);
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }
}

