/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.member;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.client.DataClientProvider;
import org.apache.iotdb.cluster.client.async.AsyncClientPool;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.client.async.AsyncMetaHeartbeatClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncClientPool;
import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.client.sync.SyncMetaHeartbeatClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.exception.AddSelfException;
import org.apache.iotdb.cluster.exception.ConfigInconsistentException;
import org.apache.iotdb.cluster.exception.EmptyIntervalException;
import org.apache.iotdb.cluster.exception.LogExecutionException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.exception.SnapshotInstallationException;
import org.apache.iotdb.cluster.exception.StartUpCheckFailureException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.applier.MetaLogApplier;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.log.manage.MetaSingleSnapshotLogManager;
import org.apache.iotdb.cluster.log.manage.RaftLogManager;
import org.apache.iotdb.cluster.log.snapshot.MetaSimpleSnapshot;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.query.ClusterPlanRouter;
import org.apache.iotdb.cluster.rpc.thrift.AddNodeResponse;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.CheckStatusResponse;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.StartUpStatus;
import org.apache.iotdb.cluster.rpc.thrift.TSMetaService;
import org.apache.iotdb.cluster.server.ClientServer;
import org.apache.iotdb.cluster.server.DataClusterServer;
import org.apache.iotdb.cluster.server.HardLinkCleaner;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.handlers.caller.AppendGroupEntryHandler;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.server.handlers.caller.NodeStatusHandler;
import org.apache.iotdb.cluster.server.heartbeat.DataHeartbeatServer;
import org.apache.iotdb.cluster.server.heartbeat.MetaHeartbeatThread;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.server.monitor.NodeReport;
import org.apache.iotdb.cluster.server.monitor.NodeStatusManager;
import org.apache.iotdb.cluster.server.monitor.Timer;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.cluster.utils.PartitionUtils;
import org.apache.iotdb.cluster.utils.StatusUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.service.rpc.thrift.EndPoint;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaGroupMember
extends RaftMember {
    static final String NODE_IDENTIFIER_FILE_NAME = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "node_identifier";
    static final String PARTITION_FILE_NAME = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "partitions";
    private static final String TEMP_SUFFIX = ".tmp";
    private static final Logger logger = LoggerFactory.getLogger(MetaGroupMember.class);
    private static final int DEFAULT_JOIN_RETRY = 10;
    private static final int REPORT_INTERVAL_SEC = 10;
    private static final int REPLICATION_NUM = ClusterDescriptor.getInstance().getConfig().getReplicationNum();
    private static final long CLEAN_HARDLINK_INTERVAL_SEC = 3600L;
    private Set<Node> blindNodes = new HashSet<Node>();
    private Set<Node> idConflictNodes = new HashSet<Node>();
    private Map<Integer, Node> idNodeMap = null;
    private PartitionTable partitionTable;
    private ClusterPlanRouter router;
    private DataClusterServer dataClusterServer;
    private DataHeartbeatServer dataHeartbeatServer;
    private ClientServer clientServer;
    private DataClientProvider dataClientProvider;
    private ScheduledExecutorService reportThread;
    private StartUpStatus startUpStatus;
    private PlanExecutor localExecutor;
    private ScheduledExecutorService hardLinkCleanerThread;
    private Coordinator coordinator;

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public ClusterPlanRouter getRouter() {
        return this.router;
    }

    public MetaGroupMember() {
    }

    public MetaGroupMember(TProtocolFactory factory, Node thisNode, Coordinator coordinator) throws QueryProcessException {
        super("Meta", new AsyncClientPool(new AsyncMetaClient.FactoryAsync(factory)), new SyncClientPool(new SyncMetaClient.FactorySync(factory)), new AsyncClientPool(new AsyncMetaHeartbeatClient.FactoryAsync(factory)), new SyncClientPool(new SyncMetaHeartbeatClient.FactorySync(factory)));
        this.allNodes = new ArrayList();
        this.initPeerMap();
        this.dataClientProvider = new DataClientProvider(factory);
        MetaLogApplier metaLogApplier = new MetaLogApplier(this);
        this.logManager = new MetaSingleSnapshotLogManager(metaLogApplier, this);
        this.term.set(this.logManager.getHardState().getCurrentTerm());
        this.voteFor = this.logManager.getHardState().getVoteFor();
        this.setThisNode(thisNode);
        this.loadIdentifier();
        this.allNodes.add(thisNode);
        DataGroupMember.Factory dataMemberFactory = new DataGroupMember.Factory(factory, this);
        this.dataClusterServer = new DataClusterServer(thisNode, dataMemberFactory, this);
        this.dataHeartbeatServer = new DataHeartbeatServer(thisNode, this.dataClusterServer);
        this.clientServer = new ClientServer(this);
        this.startUpStatus = this.getNewStartUpStatus();
        this.coordinator = coordinator;
        this.loadPartitionTable();
    }

    public void closePartition(String storageGroupName, long partitionId, boolean isSeq) {
        Node header = this.partitionTable.routeToHeaderByTime(storageGroupName, partitionId * StorageEngine.getTimePartitionInterval());
        DataGroupMember localDataMember = this.getLocalDataMember(header);
        if (localDataMember == null || localDataMember.getCharacter() != NodeCharacter.LEADER) {
            return;
        }
        localDataMember.closePartition(storageGroupName, partitionId, isSeq);
    }

    public DataClusterServer getDataClusterServer() {
        return this.dataClusterServer;
    }

    public DataHeartbeatServer getDataHeartbeatServer() {
        return this.dataHeartbeatServer;
    }

    @Override
    public void start() {
        if (this.heartBeatService != null) {
            return;
        }
        this.addSeedNodes();
        NodeStatusManager.getINSTANCE().setMetaGroupMember(this);
        super.start();
    }

    @Override
    void startBackGroundThreads() {
        super.startBackGroundThreads();
        this.reportThread = Executors.newSingleThreadScheduledExecutor(n -> new Thread(n, "NodeReportThread"));
        this.hardLinkCleanerThread = Executors.newSingleThreadScheduledExecutor(n -> new Thread(n, "HardLinkCleaner"));
    }

    @Override
    public void stop() {
        super.stop();
        if (this.getDataClusterServer() != null) {
            this.getDataClusterServer().stop();
        }
        if (this.getDataHeartbeatServer() != null) {
            this.getDataHeartbeatServer().stop();
        }
        if (this.clientServer != null) {
            this.clientServer.stop();
        }
        if (this.reportThread != null) {
            this.reportThread.shutdownNow();
            try {
                this.reportThread.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for reportThread to end", (Throwable)e);
            }
        }
        if (this.hardLinkCleanerThread != null) {
            this.hardLinkCleanerThread.shutdownNow();
            try {
                this.hardLinkCleanerThread.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for hardlinkCleaner to end", (Throwable)e);
            }
        }
        logger.info("{}: stopped", (Object)this.name);
    }

    protected void initSubServers() throws TTransportException, StartupException {
        this.getDataClusterServer().start();
        this.getDataHeartbeatServer().start();
        this.clientServer.setCoordinator(this.coordinator);
        this.clientServer.start();
    }

    protected void addSeedNodes() {
        if (this.allNodes.size() > 1) {
            return;
        }
        List<String> seedUrls = this.config.getSeedNodeUrls();
        for (String seedUrl : seedUrls) {
            Node node = ClusterUtils.parseNode(seedUrl);
            if (node == null || node.getInternalIp().equals(this.thisNode.internalIp) && node.getMetaPort() == this.thisNode.getMetaPort() || this.allNodes.contains(node)) continue;
            this.allNodes.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAddNode(Node newNode) {
        List list = this.allNodes;
        synchronized (list) {
            if (!this.allNodes.contains(newNode)) {
                logger.debug("Adding a new node {} into {}", (Object)newNode, (Object)this.allNodes);
                this.registerNodeIdentifier(newNode, newNode.getNodeIdentifier());
                this.allNodes.add(newNode);
                NodeAdditionResult result = this.partitionTable.addNode(newNode);
                ((SlotPartitionTable)this.partitionTable).setLastLogIndex(this.logManager.getLastLogIndex());
                this.savePartitionTable();
                this.getDataClusterServer().addNode(newNode, result);
            }
        }
    }

    public void buildCluster() throws ConfigInconsistentException, StartUpCheckFailureException {
        this.checkSeedNodesStatus();
        this.threadTaskInit();
        if (this.allNodes.size() == 1) {
            if (this.partitionTable == null) {
                this.partitionTable = new SlotPartitionTable(this.allNodes, this.thisNode);
                logger.info("Partition table is set up");
            }
            this.router = new ClusterPlanRouter(this.partitionTable);
            this.coordinator.setRouter(this.router);
            this.startSubServers();
        }
    }

    private void threadTaskInit() {
        this.heartBeatService.submit(new MetaHeartbeatThread(this));
        this.reportThread.scheduleAtFixedRate(this::generateNodeReport, 10L, 10L, TimeUnit.SECONDS);
        this.hardLinkCleanerThread.scheduleAtFixedRate(new HardLinkCleaner(), 3600L, 3600L, TimeUnit.SECONDS);
    }

    private void generateNodeReport() {
        try {
            if (logger.isInfoEnabled()) {
                NodeReport report = this.genNodeReport();
                logger.info(report.toString());
            }
        }
        catch (Exception e) {
            logger.error("{} exception occurred when generating node report", (Object)this.name, (Object)e);
        }
    }

    public void joinCluster() throws ConfigInconsistentException, StartUpCheckFailureException {
        if (this.allNodes.size() == 1) {
            logger.error("Seed nodes not provided, cannot join cluster");
            throw new ConfigInconsistentException();
        }
        int retry = 10;
        while (retry > 0) {
            Node node = (Node)this.allNodes.get(this.random.nextInt(this.allNodes.size()));
            if (node.equals(this.thisNode)) continue;
            logger.info("start joining the cluster with the help of {}", (Object)node);
            try {
                if (this.joinCluster(node, this.startUpStatus)) {
                    logger.info("Joined a cluster, starting the heartbeat thread");
                    this.setCharacter(NodeCharacter.FOLLOWER);
                    this.setLastHeartbeatReceivedTime(System.currentTimeMillis());
                    this.threadTaskInit();
                    return;
                }
                Thread.sleep(ClusterDescriptor.getInstance().getConfig().getJoinClusterTimeOutMs());
            }
            catch (TException e) {
                logger.warn("Cannot join the cluster from {}, because:", (Object)node, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Unexpected interruption when waiting to join a cluster", (Throwable)e);
            }
            --retry;
        }
        logger.error("Cannot join the cluster after {} retries", (Object)10);
        throw new StartUpCheckFailureException();
    }

    public StartUpStatus getNewStartUpStatus() {
        StartUpStatus newStartUpStatus = new StartUpStatus();
        newStartUpStatus.setPartitionInterval(IoTDBDescriptor.getInstance().getConfig().getPartitionInterval());
        newStartUpStatus.setHashSalt(2333);
        newStartUpStatus.setReplicationNumber(ClusterDescriptor.getInstance().getConfig().getReplicationNum());
        newStartUpStatus.setClusterName(ClusterDescriptor.getInstance().getConfig().getClusterName());
        List<String> seedUrls = ClusterDescriptor.getInstance().getConfig().getSeedNodeUrls();
        ArrayList<Node> seedNodeList = new ArrayList<Node>();
        for (String seedUrl : seedUrls) {
            seedNodeList.add(ClusterUtils.parseNode(seedUrl));
        }
        newStartUpStatus.setSeedNodeList(seedNodeList);
        return newStartUpStatus;
    }

    private boolean joinCluster(Node node, StartUpStatus startUpStatus) throws TException, InterruptedException, ConfigInconsistentException {
        AddNodeResponse resp;
        Object client;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            client = (AsyncMetaClient)this.getAsyncClient(node);
            if (client == null) {
                return false;
            }
            resp = SyncClientAdaptor.addNode(client, this.thisNode, startUpStatus);
        } else {
            client = (SyncMetaClient)this.getSyncClient(node);
            if (client == null) {
                return false;
            }
            try {
                resp = client.addNode(this.thisNode, startUpStatus);
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                throw e;
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
        }
        if (resp == null) {
            logger.warn("Join cluster request timed out");
        } else {
            if ((long)resp.getRespNum() == -1L) {
                logger.info("Node {} admitted this node into the cluster", (Object)node);
                ByteBuffer partitionTableBuffer = resp.partitionTableBytes;
                this.acceptPartitionTable(partitionTableBuffer, true);
                this.getDataClusterServer().pullSnapshots();
                return true;
            }
            if ((long)resp.getRespNum() == -5L) {
                logger.info("The identifier {} conflicts the existing ones, regenerate a new one", (Object)this.thisNode.getNodeIdentifier());
                this.setNodeIdentifier(this.genNodeIdentifier());
            } else if ((long)resp.getRespNum() == -10L) {
                this.handleConfigInconsistency(resp);
            } else {
                logger.warn("Joining the cluster is rejected by {} for response {}", (Object)node, (Object)resp.getRespNum());
            }
        }
        return false;
    }

    private void handleConfigInconsistency(AddNodeResponse resp) throws ConfigInconsistentException {
        if (logger.isErrorEnabled()) {
            CheckStatusResponse checkStatusResponse = resp.getCheckStatusResponse();
            String parameters = (checkStatusResponse.isPartitionalIntervalEquals() ? "" : ", partition interval") + (checkStatusResponse.isHashSaltEquals() ? "" : ", hash salt") + (checkStatusResponse.isReplicationNumEquals() ? "" : ", replication number") + (checkStatusResponse.isSeedNodeEquals() ? "" : ", seedNodes") + (checkStatusResponse.isClusterNameEquals() ? "" : ", clusterName");
            logger.error("The start up configuration{} conflicts the cluster. Please reset the configurations. ", (Object)parameters.substring(1));
        }
        throw new ConfigInconsistentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processValidHeartbeatReq(HeartBeatRequest request, HeartBeatResponse response) {
        if (request.isRequireIdentifier()) {
            if (request.isRegenerateIdentifier()) {
                this.setNodeIdentifier(this.genNodeIdentifier());
            }
            logger.debug("Send identifier {} to the leader", (Object)this.thisNode.getNodeIdentifier());
            response.setFollowerIdentifier(this.thisNode.getNodeIdentifier());
        }
        if (this.partitionTable == null) {
            if (request.isSetPartitionTableBytes()) {
                MetaGroupMember metaGroupMember = this;
                synchronized (metaGroupMember) {
                    if (this.partitionTable == null) {
                        ByteBuffer byteBuffer = request.partitionTableBytes;
                        this.acceptPartitionTable(byteBuffer, true);
                    }
                }
            } else {
                logger.debug("Request cluster nodes from the leader");
                response.setRequirePartitionTable(true);
            }
        }
    }

    public synchronized void acceptPartitionTable(ByteBuffer partitionTableBuffer, boolean needSerialization) {
        SlotPartitionTable newTable = new SlotPartitionTable(this.thisNode);
        newTable.deserialize(partitionTableBuffer);
        if (this.partitionTable != null) {
            long currIndex = ((SlotPartitionTable)this.partitionTable).getLastLogIndex();
            long incomingIndex = newTable.getLastLogIndex();
            logger.info("Current partition table index {}, new partition table index {}", (Object)currIndex, (Object)incomingIndex);
            if (currIndex >= incomingIndex) {
                return;
            }
        }
        this.partitionTable = newTable;
        if (needSerialization) {
            this.savePartitionTable();
        }
        this.router = new ClusterPlanRouter(newTable);
        this.coordinator.setRouter(this.router);
        this.updateNodeList(newTable.getAllNodes());
        this.startSubServers();
    }

    private void updateNodeList(Collection<Node> nodes) {
        this.allNodes = new ArrayList<Node>(nodes);
        this.initPeerMap();
        logger.info("All nodes in the partition table: {}", (Object)this.allNodes);
        this.initIdNodeMap();
        for (Node n : this.allNodes) {
            this.idNodeMap.put(n.getNodeIdentifier(), n);
        }
    }

    @Override
    public void processValidHeartbeatResp(HeartBeatResponse response, Node receiver) {
        if (response.isSetFollowerIdentifier()) {
            this.registerNodeIdentifier(response.getFollower(), response.getFollowerIdentifier());
            if (this.allNodesIdKnown()) {
                this.allNodes = new ArrayList<Node>(this.idNodeMap.values());
                if (this.partitionTable == null) {
                    this.partitionTable = new SlotPartitionTable(this.allNodes, this.thisNode);
                    logger.info("Partition table is set up");
                }
                this.router = new ClusterPlanRouter(this.partitionTable);
                this.coordinator.setRouter(this.router);
                this.startSubServers();
            }
        }
        if (response.isRequirePartitionTable()) {
            this.addBlindNode(receiver);
        }
    }

    private void addBlindNode(Node node) {
        logger.debug("Node {} requires the node list", (Object)node);
        this.blindNodes.add(node);
    }

    public boolean isNodeBlind(Node node) {
        return this.blindNodes.contains(node);
    }

    public void removeBlindNode(Node node) {
        this.blindNodes.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNodeIdentifier(Node node, int identifier) {
        Map<Integer, Node> map = this.idNodeMap;
        synchronized (map) {
            Node conflictNode = this.idNodeMap.get(identifier);
            if (conflictNode != null && !conflictNode.equals(node)) {
                this.idConflictNodes.add(node);
                return;
            }
            node.setNodeIdentifier(identifier);
            logger.info("Node {} registered with id {}", (Object)node, (Object)identifier);
            this.idNodeMap.put(identifier, node);
            this.idConflictNodes.remove(node);
        }
    }

    private void initIdNodeMap() {
        this.idNodeMap = new HashMap<Integer, Node>();
        this.idNodeMap.put(this.thisNode.getNodeIdentifier(), this.thisNode);
    }

    private boolean allNodesIdKnown() {
        return this.idNodeMap != null && this.idNodeMap.size() == this.allNodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void startSubServers() {
        logger.info("Starting sub-servers...");
        PartitionTable partitionTable = this.partitionTable;
        synchronized (partitionTable) {
            try {
                this.getDataClusterServer().buildDataGroupMembers(this.partitionTable);
                this.initSubServers();
                this.sendHandshake();
            }
            catch (StartupException | TTransportException e) {
                logger.error("Build partition table failed: ", e);
                this.stop();
                return;
            }
        }
        logger.info("Sub-servers started.");
    }

    private void sendHandshake() {
        for (Node node : this.allNodes) {
            try {
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    AsyncMetaClient asyncClient = (AsyncMetaClient)this.getAsyncClient(node);
                    if (asyncClient == null) continue;
                    asyncClient.handshake(this.thisNode, new GenericHandler(node, null));
                    continue;
                }
                SyncMetaClient syncClient = (SyncMetaClient)this.getSyncClient(node);
                if (syncClient == null) continue;
                syncClient.handshake(this.thisNode);
            }
            catch (TException tException) {}
        }
    }

    public AddNodeResponse addNode(Node node, StartUpStatus startUpStatus) throws AddSelfException, LogExecutionException {
        AddNodeResponse response = new AddNodeResponse();
        if (this.partitionTable == null) {
            logger.info("Cannot add node now because the partition table is not set");
            response.setRespNum(-4);
            return response;
        }
        logger.info("A node {} wants to join this cluster", (Object)node);
        if (node.equals(this.thisNode)) {
            throw new AddSelfException();
        }
        this.waitLeader();
        if (this.processAddNodeLocally(node, startUpStatus, response)) {
            return response;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processAddNodeLocally(Node node, StartUpStatus startUpStatus, AddNodeResponse response) throws LogExecutionException {
        if (this.character != NodeCharacter.LEADER) {
            return false;
        }
        if (this.allNodes.contains(node)) {
            logger.debug("Node {} is already in the cluster", (Object)node);
            response.setRespNum(-1);
            PartitionTable partitionTable = this.partitionTable;
            synchronized (partitionTable) {
                response.setPartitionTableBytes(this.partitionTable.serialize());
            }
            return true;
        }
        Node idConflictNode = this.idNodeMap.get(node.getNodeIdentifier());
        if (idConflictNode != null) {
            logger.debug("{}'s id conflicts with {}", (Object)node, (Object)idConflictNode);
            response.setRespNum(-5);
            return true;
        }
        if (!this.checkNodeConfig(startUpStatus, response)) {
            return true;
        }
        RaftLogManager raftLogManager = this.logManager;
        synchronized (raftLogManager) {
            AddNodeLog addNodeLog = new AddNodeLog();
            addNodeLog.setCurrLogTerm(this.getTerm().get());
            addNodeLog.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            addNodeLog.setNewNode(node);
            this.logManager.append(addNodeLog);
            int retryTime = 1;
            block13: while (true) {
                logger.info("Send the join request of {} to other nodes, retry time: {}", (Object)node, (Object)retryTime);
                RaftMember.AppendLogResult result = this.sendLogToAllGroups(addNodeLog);
                switch (result) {
                    case OK: {
                        logger.info("Join request of {} is accepted", (Object)node);
                        this.commitLog(addNodeLog);
                        PartitionTable partitionTable = this.partitionTable;
                        synchronized (partitionTable) {
                            response.setPartitionTableBytes(this.partitionTable.serialize());
                        }
                        response.setRespNum(-1);
                        logger.info("Sending join response of {}", (Object)node);
                        return true;
                    }
                    case TIME_OUT: {
                        logger.info("Join request of {} timed out", (Object)node);
                        ++retryTime;
                        continue block13;
                    }
                }
                break;
            }
            return false;
        }
    }

    private boolean checkNodeConfig(StartUpStatus remoteStartUpStatus, AddNodeResponse response) {
        long remotePartitionInterval = remoteStartUpStatus.getPartitionInterval();
        int remoteHashSalt = remoteStartUpStatus.getHashSalt();
        int remoteReplicationNum = remoteStartUpStatus.getReplicationNumber();
        String remoteClusterName = remoteStartUpStatus.getClusterName();
        List remoteSeedNodeList = remoteStartUpStatus.getSeedNodeList();
        long localPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        int localHashSalt = 2333;
        int localReplicationNum = ClusterDescriptor.getInstance().getConfig().getReplicationNum();
        String localClusterName = ClusterDescriptor.getInstance().getConfig().getClusterName();
        boolean partitionIntervalEquals = true;
        boolean hashSaltEquals = true;
        boolean replicationNumEquals = true;
        boolean seedNodeEquals = true;
        boolean clusterNameEquals = true;
        if (localPartitionInterval != remotePartitionInterval) {
            partitionIntervalEquals = false;
            logger.info("Remote partition interval conflicts with the leader's. Leader: {}, remote: {}", (Object)localPartitionInterval, (Object)remotePartitionInterval);
        }
        if (localHashSalt != remoteHashSalt) {
            hashSaltEquals = false;
            logger.info("Remote hash salt conflicts with the leader's. Leader: {}, remote: {}", (Object)localHashSalt, (Object)remoteHashSalt);
        }
        if (localReplicationNum != remoteReplicationNum) {
            replicationNumEquals = false;
            logger.info("Remote replication number conflicts with the leader's. Leader: {}, remote: {}", (Object)localReplicationNum, (Object)remoteReplicationNum);
        }
        if (!Objects.equals(localClusterName, remoteClusterName)) {
            clusterNameEquals = false;
            logger.info("Remote cluster name conflicts with the leader's. Leader: {}, remote: {}", (Object)localClusterName, (Object)remoteClusterName);
        }
        if (!ClusterUtils.checkSeedNodes(true, this.allNodes, remoteSeedNodeList)) {
            seedNodeEquals = false;
            if (logger.isInfoEnabled()) {
                logger.info("Remote seed node list conflicts with the leader's. Leader: {}, remote: {}", (Object)Arrays.toString(this.allNodes.toArray(new Node[0])), (Object)remoteSeedNodeList);
            }
        }
        if (!(partitionIntervalEquals && hashSaltEquals && replicationNumEquals && seedNodeEquals && clusterNameEquals)) {
            response.setRespNum(-10);
            response.setCheckStatusResponse(new CheckStatusResponse(partitionIntervalEquals, hashSaltEquals, replicationNumEquals, seedNodeEquals, clusterNameEquals));
            return false;
        }
        return true;
    }

    private void checkSeedNodesStatus() throws ConfigInconsistentException, StartUpCheckFailureException {
        if (this.getAllNodes().size() == 1) {
            return;
        }
        boolean canEstablishCluster = false;
        long startTime = System.currentTimeMillis();
        AtomicInteger consistentNum = new AtomicInteger(1);
        AtomicInteger inconsistentNum = new AtomicInteger(0);
        while (!canEstablishCluster) {
            consistentNum.set(1);
            inconsistentNum.set(0);
            this.checkSeedNodesStatusOnce(consistentNum, inconsistentNum);
            canEstablishCluster = ClusterUtils.analyseStartUpCheckResult(consistentNum.get(), inconsistentNum.get(), this.getAllNodes().size());
            if (System.currentTimeMillis() - startTime > 300000L) {
                throw new StartUpCheckFailureException();
            }
            if (canEstablishCluster) continue;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for next start up check", (Throwable)e);
            }
        }
    }

    private void checkSeedNodesStatusOnce(AtomicInteger consistentNum, AtomicInteger inconsistentNum) {
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(this.getAllNodes().size() - 1);
        for (Node seedNode : this.getAllNodes()) {
            Node thisNode;
            if (seedNode.equals(thisNode = this.getThisNode())) continue;
            pool.submit(() -> {
                CheckStatusResponse response = this.checkStatus(seedNode);
                if (response != null) {
                    ClusterUtils.examineCheckStatusResponse(response, consistentNum, inconsistentNum, seedNode);
                } else {
                    logger.warn("Start up exception. Cannot connect to node {}. Try again in next turn.", (Object)seedNode);
                }
            });
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Unexpected interruption when waiting for start up checks", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckStatusResponse checkStatus(Node seedNode) {
        block11: {
            if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                AsyncMetaClient client = (AsyncMetaClient)this.getAsyncClient(seedNode, false);
                if (client == null) {
                    return null;
                }
                try {
                    return SyncClientAdaptor.checkStatus(client, this.getStartUpStatus());
                }
                catch (TException e) {
                    logger.warn("Error occurs when check status on node : {}", (Object)seedNode);
                    break block11;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Current thread is interrupted.");
                    break block11;
                }
            }
            SyncMetaClient client = (SyncMetaClient)this.getSyncClient(seedNode, false);
            if (client == null) {
                return null;
            }
            try {
                CheckStatusResponse e = client.checkStatus(this.getStartUpStatus());
                return e;
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                logger.warn("Error occurs when check status on node : {}", (Object)seedNode);
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
        }
        return null;
    }

    private RaftMember.AppendLogResult sendLogToAllGroups(Log log) {
        List<Node> nodeRing = this.partitionTable.getAllNodes();
        AtomicLong newLeaderTerm = new AtomicLong(this.term.get());
        AtomicBoolean leaderShipStale = new AtomicBoolean(false);
        AppendEntryRequest request = this.buildAppendEntryRequest(log, true);
        int[] groupRemainings = this.askGroupVotes(nodeRing, request, leaderShipStale, log, newLeaderTerm);
        if (!leaderShipStale.get()) {
            for (int remaining : groupRemainings) {
                if (remaining <= 0) continue;
                return RaftMember.AppendLogResult.TIME_OUT;
            }
        } else {
            return RaftMember.AppendLogResult.LEADERSHIP_STALE;
        }
        return RaftMember.AppendLogResult.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] askGroupVotes(List<Node> nodeRing, AppendEntryRequest request, AtomicBoolean leaderShipStale, Log log, AtomicLong newLeaderTerm) {
        int nodeSize = nodeRing.size();
        int[] groupRemainings = new int[nodeSize];
        int groupQuorum = REPLICATION_NUM / 2 + 1;
        Arrays.fill(groupRemainings, groupQuorum);
        int[] nArray = groupRemainings;
        synchronized (groupRemainings) {
            for (int i = 0; i < nodeSize; ++i) {
                Node node = nodeRing.get(i);
                if (node.equals(this.thisNode)) {
                    for (int j = 0; j < REPLICATION_NUM; ++j) {
                        int groupIndex = i - j;
                        if (groupIndex < 0) {
                            groupIndex += groupRemainings.length;
                        }
                        int n = groupIndex;
                        groupRemainings[n] = groupRemainings[n] - 1;
                    }
                    continue;
                }
                this.askRemoteGroupVote(node, groupRemainings, i, leaderShipStale, log, newLeaderTerm, request);
            }
            try {
                groupRemainings.wait(RaftServer.getWriteOperationTimeoutMS());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Unexpected interruption when waiting for the group votes", (Throwable)e);
            }
            return groupRemainings;
        }
    }

    private void askRemoteGroupVote(Node node, int[] groupRemainings, int nodeIndex, AtomicBoolean leaderShipStale, Log log, AtomicLong newLeaderTerm, AppendEntryRequest request) {
        AppendGroupEntryHandler handler = new AppendGroupEntryHandler(groupRemainings, nodeIndex, node, leaderShipStale, log, newLeaderTerm, this);
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncMetaClient client = (AsyncMetaClient)this.getAsyncClient(node);
            try {
                if (client != null) {
                    client.appendEntry(request, handler);
                }
            }
            catch (TException e) {
                logger.error("Cannot send log to node {}", (Object)node, (Object)e);
            }
        } else {
            SyncMetaClient client = (SyncMetaClient)this.getSyncClient(node);
            if (client == null) {
                logger.error("No available client for {}", (Object)node);
                return;
            }
            this.getSerialToParallelPool().submit(() -> {
                try {
                    handler.onComplete(client.appendEntry(request));
                }
                catch (TException e) {
                    client.getInputProtocol().getTransport().close();
                    handler.onError((Exception)((Object)e));
                }
                finally {
                    ClientUtils.putBackSyncClient((RaftService.Client)client);
                }
            });
        }
    }

    public Set<Node> getIdConflictNodes() {
        return this.idConflictNodes;
    }

    @Override
    public void onElectionWins() {
        if (this.idNodeMap == null) {
            this.initIdNodeMap();
        }
    }

    private void loadPartitionTable() {
        File partitionFile = new File(PARTITION_FILE_NAME);
        if (!partitionFile.exists() && !this.recoverPartitionTableFile()) {
            logger.info("No partition table file found");
            return;
        }
        this.initIdNodeMap();
        try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(partitionFile)));){
            int size = inputStream.readInt();
            byte[] tableBuffer = new byte[size];
            int readCnt = inputStream.read(tableBuffer);
            if (readCnt < size) {
                throw new IOException(String.format("Expected partition table size: %s, actual read: %s", size, readCnt));
            }
            ByteBuffer wrap = ByteBuffer.wrap(tableBuffer);
            this.acceptPartitionTable(wrap, false);
            logger.info("Load {} nodes: {}", (Object)this.allNodes.size(), (Object)this.allNodes);
        }
        catch (IOException e) {
            logger.error("Cannot load the partition table", (Throwable)e);
        }
    }

    private boolean recoverPartitionTableFile() {
        File tempFile = new File(PARTITION_FILE_NAME + TEMP_SUFFIX);
        if (!tempFile.exists()) {
            return false;
        }
        File partitionFile = new File(PARTITION_FILE_NAME);
        return tempFile.renameTo(partitionFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void savePartitionTable() {
        File tempFile = new File(PARTITION_FILE_NAME + TEMP_SUFFIX);
        tempFile.getParentFile().mkdirs();
        File oldFile = new File(PARTITION_FILE_NAME);
        try (DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));){
            PartitionTable partitionTable = this.partitionTable;
            synchronized (partitionTable) {
                byte[] tableBuffer = this.partitionTable.serialize().array();
                outputStream.writeInt(tableBuffer.length);
                outputStream.write(tableBuffer);
                outputStream.flush();
            }
        }
        catch (IOException e) {
            logger.error("Cannot save the partition table", (Throwable)e);
        }
        if (oldFile.exists()) {
            try {
                Files.delete(Paths.get(oldFile.getAbsolutePath(), new String[0]));
            }
            catch (IOException e) {
                logger.warn("Old partition table file is not successfully deleted", (Throwable)e);
            }
        }
        if (!tempFile.renameTo(oldFile)) {
            logger.warn("New partition table file is not successfully renamed");
        }
        logger.info("Partition table is saved");
    }

    private void loadIdentifier() {
        if (this.thisNode.isSetNodeIdentifier()) {
            return;
        }
        File file = new File(NODE_IDENTIFIER_FILE_NAME);
        Integer nodeId = null;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                nodeId = Integer.parseInt(reader.readLine());
                logger.info("Recovered node identifier {}", (Object)nodeId);
            }
            catch (Exception e) {
                logger.warn("Cannot read the identifier from file, generating a new one", (Throwable)e);
            }
        }
        if (nodeId != null) {
            this.setNodeIdentifier(nodeId);
            return;
        }
        this.setNodeIdentifier(this.genNodeIdentifier());
    }

    private int genNodeIdentifier() {
        return Objects.hash(this.thisNode.getInternalIp(), this.thisNode.getMetaPort(), System.currentTimeMillis());
    }

    private void setNodeIdentifier(int identifier) {
        logger.info("The identifier of this node has been set to {}", (Object)identifier);
        this.thisNode.setNodeIdentifier(identifier);
        File idFile = new File(NODE_IDENTIFIER_FILE_NAME);
        idFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(idFile));){
            writer.write(String.valueOf(identifier));
        }
        catch (IOException e) {
            logger.error("Cannot save the node identifier", (Throwable)e);
        }
    }

    public PartitionTable getPartitionTable() {
        return this.partitionTable;
    }

    public void receiveSnapshot(SendSnapshotRequest request) throws SnapshotInstallationException {
        MetaSimpleSnapshot snapshot = new MetaSimpleSnapshot();
        snapshot.deserialize(request.snapshotBytes);
        snapshot.getDefaultInstaller(this).install(snapshot, -1);
    }

    @Override
    public TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        TSStatus result;
        long startTime = Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY.getOperationStartTime();
        if (PartitionUtils.isGlobalMetaPlan(plan)) {
            logger.debug("receive a global meta plan {}", (Object)plan);
            result = this.processNonPartitionedMetaPlan(plan);
        } else {
            logger.warn("receive a plan {} could not be processed in local", (Object)plan);
            result = StatusUtils.UNSUPPORTED_OPERATION;
        }
        Timer.Statistic.META_GROUP_MEMBER_EXECUTE_NON_QUERY.calOperationCostTimeFromStart(startTime);
        return result;
    }

    public TSStatus processNonPartitionedMetaPlan(PhysicalPlan plan) {
        TSStatus result;
        TSStatus status;
        if (this.character == NodeCharacter.LEADER) {
            status = this.processPlanLocally(plan);
            if (status != null) {
                return status;
            }
        } else if (!ClusterConstant.EMPTY_NODE.equals((Node)this.leader.get()) && !StatusUtils.NO_LEADER.equals(result = this.forwardPlan(plan, (Node)this.leader.get(), null))) {
            result.setRedirectNode(new EndPoint(((Node)this.leader.get()).getClientIp(), ((Node)this.leader.get()).getClientPort()));
            return result;
        }
        this.waitLeader();
        if (this.character == NodeCharacter.LEADER && (status = this.processPlanLocally(plan)) != null) {
            return status;
        }
        result = this.forwardPlan(plan, (Node)this.leader.get(), null);
        if (!StatusUtils.NO_LEADER.equals(result)) {
            result.setRedirectNode(new EndPoint(((Node)this.leader.get()).getClientIp(), ((Node)this.leader.get()).getClientPort()));
        }
        return result;
    }

    public List<PartitionGroup> routeFilter(Filter filter, PartialPath path) throws StorageEngineException, EmptyIntervalException {
        PartitionUtils.Intervals intervals = PartitionUtils.extractTimeInterval(filter);
        if (intervals.isEmpty()) {
            throw new EmptyIntervalException(filter);
        }
        return this.routeIntervals(intervals, path);
    }

    public List<PartitionGroup> routeIntervals(PartitionUtils.Intervals intervals, PartialPath path) throws StorageEngineException {
        ArrayList<PartitionGroup> partitionGroups = new ArrayList<PartitionGroup>();
        PartialPath storageGroupName = null;
        try {
            storageGroupName = IoTDB.metaManager.getStorageGroupPath(path);
        }
        catch (MetadataException e) {
            throw new StorageEngineException((IoTDBException)e);
        }
        if (!StorageEngine.isEnablePartition()) {
            PartitionGroup partitionGroup = this.partitionTable.route(storageGroupName.getFullPath(), 0L);
            partitionGroups.add(partitionGroup);
            return partitionGroups;
        }
        long firstLB = intervals.getLowerBound(0);
        long lastUB = intervals.getUpperBound(intervals.getIntervalSize() - 1);
        if (firstLB == Long.MIN_VALUE || lastUB == Long.MAX_VALUE) {
            partitionGroups.addAll(this.partitionTable.getGlobalGroups());
        } else {
            HashSet<Node> groupHeaders = new HashSet<Node>();
            for (int i = 0; i < intervals.getIntervalSize(); ++i) {
                PartitionUtils.getIntervalHeaders(storageGroupName.getFullPath(), intervals.getLowerBound(i), intervals.getUpperBound(i), this.partitionTable, groupHeaders);
            }
            for (Node groupHeader : groupHeaders) {
                partitionGroups.add(this.partitionTable.getHeaderGroup(groupHeader));
            }
        }
        return partitionGroups;
    }

    public Map<Node, Boolean> getAllNodeStatus() {
        if (this.getPartitionTable() == null) {
            return null;
        }
        HashMap<Node, Boolean> nodeStatus = new HashMap<Node, Boolean>();
        for (Node node : this.allNodes) {
            nodeStatus.put(node, this.thisNode.equals(node));
        }
        try {
            if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                this.getNodeStatusAsync(nodeStatus);
            } else {
                this.getNodeStatusSync(nodeStatus);
            }
        }
        catch (TException e) {
            logger.warn("Cannot get the status of all nodes", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Cannot get the status of all nodes", (Throwable)e);
        }
        return nodeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNodeStatusAsync(Map<Node, Boolean> nodeStatus) throws TException, InterruptedException {
        NodeStatusHandler nodeStatusHandler = new NodeStatusHandler(nodeStatus);
        Map<Node, Boolean> map = nodeStatus;
        synchronized (map) {
            for (Node node : this.allNodes) {
                TSMetaService.AsyncClient client = (TSMetaService.AsyncClient)this.getAsyncClient(node);
                if (node.equals(this.thisNode) || client == null) continue;
                client.checkAlive((AsyncMethodCallback)nodeStatusHandler);
            }
            nodeStatus.wait(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNodeStatusSync(Map<Node, Boolean> nodeStatus) {
        NodeStatusHandler nodeStatusHandler = new NodeStatusHandler(nodeStatus);
        for (Node node : this.allNodes) {
            SyncMetaClient client = (SyncMetaClient)this.getSyncClient(node);
            if (node.equals(this.thisNode) || client == null) continue;
            Node response = null;
            try {
                response = client.checkAlive();
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
            nodeStatusHandler.onComplete(response);
        }
    }

    public void setPartitionTable(PartitionTable partitionTable) {
        this.partitionTable = partitionTable;
        this.router = new ClusterPlanRouter(partitionTable);
        this.coordinator.setRouter(this.router);
        DataClusterServer dClusterServer = this.getDataClusterServer();
        if (dClusterServer != null) {
            dClusterServer.setPartitionTable(partitionTable);
        }
    }

    public long removeNode(Node node) throws PartitionTableUnavailableException, LogExecutionException {
        if (this.partitionTable == null) {
            logger.info("Cannot add node now because the partition table is not set");
            throw new PartitionTableUnavailableException(this.thisNode);
        }
        this.waitLeader();
        return this.processRemoveNodeLocally(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processRemoveNodeLocally(Node node) throws LogExecutionException {
        if (this.character != NodeCharacter.LEADER) {
            return Long.MIN_VALUE;
        }
        if (this.allNodes.size() <= ClusterDescriptor.getInstance().getConfig().getReplicationNum()) {
            return -9L;
        }
        Node target = null;
        Object object = this.allNodes;
        synchronized (object) {
            for (Node n : this.allNodes) {
                if (!n.internalIp.equals(node.internalIp) || n.metaPort != node.metaPort) continue;
                target = n;
                break;
            }
        }
        if (target == null) {
            logger.debug("Node {} is not in the cluster", (Object)node);
            return -3L;
        }
        object = this.logManager;
        synchronized (object) {
            RemoveNodeLog removeNodeLog = new RemoveNodeLog();
            removeNodeLog.setCurrLogTerm(this.getTerm().get());
            removeNodeLog.setCurrLogIndex(this.logManager.getLastLogIndex() + 1L);
            removeNodeLog.setRemovedNode(target);
            this.logManager.append(removeNodeLog);
            int retryTime = 1;
            block11: while (true) {
                logger.info("Send the node removal request of {} to other nodes, retry time: {}", (Object)target, (Object)retryTime);
                RaftMember.AppendLogResult result = this.sendLogToAllGroups(removeNodeLog);
                switch (result) {
                    case OK: {
                        logger.info("Removal request of {} is accepted", (Object)target);
                        this.commitLog(removeNodeLog);
                        return -1L;
                    }
                    case TIME_OUT: {
                        logger.info("Removal request of {} timed out", (Object)target);
                        continue block11;
                    }
                }
                break;
            }
            return Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRemoveNode(Node oldNode) {
        List list = this.allNodes;
        synchronized (list) {
            if (this.allNodes.contains(oldNode)) {
                logger.debug("Removing a node {} from {}", (Object)oldNode, (Object)this.allNodes);
                this.allNodes.remove(oldNode);
                this.idNodeMap.remove(oldNode.nodeIdentifier);
                NodeRemovalResult result = this.partitionTable.removeNode(oldNode);
                ((SlotPartitionTable)this.partitionTable).setLastLogIndex(this.logManager.getLastLogIndex());
                this.getDataClusterServer().removeNode(oldNode, result);
                if (oldNode.equals((Node)this.leader.get())) {
                    this.setCharacter(NodeCharacter.ELECTOR);
                    this.lastHeartbeatReceivedTime = Long.MIN_VALUE;
                }
                if (oldNode.equals(this.thisNode)) {
                    super.stop();
                    if (this.clientServer != null) {
                        this.clientServer.stop();
                    }
                } else if (this.thisNode.equals((Node)this.leader.get())) {
                    this.exileNode(oldNode);
                }
                this.savePartitionTable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exileNode(Node node) {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncMetaClient asyncMetaClient = (AsyncMetaClient)this.getAsyncClient(node);
            try {
                if (asyncMetaClient != null) {
                    asyncMetaClient.exile(new GenericHandler(node, null));
                }
            }
            catch (TException e) {
                logger.warn("Cannot inform {} its removal", (Object)node, (Object)e);
            }
        } else {
            SyncMetaClient client = (SyncMetaClient)this.getSyncClient(node);
            if (client == null) {
                return;
            }
            try {
                client.exile();
            }
            catch (TException e) {
                client.getInputProtocol().getTransport().close();
                logger.warn("Cannot inform {} its removal", (Object)node, (Object)e);
            }
            finally {
                ClientUtils.putBackSyncClient((RaftService.Client)client);
            }
        }
    }

    private NodeReport.MetaMemberReport genMemberReport() {
        long prevLastLogIndex = this.lastReportedLogIndex;
        this.lastReportedLogIndex = this.logManager.getLastLogIndex();
        return new NodeReport.MetaMemberReport(this.character, (Node)this.leader.get(), this.term.get(), this.logManager.getLastLogTerm(), this.lastReportedLogIndex, this.logManager.getCommitLogIndex(), this.logManager.getCommitLogTerm(), this.readOnly, this.lastHeartbeatReceivedTime, prevLastLogIndex, this.logManager.getMaxHaveAppliedCommitIndex());
    }

    private NodeReport genNodeReport() {
        NodeReport report = new NodeReport(this.thisNode);
        report.setMetaMemberReport(this.genMemberReport());
        report.setDataMemberReportList(this.dataClusterServer.genMemberReports());
        return report;
    }

    @Override
    public void setAllNodes(List<Node> allNodes) {
        super.setAllNodes(allNodes);
        this.initPeerMap();
        this.idNodeMap = new HashMap<Integer, Node>();
        for (Node node : allNodes) {
            this.idNodeMap.put(node.getNodeIdentifier(), node);
        }
    }

    public DataGroupMember getLocalDataMember(Node header, Object request) {
        return this.dataClusterServer.getDataMember(header, null, request);
    }

    public DataGroupMember getLocalDataMember(Node header) {
        return this.dataClusterServer.getDataMember(header, null, "Internal call");
    }

    public DataClientProvider getClientProvider() {
        return this.dataClientProvider;
    }

    @Override
    public void closeLogManager() {
        super.closeLogManager();
        if (this.dataClusterServer != null) {
            this.dataClusterServer.closeLogManagers();
        }
    }

    public PlanExecutor getLocalExecutor() throws QueryProcessException {
        if (this.localExecutor == null) {
            this.localExecutor = new PlanExecutor();
        }
        return this.localExecutor;
    }

    public StartUpStatus getStartUpStatus() {
        return this.startUpStatus;
    }

    public void setClientProvider(DataClientProvider dataClientProvider) {
        this.dataClientProvider = dataClientProvider;
    }

    public void handleHandshake(Node sender) {
        NodeStatusManager.getINSTANCE().activate(sender);
    }
}

