/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.heartbeat;

import java.util.Collection;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.handlers.caller.ElectionHandler;
import org.apache.iotdb.cluster.server.handlers.caller.HeartbeatHandler;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.utils.ClientUtils;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatThread.class);
    private RaftMember localMember;
    private String memberName;
    HeartBeatRequest request = new HeartBeatRequest();
    ElectionRequest electionRequest = new ElectionRequest();
    private Random random = new Random();
    boolean hasHadLeader = false;

    HeartbeatThread(RaftMember localMember) {
        this.localMember = localMember;
        this.memberName = localMember.getName();
    }

    @Override
    public void run() {
        logger.info("{}: Heartbeat thread starts...", (Object)this.memberName);
        long electionWait = ClusterConstant.getElectionLeastTimeOutMs() + Math.abs(this.random.nextLong() % ClusterConstant.getElectionRandomTimeOutMs());
        try {
            logger.info("{}: Sleep {}ms before first election", (Object)this.memberName, (Object)electionWait);
            Thread.sleep(electionWait);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        block9: while (!Thread.interrupted()) {
            try {
                switch (this.localMember.getCharacter()) {
                    case LEADER: {
                        this.sendHeartbeats();
                        Thread.sleep(RaftServer.getHeartBeatIntervalMs());
                        this.hasHadLeader = true;
                        continue block9;
                    }
                    case FOLLOWER: {
                        long heartBeatInterval = System.currentTimeMillis() - this.localMember.getLastHeartbeatReceivedTime();
                        if (heartBeatInterval >= (long)RaftServer.getConnectionTimeoutInMS()) {
                            logger.info("{}: The leader {} timed out", (Object)this.memberName, (Object)this.localMember.getLeader());
                            this.localMember.setCharacter(NodeCharacter.ELECTOR);
                            this.localMember.setLeader(ClusterConstant.EMPTY_NODE);
                        } else {
                            logger.debug("{}: Heartbeat from leader {} is still valid", (Object)this.memberName, (Object)this.localMember.getLeader());
                            Thread.sleep(RaftServer.getConnectionTimeoutInMS());
                        }
                        this.hasHadLeader = true;
                        continue block9;
                    }
                }
                this.onElectionsStart();
                this.startElections();
                this.onElectionsEnd();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                logger.error("{}: Unexpected heartbeat exception:", (Object)this.memberName, (Object)e);
            }
        }
        logger.info("{}: Heartbeat thread exits", (Object)this.memberName);
    }

    protected void onElectionsStart() {
        logger.info("{}: Start elections", (Object)this.memberName);
    }

    protected void onElectionsEnd() {
        logger.info("{}: End elections", (Object)this.memberName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartbeats() {
        AtomicLong atomicLong = this.localMember.getTerm();
        synchronized (atomicLong) {
            this.request.setTerm(this.localMember.getTerm().get());
            this.request.setLeader(this.localMember.getThisNode());
            this.request.setCommitLogIndex(this.localMember.getLogManager().getCommitLogIndex());
            this.request.setCommitLogTerm(this.localMember.getLogManager().getCommitLogTerm());
            this.sendHeartbeats(this.localMember.getAllNodes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartbeats(Collection<Node> nodes) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Send heartbeat to {} followers", (Object)this.memberName, (Object)(nodes.size() - 1));
        }
        Collection<Node> collection = nodes;
        synchronized (collection) {
            for (Node node : nodes) {
                if (node.equals(this.localMember.getThisNode())) continue;
                if (Thread.currentThread().isInterrupted()) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (this.localMember.getCharacter() != NodeCharacter.LEADER) {
                    logger.warn("The leadership of node {} is ended.", (Object)this.localMember.getThisNode());
                    return;
                }
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    this.sendHeartbeatAsync(node);
                    continue;
                }
                this.sendHeartbeatSync(node);
            }
        }
    }

    void sendHeartbeatAsync(Node node) {
        RaftService.AsyncClient client = this.localMember.getAsyncHeartbeatClient(node);
        if (client != null) {
            try {
                logger.debug("{}: Sending heartbeat to {}", (Object)this.memberName, (Object)node);
                client.sendHeartbeat(this.request, (AsyncMethodCallback)new HeartbeatHandler(this.localMember, node));
            }
            catch (Exception e) {
                logger.warn("{}: Cannot send heart beat to node {}", new Object[]{this.memberName, node, e});
            }
        }
    }

    void sendHeartbeatSync(Node node) {
        RaftService.Client client = this.localMember.getSyncHeartbeatClient(node);
        HeartbeatHandler heartbeatHandler = new HeartbeatHandler(this.localMember, node);
        HeartBeatRequest req = new HeartBeatRequest();
        req.setCommitLogTerm(this.request.commitLogTerm);
        req.setCommitLogIndex(this.request.commitLogIndex);
        req.setRegenerateIdentifier(this.request.regenerateIdentifier);
        req.setRequireIdentifier(this.request.requireIdentifier);
        req.setTerm(this.request.term);
        req.setLeader(this.localMember.getThisNode());
        if (this.request.isSetHeader()) {
            req.setHeader(this.request.header);
        }
        if (this.request.isSetPartitionTableBytes()) {
            req.partitionTableBytes = this.request.partitionTableBytes;
            req.setPartitionTableBytesIsSet(true);
        }
        if (client != null) {
            this.localMember.getSerialToParallelPool().submit(() -> {
                try {
                    logger.debug("{}: Sending heartbeat to {}", (Object)this.memberName, (Object)node);
                    HeartBeatResponse heartBeatResponse = client.sendHeartbeat(req);
                    heartbeatHandler.onComplete(heartBeatResponse);
                }
                catch (TTransportException e) {
                    logger.warn("{}: Cannot send heart beat to node {} due to network", new Object[]{this.memberName, node, e});
                    client.getInputProtocol().getTransport().close();
                }
                catch (Exception e) {
                    logger.warn("{}: Cannot send heart beat to node {}", new Object[]{this.memberName, node, e});
                }
                finally {
                    ClientUtils.putBackSyncHeartbeatClient(client);
                }
            });
        }
    }

    private void startElections() throws InterruptedException {
        if (this.localMember.getAllNodes().size() == 1) {
            this.localMember.setCharacter(NodeCharacter.LEADER);
            this.localMember.setLeader(this.localMember.getThisNode());
            logger.info("{}: Winning the election because the node is the only node.", (Object)this.memberName);
        }
        while (this.localMember.getCharacter() == NodeCharacter.ELECTOR) {
            this.startElection();
            if (this.localMember.getCharacter() != NodeCharacter.ELECTOR) continue;
            long electionWait = ClusterConstant.getElectionLeastTimeOutMs() + Math.abs(this.random.nextLong() % ClusterConstant.getElectionRandomTimeOutMs());
            logger.info("{}: Sleep {}ms until next election", (Object)this.memberName, (Object)electionWait);
            Thread.sleep(electionWait);
        }
        this.localMember.setLastHeartbeatReceivedTime(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startElection() {
        AtomicLong atomicLong = this.localMember.getTerm();
        synchronized (atomicLong) {
            long nextTerm = this.localMember.getTerm().incrementAndGet();
            this.localMember.setVoteFor(this.localMember.getThisNode());
            this.localMember.updateHardState(nextTerm, this.localMember.getVoteFor());
            int quorumNum = this.localMember.getAllNodes().size() / 2;
            logger.info("{}: Election {} starts, quorum: {}", new Object[]{this.memberName, nextTerm, quorumNum});
            AtomicBoolean electionTerminated = new AtomicBoolean(false);
            AtomicBoolean electionValid = new AtomicBoolean(false);
            AtomicInteger quorum = new AtomicInteger(quorumNum);
            AtomicInteger failingVoteCounter = new AtomicInteger(quorumNum + 1);
            this.electionRequest.setTerm(nextTerm);
            this.electionRequest.setElector(this.localMember.getThisNode());
            if (!this.electionRequest.isSetLastLogIndex()) {
                this.electionRequest.setLastLogTerm(this.localMember.getLogManager().getLastLogTerm());
                this.electionRequest.setLastLogIndex(this.localMember.getLogManager().getLastLogIndex());
            }
            this.requestVote(this.localMember.getAllNodes(), this.electionRequest, nextTerm, quorum, electionTerminated, electionValid, failingVoteCounter);
            this.electionRequest.unsetLastLogIndex();
            try {
                logger.info("{}: Wait for {}ms until election time out", (Object)this.memberName, (Object)RaftServer.getConnectionTimeoutInMS());
                this.localMember.getTerm().wait(RaftServer.getConnectionTimeoutInMS());
            }
            catch (InterruptedException e) {
                logger.info("{}: Unexpected interruption when waiting the result of election {}", (Object)this.memberName, (Object)nextTerm);
                Thread.currentThread().interrupt();
            }
            electionTerminated.set(true);
            if (electionValid.get()) {
                logger.info("{}: Election {} accepted", (Object)this.memberName, (Object)nextTerm);
                this.localMember.setCharacter(NodeCharacter.LEADER);
                this.localMember.setLeader(this.localMember.getThisNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestVote(Collection<Node> nodes, ElectionRequest request, long nextTerm, AtomicInteger quorum, AtomicBoolean electionTerminated, AtomicBoolean electionValid, AtomicInteger failingVoteCounter) {
        Collection<Node> collection = nodes;
        synchronized (collection) {
            for (Node node : nodes) {
                if (node.equals(this.localMember.getThisNode())) continue;
                ElectionHandler handler = new ElectionHandler(this.localMember, node, nextTerm, quorum, electionTerminated, electionValid, failingVoteCounter);
                if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                    this.requestVoteAsync(node, handler, request);
                    continue;
                }
                this.requestVoteSync(node, handler, request);
            }
        }
    }

    private void requestVoteAsync(Node node, ElectionHandler handler, ElectionRequest request) {
        RaftService.AsyncClient client = this.localMember.getAsyncHeartbeatClient(node);
        if (client != null) {
            logger.info("{}: Requesting a vote from {}", (Object)this.memberName, (Object)node);
            try {
                client.startElection(request, (AsyncMethodCallback)handler);
            }
            catch (Exception e) {
                logger.error("{}: Cannot request a vote from {}", new Object[]{this.memberName, node, e});
            }
        }
    }

    private void requestVoteSync(Node node, ElectionHandler handler, ElectionRequest request) {
        RaftService.Client client = this.localMember.getSyncHeartbeatClient(node);
        if (client != null) {
            logger.info("{}: Requesting a vote from {}", (Object)this.memberName, (Object)node);
            this.localMember.getSerialToParallelPool().submit(() -> {
                try {
                    long result = client.startElection(request);
                    handler.onComplete(result);
                }
                catch (Exception e) {
                    handler.onError(e);
                }
                finally {
                    ClientUtils.putBackSyncHeartbeatClient(client);
                }
            });
        }
    }
}

