/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.heartbeat;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeartbeatServer {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatServer.class);
    private static int connectionTimeoutInMS = ClusterDescriptor.getInstance().getConfig().getConnectionTimeoutInMS();
    ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
    private TServerTransport heartbeatSocket;
    private TServer heartbeatPoolServer;
    Node thisNode;
    private TProtocolFactory heartbeatProtocolFactory = this.config.isRpcThriftCompressionEnabled() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
    private ExecutorService heartbeatClientService;

    HeartbeatServer() {
        this.thisNode = new Node();
        this.thisNode.setInternalIp(this.config.getInternalIp());
        this.thisNode.setMetaPort(this.config.getInternalMetaPort());
        this.thisNode.setDataPort(this.config.getInternalDataPort());
        this.thisNode.setClientIp(IoTDBDescriptor.getInstance().getConfig().getRpcAddress());
    }

    HeartbeatServer(Node thisNode) {
        this.thisNode = thisNode;
    }

    public static int getConnectionTimeoutInMS() {
        return connectionTimeoutInMS;
    }

    public void start() throws TTransportException, StartupException {
        if (this.heartbeatPoolServer != null) {
            return;
        }
        this.establishHeartbeatServer();
    }

    public void stop() {
        if (this.heartbeatPoolServer == null) {
            return;
        }
        this.heartbeatPoolServer.stop();
        this.heartbeatSocket.close();
        this.heartbeatClientService.shutdownNow();
        this.heartbeatSocket = null;
        this.heartbeatPoolServer = null;
    }

    abstract TProcessor getProcessor();

    abstract TServerTransport getHeartbeatServerSocket() throws TTransportException;

    abstract String getClientThreadPrefix();

    abstract String getServerClientName();

    private TServer getSyncHeartbeatServer() throws TTransportException {
        this.heartbeatSocket = this.getHeartbeatServerSocket();
        return ClusterUtils.createTThreadPoolServer(this.heartbeatSocket, this.getClientThreadPrefix(), this.getProcessor(), this.heartbeatProtocolFactory);
    }

    private TServer getAsyncHeartbeatServer() throws TTransportException {
        this.heartbeatSocket = this.getHeartbeatServerSocket();
        int maxConcurrentClientNum = Math.max(CommonUtils.getCpuCores(), this.config.getMaxConcurrentClientNum());
        THsHaServer.Args poolArgs = new THsHaServer.Args((TNonblockingServerTransport)this.heartbeatSocket).maxWorkerThreads(maxConcurrentClientNum).minWorkerThreads(CommonUtils.getCpuCores());
        poolArgs.executorService((ExecutorService)new ThreadPoolExecutor(poolArgs.minWorkerThreads, poolArgs.maxWorkerThreads, (long)poolArgs.getStopTimeoutVal(), poolArgs.getStopTimeoutUnit(), new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicLong threadIndex = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, HeartbeatServer.this.getClientThreadPrefix() + this.threadIndex.incrementAndGet());
            }
        }));
        poolArgs.processor(this.getProcessor());
        poolArgs.protocolFactory(this.heartbeatProtocolFactory);
        poolArgs.transportFactory((TTransportFactory)RpcTransportFactory.INSTANCE);
        return new THsHaServer(poolArgs);
    }

    private void establishHeartbeatServer() throws TTransportException {
        logger.info("Cluster node's heartbeat {} begins to set up", (Object)this.thisNode);
        this.heartbeatPoolServer = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.getAsyncHeartbeatServer() : this.getSyncHeartbeatServer();
        this.heartbeatClientService = Executors.newSingleThreadExecutor(r -> new Thread(r, this.getServerClientName()));
        this.heartbeatClientService.submit(() -> this.heartbeatPoolServer.serve());
        logger.info("[{}] Cluster node's heartbeat {} is up", (Object)this.getServerClientName(), (Object)this.thisNode);
    }
}

