/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviousFillHandler
implements AsyncMethodCallback<ByteBuffer> {
    private static final Logger logger = LoggerFactory.getLogger(PreviousFillHandler.class);
    private static final long MAX_WAIT_MIN = 3L;
    private CountDownLatch latch;
    private TimeValuePair result = new TimeValuePair(Long.MIN_VALUE, null);

    public PreviousFillHandler(CountDownLatch latch) {
        this.latch = latch;
    }

    public synchronized void onComplete(ByteBuffer response) {
        TimeValuePair timeValuePair;
        if (response != null && response.limit() - response.position() != 0 && (timeValuePair = SerializeUtils.deserializeTVPair((ByteBuffer)response)) != null && timeValuePair.getTimestamp() > this.result.getTimestamp()) {
            this.result = timeValuePair;
        }
        this.latch.countDown();
    }

    public synchronized void onComplete(TimeValuePair timeValuePair) {
        if (timeValuePair.getTimestamp() > this.result.getTimestamp()) {
            this.result = timeValuePair;
        }
        this.latch.countDown();
    }

    public synchronized void onError(Exception exception) {
        logger.error("Cannot get previous fill result", (Throwable)exception);
        this.latch.countDown();
    }

    public TimeValuePair getResult() {
        try {
            if (!this.latch.await(3L, TimeUnit.MINUTES)) {
                logger.warn("Not all nodes returned previous fill result when timed out, remaining {}", (Object)this.latch.getCount());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error("Unexpected interruption when waiting for the result of previous fill");
        }
        return this.result;
    }
}

