/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.NoHeaderNodeException;
import org.apache.iotdb.cluster.exception.NotInSameGroupException;
import org.apache.iotdb.cluster.exception.PartitionTableUnavailableException;
import org.apache.iotdb.cluster.partition.NodeAdditionResult;
import org.apache.iotdb.cluster.partition.NodeRemovalResult;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntriesRequest;
import org.apache.iotdb.cluster.rpc.thrift.AppendEntryRequest;
import org.apache.iotdb.cluster.rpc.thrift.ElectionRequest;
import org.apache.iotdb.cluster.rpc.thrift.ExecutNonQueryReq;
import org.apache.iotdb.cluster.rpc.thrift.GetAggrResultRequest;
import org.apache.iotdb.cluster.rpc.thrift.GetAllPathsResult;
import org.apache.iotdb.cluster.rpc.thrift.GroupByRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatRequest;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.LastQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.MultSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PreviousFillRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.iotdb.cluster.rpc.thrift.RequestCommitIndexResponse;
import org.apache.iotdb.cluster.rpc.thrift.SendSnapshotRequest;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.TSDataService;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.StoppedMemberManager;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.cluster.server.monitor.NodeReport;
import org.apache.iotdb.cluster.server.service.DataAsyncService;
import org.apache.iotdb.cluster.server.service.DataSyncService;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClusterServer
extends RaftServer
implements TSDataService.AsyncIface,
TSDataService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(DataClusterServer.class);
    private Map<Node, DataGroupMember> headerGroupMap = new ConcurrentHashMap<Node, DataGroupMember>();
    private Map<Node, DataAsyncService> asyncServiceMap = new ConcurrentHashMap<Node, DataAsyncService>();
    private Map<Node, DataSyncService> syncServiceMap = new ConcurrentHashMap<Node, DataSyncService>();
    private StoppedMemberManager stoppedMemberManager;
    private PartitionTable partitionTable;
    private DataGroupMember.Factory dataMemberFactory;
    private MetaGroupMember metaGroupMember;

    public DataClusterServer(Node thisNode, DataGroupMember.Factory dataMemberFactory, MetaGroupMember metaGroupMember) {
        super(thisNode);
        this.dataMemberFactory = dataMemberFactory;
        this.metaGroupMember = metaGroupMember;
        this.stoppedMemberManager = new StoppedMemberManager(dataMemberFactory, thisNode);
    }

    @Override
    public void stop() {
        this.closeLogManagers();
        for (DataGroupMember member : this.headerGroupMap.values()) {
            member.stop();
        }
        super.stop();
    }

    public void addDataGroupMember(DataGroupMember dataGroupMember) {
        DataGroupMember removedMember = this.headerGroupMap.remove(dataGroupMember.getHeader());
        if (removedMember != null) {
            removedMember.stop();
            this.asyncServiceMap.remove(dataGroupMember.getHeader());
            this.syncServiceMap.remove(dataGroupMember.getHeader());
        }
        this.stoppedMemberManager.remove(dataGroupMember.getHeader());
        this.headerGroupMap.put(dataGroupMember.getHeader(), dataGroupMember);
    }

    private <T> DataAsyncService getDataAsyncService(Node header, AsyncMethodCallback<T> resultHandler, Object request) {
        return this.asyncServiceMap.computeIfAbsent(header, h -> {
            DataGroupMember dataMember = this.getDataMember((Node)h, resultHandler, request);
            return dataMember != null ? new DataAsyncService(dataMember) : null;
        });
    }

    private DataSyncService getDataSyncService(Node header) {
        return this.syncServiceMap.computeIfAbsent(header, h -> {
            DataGroupMember dataMember = this.getDataMember((Node)h, null, null);
            return dataMember != null ? new DataSyncService(dataMember) : null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DataGroupMember getDataMember(Node header, AsyncMethodCallback<T> resultHandler, Object request) {
        if (header == null) {
            if (resultHandler != null) {
                resultHandler.onError((Exception)new NoHeaderNodeException());
            }
            return null;
        }
        DataGroupMember member = this.stoppedMemberManager.get(header);
        if (member != null) {
            return member;
        }
        Exception ex = null;
        Map<Node, DataGroupMember> map = this.headerGroupMap;
        synchronized (map) {
            member = this.headerGroupMap.get(header);
            if (member != null) {
                return member;
            }
            logger.info("Received a request \"{}\" from unregistered header {}", request, (Object)header);
            if (this.partitionTable != null) {
                try {
                    member = this.createNewMember(header);
                }
                catch (CheckConsistencyException | NotInSameGroupException e) {
                    ex = e;
                }
            } else {
                logger.info("Partition is not ready, cannot create member");
                ex = new PartitionTableUnavailableException(this.thisNode);
            }
            if (ex != null && resultHandler != null) {
                resultHandler.onError(ex);
            }
            return member;
        }
    }

    private DataGroupMember createNewMember(Node header) throws NotInSameGroupException, CheckConsistencyException {
        DataGroupMember member;
        PartitionGroup partitionGroup = this.partitionTable.getHeaderGroup(header);
        if (partitionGroup == null || !partitionGroup.contains(this.thisNode)) {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(true);
            partitionGroup = this.partitionTable.getHeaderGroup(header);
        }
        if (partitionGroup != null && partitionGroup.contains(this.thisNode)) {
            member = this.dataMemberFactory.create(partitionGroup, this.thisNode);
            DataGroupMember prevMember = this.headerGroupMap.put(header, member);
            if (prevMember != null) {
                prevMember.stop();
            }
        } else {
            DataGroupMember member2 = this.stoppedMemberManager.get(header);
            if (member2 != null) {
                return member2;
            }
            logger.info("This node {} does not belong to the group {}, header {}", new Object[]{this.thisNode, partitionGroup, header});
            throw new NotInSameGroupException(partitionGroup, this.thisNode);
        }
        logger.info("Created a member for header {}", (Object)header);
        member.start();
        return member;
    }

    public void sendHeartbeat(HeartBeatRequest request, AsyncMethodCallback<HeartBeatResponse> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.sendHeartbeat(request, resultHandler);
        }
    }

    public void startElection(ElectionRequest request, AsyncMethodCallback<Long> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.startElection(request, resultHandler);
        }
    }

    public void appendEntries(AppendEntriesRequest request, AsyncMethodCallback<Long> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.appendEntries(request, resultHandler);
        }
    }

    public void appendEntry(AppendEntryRequest request, AsyncMethodCallback<Long> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.appendEntry(request, resultHandler);
        }
    }

    public void sendSnapshot(SendSnapshotRequest request, AsyncMethodCallback<Void> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.sendSnapshot(request, resultHandler);
        }
    }

    public void pullSnapshot(PullSnapshotRequest request, AsyncMethodCallback<PullSnapshotResp> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.pullSnapshot(request, resultHandler);
        }
    }

    public void executeNonQueryPlan(ExecutNonQueryReq request, AsyncMethodCallback<TSStatus> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.executeNonQueryPlan(request, resultHandler);
        }
    }

    public void requestCommitIndex(Node header, AsyncMethodCallback<RequestCommitIndexResponse> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Request commit index");
        if (service != null) {
            service.requestCommitIndex(header, resultHandler);
        }
    }

    public void readFile(String filePath, long offset, int length, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(this.thisNode, resultHandler, "Read file:" + filePath);
        if (service != null) {
            service.readFile(filePath, offset, length, resultHandler);
        }
    }

    public void querySingleSeries(SingleSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, "Query series:" + request.getPath());
        if (service != null) {
            service.querySingleSeries(request, resultHandler);
        }
    }

    public void queryMultSeries(MultSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) throws TException {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, "Query series:" + request.getPath());
        if (service != null) {
            service.queryMultSeries(request, resultHandler);
        }
    }

    public void fetchSingleSeries(Node header, long readerId, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Fetch reader:" + readerId);
        if (service != null) {
            service.fetchSingleSeries(header, readerId, resultHandler);
        }
    }

    public void fetchMultSeries(Node header, long readerId, List<String> paths, AsyncMethodCallback<Map<String, ByteBuffer>> resultHandler) throws TException {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Fetch reader:" + readerId);
        if (service != null) {
            service.fetchMultSeries(header, readerId, paths, resultHandler);
        }
    }

    public void getAllPaths(Node header, List<String> paths, boolean withAlias, AsyncMethodCallback<GetAllPathsResult> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Find path:" + paths);
        if (service != null) {
            service.getAllPaths(header, paths, withAlias, resultHandler);
        }
    }

    public void endQuery(Node header, Node thisNode, long queryId, AsyncMethodCallback<Void> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "End query");
        if (service != null) {
            service.endQuery(header, thisNode, queryId, resultHandler);
        }
    }

    public void querySingleSeriesByTimestamp(SingleSeriesQueryRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, "Query by timestamp:" + request.getQueryId() + "#" + request.getPath() + " of " + request.getRequester());
        if (service != null) {
            service.querySingleSeriesByTimestamp(request, resultHandler);
        }
    }

    public void fetchSingleSeriesByTimestamps(Node header, long readerId, List<Long> timestamps, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Fetch by timestamp:" + readerId);
        if (service != null) {
            service.fetchSingleSeriesByTimestamps(header, readerId, timestamps, resultHandler);
        }
    }

    public void pullTimeSeriesSchema(PullSchemaRequest request, AsyncMethodCallback<PullSchemaResp> resultHandler) {
        Node header = request.getHeader();
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, request);
        if (service != null) {
            service.pullTimeSeriesSchema(request, resultHandler);
        }
    }

    public void pullMeasurementSchema(PullSchemaRequest request, AsyncMethodCallback<PullSchemaResp> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, "Pull measurement schema");
        service.pullMeasurementSchema(request, resultHandler);
    }

    public void getAllDevices(Node header, List<String> paths, AsyncMethodCallback<Set<String>> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Get all devices");
        service.getAllDevices(header, paths, resultHandler);
    }

    public void getDevices(Node header, ByteBuffer planBytes, AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Get devices");
        service.getDevices(header, planBytes, resultHandler);
    }

    public void getNodeList(Node header, String path, int nodeLevel, AsyncMethodCallback<List<String>> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Get node list");
        service.getNodeList(header, path, nodeLevel, resultHandler);
    }

    public void getChildNodeInNextLevel(Node header, String path, AsyncMethodCallback<Set<String>> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Get child node in next level");
        service.getChildNodeInNextLevel(header, path, resultHandler);
    }

    public void getChildNodePathInNextLevel(Node header, String path, AsyncMethodCallback<Set<String>> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Get child node path in next level");
        service.getChildNodePathInNextLevel(header, path, resultHandler);
    }

    public void getAllMeasurementSchema(Node header, ByteBuffer planBytes, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Get all measurement schema");
        service.getAllMeasurementSchema(header, planBytes, resultHandler);
    }

    public void getAggrResult(GetAggrResultRequest request, AsyncMethodCallback<List<ByteBuffer>> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, request);
        service.getAggrResult(request, resultHandler);
    }

    public void getUnregisteredTimeseries(Node header, List<String> timeseriesList, AsyncMethodCallback<List<String>> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Check if measurements are registered");
        service.getUnregisteredTimeseries(header, timeseriesList, resultHandler);
    }

    public void getGroupByExecutor(GroupByRequest request, AsyncMethodCallback<Long> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, request);
        service.getGroupByExecutor(request, resultHandler);
    }

    public void getGroupByResult(Node header, long executorId, long startTime, long endTime, AsyncMethodCallback<List<ByteBuffer>> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Fetch group by");
        service.getGroupByResult(header, executorId, startTime, endTime, resultHandler);
    }

    @Override
    TProcessor getProcessor() {
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TSDataService.AsyncProcessor((TSDataService.AsyncIface)this);
        }
        return new TSDataService.Processor((TSDataService.Iface)this);
    }

    @Override
    TServerTransport getServerSocket() throws TTransportException {
        logger.info("[{}] Cluster node will listen {}:{}", new Object[]{this.getServerClientName(), this.config.getInternalIp(), this.config.getInternalDataPort()});
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            return new TNonblockingServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.thisNode.getDataPort()), DataClusterServer.getConnectionTimeoutInMS());
        }
        return new TServerSocket(new InetSocketAddress(this.config.getInternalIp(), this.thisNode.getDataPort()));
    }

    @Override
    String getClientThreadPrefix() {
        return "DataClientThread-";
    }

    @Override
    String getServerClientName() {
        return "DataServerThread-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node node, NodeAdditionResult result) {
        Iterator<Map.Entry<Node, DataGroupMember>> entryIterator = this.headerGroupMap.entrySet().iterator();
        Map<Node, DataGroupMember> map = this.headerGroupMap;
        synchronized (map) {
            while (entryIterator.hasNext()) {
                Map.Entry<Node, DataGroupMember> entry = entryIterator.next();
                DataGroupMember dataGroupMember = entry.getValue();
                boolean shouldLeave = dataGroupMember.addNode(node, result);
                if (!shouldLeave) continue;
                logger.info("This node does not belong to {} any more", dataGroupMember.getAllNodes());
                entryIterator.remove();
                this.removeMember(entry.getKey(), entry.getValue());
            }
            if (result.getNewGroup().contains(this.thisNode)) {
                logger.info("Adding this node into a new group {}", (Object)result.getNewGroup());
                DataGroupMember dataGroupMember = this.dataMemberFactory.create(result.getNewGroup(), this.thisNode);
                this.addDataGroupMember(dataGroupMember);
                dataGroupMember.start();
                dataGroupMember.pullNodeAdditionSnapshots(((SlotPartitionTable)this.partitionTable).getNodeSlots(node), node);
            }
        }
    }

    private void removeMember(Node header, DataGroupMember dataGroupMember) {
        try {
            dataGroupMember.syncLeader(null);
        }
        catch (CheckConsistencyException e) {
            logger.warn("Failed to check consistency.", (Throwable)e);
        }
        dataGroupMember.setReadOnly();
        dataGroupMember.stop();
        this.stoppedMemberManager.put(header, dataGroupMember);
    }

    public void buildDataGroupMembers(PartitionTable partitionTable) {
        this.setPartitionTable(partitionTable);
        for (DataGroupMember value : this.headerGroupMap.values()) {
            value.stop();
        }
        for (DataGroupMember value : this.headerGroupMap.values()) {
            value.setUnchanged(false);
        }
        List<PartitionGroup> partitionGroups = partitionTable.getLocalGroups();
        for (PartitionGroup partitionGroup : partitionGroups) {
            DataGroupMember prevMember = this.headerGroupMap.get(partitionGroup.getHeader());
            if (prevMember == null || !prevMember.getAllNodes().equals(partitionGroup)) {
                logger.info("Building member of data group: {}", (Object)partitionGroup);
                DataGroupMember dataGroupMember = this.dataMemberFactory.create(partitionGroup, this.thisNode);
                dataGroupMember.start();
                this.addDataGroupMember(dataGroupMember);
                dataGroupMember.setUnchanged(true);
                continue;
            }
            prevMember.setUnchanged(true);
        }
        this.headerGroupMap.entrySet().removeIf(e -> !((DataGroupMember)e.getValue()).isUnchanged());
        logger.info("Data group members are ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node, NodeRemovalResult removalResult) {
        Iterator<Map.Entry<Node, DataGroupMember>> entryIterator = this.headerGroupMap.entrySet().iterator();
        Map<Node, DataGroupMember> map = this.headerGroupMap;
        synchronized (map) {
            while (entryIterator.hasNext()) {
                Map.Entry<Node, DataGroupMember> entry = entryIterator.next();
                DataGroupMember dataGroupMember = entry.getValue();
                if (dataGroupMember.getHeader().equals(node)) {
                    entryIterator.remove();
                    this.removeMember(entry.getKey(), entry.getValue());
                    continue;
                }
                if (node.equals(this.thisNode)) {
                    List<Integer> nodeSlots = ((SlotPartitionTable)this.partitionTable).getNodeSlots(dataGroupMember.getHeader());
                    dataGroupMember.removeLocalData(nodeSlots);
                    entryIterator.remove();
                    dataGroupMember.stop();
                    continue;
                }
                dataGroupMember.removeNode(node, removalResult);
            }
            PartitionGroup newGroup = removalResult.getNewGroup();
            if (newGroup != null) {
                logger.info("{} should join a new group {}", (Object)this.thisNode, (Object)newGroup);
                try {
                    this.createNewMember(newGroup.getHeader());
                }
                catch (NotInSameGroupException dataGroupMember) {
                }
                catch (CheckConsistencyException ce) {
                    logger.error("remove node failed, error={}", (Object)ce.getMessage());
                }
            }
        }
    }

    public void setPartitionTable(PartitionTable partitionTable) {
        this.partitionTable = partitionTable;
    }

    public void pullSnapshots() {
        List<Integer> slots = ((SlotPartitionTable)this.partitionTable).getNodeSlots(this.thisNode);
        DataGroupMember dataGroupMember = this.headerGroupMap.get(this.thisNode);
        dataGroupMember.pullNodeAdditionSnapshots(slots, this.thisNode);
    }

    public List<NodeReport.DataMemberReport> genMemberReports() {
        ArrayList<NodeReport.DataMemberReport> dataMemberReports = new ArrayList<NodeReport.DataMemberReport>();
        for (DataGroupMember value : this.headerGroupMap.values()) {
            dataMemberReports.add(value.genReport());
        }
        return dataMemberReports;
    }

    public void previousFill(PreviousFillRequest request, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, request);
        service.previousFill(request, resultHandler);
    }

    public void closeLogManagers() {
        for (DataGroupMember member : this.headerGroupMap.values()) {
            member.closeLogManager();
        }
    }

    public void matchTerm(long index, long term, Node header, AsyncMethodCallback<Boolean> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Match term");
        service.matchTerm(index, term, header, resultHandler);
    }

    public void last(LastQueryRequest request, AsyncMethodCallback<ByteBuffer> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(request.getHeader(), resultHandler, "last");
        service.last(request, resultHandler);
    }

    public void getPathCount(Node header, List<String> pathsToQuery, int level, AsyncMethodCallback<Integer> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "count path");
        service.getPathCount(header, pathsToQuery, level, resultHandler);
    }

    public void onSnapshotApplied(Node header, List<Integer> slots, AsyncMethodCallback<Boolean> resultHandler) {
        DataAsyncService service = this.getDataAsyncService(header, resultHandler, "Snapshot applied");
        service.onSnapshotApplied(header, slots, resultHandler);
    }

    public long querySingleSeries(SingleSeriesQueryRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).querySingleSeries(request);
    }

    public long queryMultSeries(MultSeriesQueryRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).queryMultSeries(request);
    }

    public ByteBuffer fetchSingleSeries(Node header, long readerId) throws TException {
        return this.getDataSyncService(header).fetchSingleSeries(header, readerId);
    }

    public Map<String, ByteBuffer> fetchMultSeries(Node header, long readerId, List<String> paths) throws TException {
        return this.getDataSyncService(header).fetchMultSeries(header, readerId, paths);
    }

    public long querySingleSeriesByTimestamp(SingleSeriesQueryRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).querySingleSeriesByTimestamp(request);
    }

    public ByteBuffer fetchSingleSeriesByTimestamps(Node header, long readerId, List<Long> timestamps) throws TException {
        return this.getDataSyncService(header).fetchSingleSeriesByTimestamps(header, readerId, timestamps);
    }

    public void endQuery(Node header, Node thisNode, long queryId) throws TException {
        this.getDataSyncService(header).endQuery(header, thisNode, queryId);
    }

    public GetAllPathsResult getAllPaths(Node header, List<String> path, boolean withAlias) throws TException {
        return this.getDataSyncService(header).getAllPaths(header, path, withAlias);
    }

    public Set<String> getAllDevices(Node header, List<String> path) throws TException {
        return this.getDataSyncService(header).getAllDevices(header, path);
    }

    public List<String> getNodeList(Node header, String path, int nodeLevel) throws TException {
        return this.getDataSyncService(header).getNodeList(header, path, nodeLevel);
    }

    public Set<String> getChildNodeInNextLevel(Node header, String path) throws TException {
        return this.getDataSyncService(header).getChildNodeInNextLevel(header, path);
    }

    public Set<String> getChildNodePathInNextLevel(Node header, String path) throws TException {
        return this.getDataSyncService(header).getChildNodePathInNextLevel(header, path);
    }

    public ByteBuffer getAllMeasurementSchema(Node header, ByteBuffer planBinary) throws TException {
        return this.getDataSyncService(header).getAllMeasurementSchema(header, planBinary);
    }

    public ByteBuffer getDevices(Node header, ByteBuffer planBinary) throws TException {
        return this.getDataSyncService(header).getDevices(header, planBinary);
    }

    public List<ByteBuffer> getAggrResult(GetAggrResultRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).getAggrResult(request);
    }

    public List<String> getUnregisteredTimeseries(Node header, List<String> timeseriesList) throws TException {
        return this.getDataSyncService(header).getUnregisteredTimeseries(header, timeseriesList);
    }

    public PullSnapshotResp pullSnapshot(PullSnapshotRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).pullSnapshot(request);
    }

    public long getGroupByExecutor(GroupByRequest request) throws TException {
        return this.getDataSyncService(request.header).getGroupByExecutor(request);
    }

    public List<ByteBuffer> getGroupByResult(Node header, long executorId, long startTime, long endTime) throws TException {
        return this.getDataSyncService(header).getGroupByResult(header, executorId, startTime, endTime);
    }

    public PullSchemaResp pullTimeSeriesSchema(PullSchemaRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).pullTimeSeriesSchema(request);
    }

    public PullSchemaResp pullMeasurementSchema(PullSchemaRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).pullMeasurementSchema(request);
    }

    public ByteBuffer previousFill(PreviousFillRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).previousFill(request);
    }

    public ByteBuffer last(LastQueryRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).last(request);
    }

    public int getPathCount(Node header, List<String> pathsToQuery, int level) throws TException {
        return this.getDataSyncService(header).getPathCount(header, pathsToQuery, level);
    }

    public boolean onSnapshotApplied(Node header, List<Integer> slots) {
        return this.getDataSyncService(header).onSnapshotApplied(header, slots);
    }

    public HeartBeatResponse sendHeartbeat(HeartBeatRequest request) {
        return this.getDataSyncService(request.getHeader()).sendHeartbeat(request);
    }

    public long startElection(ElectionRequest request) {
        return this.getDataSyncService(request.getHeader()).startElection(request);
    }

    public long appendEntries(AppendEntriesRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).appendEntries(request);
    }

    public long appendEntry(AppendEntryRequest request) throws TException {
        return this.getDataSyncService(request.getHeader()).appendEntry(request);
    }

    public void sendSnapshot(SendSnapshotRequest request) throws TException {
        this.getDataSyncService(request.getHeader()).sendSnapshot(request);
    }

    public TSStatus executeNonQueryPlan(ExecutNonQueryReq request) throws TException {
        return this.getDataSyncService(request.getHeader()).executeNonQueryPlan(request);
    }

    public RequestCommitIndexResponse requestCommitIndex(Node header) throws TException {
        return this.getDataSyncService(header).requestCommitIndex(header);
    }

    public ByteBuffer readFile(String filePath, long offset, int length) throws TException {
        return this.getDataSyncService(this.thisNode).readFile(filePath, offset, length);
    }

    public boolean matchTerm(long index, long term, Node header) {
        return this.getDataSyncService(header).matchTerm(index, term, header);
    }

    public ByteBuffer peekNextNotNullValue(Node header, long executorId, long startTime, long endTime) throws TException {
        return this.getDataSyncService(header).peekNextNotNullValue(header, executorId, startTime, endTime);
    }

    public void peekNextNotNullValue(Node header, long executorId, long startTime, long endTime, AsyncMethodCallback<ByteBuffer> resultHandler) throws TException {
        resultHandler.onComplete((Object)this.getDataSyncService(header).peekNextNotNullValue(header, executorId, startTime, endTime));
    }

    public void removeHardLink(String hardLinkPath) throws TException {
        this.getDataSyncService(this.thisNode).removeHardLink(hardLinkPath);
    }

    public void removeHardLink(String hardLinkPath, AsyncMethodCallback<Void> resultHandler) {
        this.getDataAsyncService(this.thisNode, resultHandler, hardLinkPath).removeHardLink(hardLinkPath, resultHandler);
    }
}

