/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.coordinator.Coordinator;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.query.ClusterPlanExecutor;
import org.apache.iotdb.cluster.query.ClusterPlanner;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServer
extends TSServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ClientServer.class);
    private Coordinator coordinator;
    private ExecutorService serverService;
    private TServer poolServer;
    private TServerTransport serverTransport;
    private Map<Long, RemoteQueryContext> queryContextMap = new ConcurrentHashMap<Long, RemoteQueryContext>();

    public void setCoordinator(Coordinator coordinator) {
        this.coordinator = coordinator;
    }

    public ClientServer(MetaGroupMember metaGroupMember) throws QueryProcessException {
        this.processor = new ClusterPlanner();
        this.executor = new ClusterPlanExecutor(metaGroupMember);
    }

    public void start() throws TTransportException {
        if (this.serverService != null) {
            return;
        }
        this.serverService = Executors.newSingleThreadExecutor(r -> new Thread(r, "ClusterClientServer"));
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        Object protocolFactory = IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
        this.serverTransport = new TServerSocket(new InetSocketAddress(IoTDBDescriptor.getInstance().getConfig().getRpcAddress(), config.getClusterRpcPort()));
        int maxConcurrentClientNum = Math.max(CommonUtils.getCpuCores(), config.getMaxConcurrentClientNum());
        TThreadPoolServer.Args poolArgs = new TThreadPoolServer.Args(this.serverTransport).maxWorkerThreads(maxConcurrentClientNum).minWorkerThreads(CommonUtils.getCpuCores());
        poolArgs.executorService((ExecutorService)new ThreadPoolExecutor(poolArgs.minWorkerThreads, poolArgs.maxWorkerThreads, (long)poolArgs.stopTimeoutVal, poolArgs.stopTimeoutUnit, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicLong threadIndex = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ClusterClient-" + this.threadIndex.incrementAndGet());
            }
        }));
        poolArgs.processor((TProcessor)new TSIService.Processor((TSIService.Iface)this));
        poolArgs.protocolFactory((TProtocolFactory)protocolFactory);
        poolArgs.transportFactory((TTransportFactory)RpcTransportFactory.INSTANCE);
        this.poolServer = new TThreadPoolServer(poolArgs);
        this.poolServer.setServerEventHandler((TServerEventHandler)new EventHandler());
        this.serverService.submit(() -> this.poolServer.serve());
        logger.info("Client service is set up");
    }

    public void stop() {
        if (this.serverService == null) {
            return;
        }
        this.poolServer.stop();
        this.serverService.shutdownNow();
        this.serverTransport.close();
    }

    protected TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        try {
            plan.checkIntegrity();
        }
        catch (QueryProcessException e) {
            logger.warn("Illegal plan detected\uff1a {}", (Object)plan);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
        }
        return this.coordinator.executeNonQueryPlan(plan);
    }

    protected List<TSDataType> getSeriesTypesByPaths(List<PartialPath> paths, List<String> aggregations) throws MetadataException {
        return (List)((CMManager)IoTDB.metaManager).getSeriesTypesByPath(paths, aggregations).left;
    }

    protected List<TSDataType> getSeriesTypesByString(List<PartialPath> paths, String aggregation) throws MetadataException {
        return (List)((CMManager)IoTDB.metaManager).getSeriesTypesByPaths(paths, (String)aggregation).left;
    }

    protected QueryContext genQueryContext(long queryId, boolean debug) {
        RemoteQueryContext context = new RemoteQueryContext(queryId, debug);
        this.queryContextMap.put(queryId, context);
        return context;
    }

    protected void releaseQueryResource(long queryId) throws StorageEngineException {
        super.releaseQueryResource(queryId);
        RemoteQueryContext context = this.queryContextMap.remove(queryId);
        if (context != null) {
            for (Map.Entry<Node, Set<Node>> headerEntry : context.getQueriedNodesMap().entrySet()) {
                Node header = headerEntry.getKey();
                Set<Node> queriedNodes = headerEntry.getValue();
                for (Node queriedNode : queriedNodes) {
                    GenericHandler handler = new GenericHandler(queriedNode, new AtomicReference());
                    try {
                        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
                            AsyncDataClient client = this.coordinator.getAsyncDataClient(queriedNode, RaftServer.getReadOperationTimeoutMS());
                            client.endQuery(header, this.coordinator.getThisNode(), queryId, handler);
                            continue;
                        }
                        SyncDataClient syncDataClient = this.coordinator.getSyncDataClient(queriedNode, RaftServer.getReadOperationTimeoutMS());
                        try {
                            syncDataClient.endQuery(header, this.coordinator.getThisNode(), queryId);
                        }
                        finally {
                            if (syncDataClient == null) continue;
                            syncDataClient.close();
                        }
                    }
                    catch (IOException | TException e) {
                        logger.error("Cannot end query {} in {}", (Object)queryId, (Object)queriedNode);
                    }
                }
            }
        }
    }

    class EventHandler
    implements TServerEventHandler {
        EventHandler() {
        }

        public void preServe() {
        }

        public ServerContext createContext(TProtocol input, TProtocol output) {
            return null;
        }

        public void deleteContext(ServerContext serverContext, TProtocol input, TProtocol output) {
            ClientServer.this.handleClientExit();
        }

        public void processContext(ServerContext serverContext, TTransport inputTransport, TTransport outputTransport) {
        }
    }
}

