/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader.mult;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.query.reader.mult.AbstractMultPointReader;
import org.apache.iotdb.cluster.query.reader.mult.MultDataSourceInfo;
import org.apache.iotdb.cluster.server.RaftServer;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMultSeriesReader
extends AbstractMultPointReader {
    private static final Logger logger = LoggerFactory.getLogger(RemoteMultSeriesReader.class);
    private static final int FETCH_BATCH_DATA_SIZE = 10;
    private MultDataSourceInfo sourceInfo;
    private Map<String, Queue<BatchData>> cachedBatchs;
    private AtomicReference<Map<String, ByteBuffer>> fetchResult = new AtomicReference();
    private GenericHandler<Map<String, ByteBuffer>> handler;
    private BatchStrategy batchStrategy;
    private Map<String, BatchData> currentBatchDatas;
    private Map<String, TSDataType> pathToDataType;

    public RemoteMultSeriesReader(MultDataSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.handler = new GenericHandler<Map<String, ByteBuffer>>(sourceInfo.getCurrentNode(), this.fetchResult);
        this.currentBatchDatas = Maps.newHashMap();
        this.batchStrategy = new DefaultBatchStrategy();
        this.cachedBatchs = Maps.newHashMap();
        this.pathToDataType = Maps.newHashMap();
        for (int i = 0; i < sourceInfo.getPartialPaths().size(); ++i) {
            String fullPath = sourceInfo.getPartialPaths().get(i).getFullPath();
            this.cachedBatchs.put(fullPath, new ConcurrentLinkedQueue());
            this.pathToDataType.put(fullPath, sourceInfo.getDataTypes().get(i));
        }
    }

    @Override
    public boolean hasNextTimeValuePair(String fullPath) throws IOException {
        BatchData batchData = this.currentBatchDatas.get(fullPath);
        if (batchData != null && batchData.hasCurrent()) {
            return true;
        }
        this.fetchBatch();
        return this.checkPathBatchData(fullPath);
    }

    private boolean checkPathBatchData(String fullPath) {
        BatchData batchData = this.cachedBatchs.get(fullPath).peek();
        return batchData != null && !batchData.isEmpty();
    }

    @Override
    public TimeValuePair nextTimeValuePair(String fullPath) throws IOException {
        BatchData batchData = this.currentBatchDatas.get(fullPath);
        if ((batchData == null || !batchData.hasCurrent()) && this.checkPathBatchData(fullPath)) {
            batchData = this.cachedBatchs.get(fullPath).poll();
            this.currentBatchDatas.put(fullPath, batchData);
        }
        if (!this.hasNextTimeValuePair(fullPath)) {
            throw new NoSuchElementException();
        }
        TimeValuePair timeValuePair = new TimeValuePair(batchData.currentTime(), TsPrimitiveType.getByType((TSDataType)this.pathToDataType.get(fullPath), (Object)batchData.currentValue()));
        batchData.next();
        return timeValuePair;
    }

    @Override
    public Set<String> getAllPaths() {
        return this.cachedBatchs.keySet();
    }

    public void close() {
    }

    private void fetchBatch() throws IOException {
        if (!this.sourceInfo.checkCurClient()) {
            this.cachedBatchs = null;
            return;
        }
        List<String> paths = this.batchStrategy.selectBatchPaths(this.cachedBatchs);
        if (paths.isEmpty()) {
            return;
        }
        Map<String, ByteBuffer> result = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.fetchResultAsync(paths) : this.fetchResultSync(paths);
        if (result == null) {
            return;
        }
        for (String path : result.keySet()) {
            BatchData batchData = SerializeUtils.deserializeBatchData((ByteBuffer)result.get(path));
            if (logger.isDebugEnabled()) {
                logger.debug("Fetched a batch from {}, size:{}", (Object)this.sourceInfo.getCurrentNode(), (Object)(batchData == null ? 0 : batchData.length()));
            }
            if (batchData == null) {
                batchData = new BatchData();
            }
            this.cachedBatchs.computeIfAbsent(path, n -> new ConcurrentLinkedQueue()).add(batchData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ByteBuffer> fetchResultAsync(List<String> paths) throws IOException {
        AtomicReference<Map<String, ByteBuffer>> atomicReference = this.fetchResult;
        synchronized (atomicReference) {
            this.fetchResult.set(null);
            try {
                this.sourceInfo.getCurAsyncClient(RaftServer.getReadOperationTimeoutMS()).fetchMultSeries(this.sourceInfo.getHeader(), this.sourceInfo.getReaderId(), paths, this.handler);
                this.fetchResult.wait(RaftServer.getReadOperationTimeoutMS());
            }
            catch (InterruptedException | TException e) {
                logger.error("Failed to fetch result async, connect to {}", (Object)this.sourceInfo, (Object)e);
                return null;
            }
        }
        return this.fetchResult.get();
    }

    private Map<String, ByteBuffer> fetchResultSync(List<String> paths) throws IOException {
        SyncDataClient curSyncClient = this.sourceInfo.getCurSyncClient(RaftServer.getReadOperationTimeoutMS());
        try {
            Map map = curSyncClient.fetchMultSeries(this.sourceInfo.getHeader(), this.sourceInfo.getReaderId(), paths);
            if (curSyncClient != null) {
                curSyncClient.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (curSyncClient != null) {
                    try {
                        curSyncClient.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (TException e) {
                logger.error("Failed to fetch result sync, connect to {}", (Object)this.sourceInfo, (Object)e);
                return null;
            }
        }
    }

    static class DefaultBatchStrategy
    implements BatchStrategy {
        DefaultBatchStrategy() {
        }

        @Override
        public List<String> selectBatchPaths(Map<String, Queue<BatchData>> cacheBatchs) {
            ArrayList paths = Lists.newArrayList();
            for (String path : cacheBatchs.keySet()) {
                Queue<BatchData> batchDataQueue = cacheBatchs.get(path);
                BatchData batchData = batchDataQueue.peek();
                if (batchData != null && batchData.isEmpty() || batchDataQueue.size() >= 10) continue;
                paths.add(path);
            }
            return paths;
        }
    }

    static interface BatchStrategy {
        public List<String> selectBatchPaths(Map<String, Queue<BatchData>> var1);
    }
}

