/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.reader.ClusterReaderFactory;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.AndNode;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.LeafNode;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.OrNode;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class ClusterTimeGenerator
extends ServerTimeGenerator {
    private ClusterReaderFactory readerFactory;
    private boolean hasLocalReader = false;
    private QueryDataSet.EndPoint endPoint = null;

    public ClusterTimeGenerator(QueryContext context, MetaGroupMember metaGroupMember, RawDataQueryPlan rawDataQueryPlan, boolean onlyCheckLocalData) throws StorageEngineException {
        super(context);
        this.queryPlan = rawDataQueryPlan;
        this.readerFactory = new ClusterReaderFactory(metaGroupMember);
        try {
            this.readerFactory.syncMetaGroup();
            if (onlyCheckLocalData) {
                this.whetherHasLocalDataGroup(this.queryPlan.getExpression(), metaGroupMember, this.queryPlan.isAscending());
            } else {
                this.constructNode(this.queryPlan.getExpression());
            }
        }
        catch (IOException | CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
    }

    public ClusterTimeGenerator(QueryContext context, MetaGroupMember metaGroupMember, ClusterReaderFactory clusterReaderFactory, RawDataQueryPlan rawDataQueryPlan, boolean onlyCheckLocalData) throws StorageEngineException {
        super(context);
        this.queryPlan = rawDataQueryPlan;
        this.readerFactory = clusterReaderFactory;
        try {
            this.readerFactory.syncMetaGroup();
            if (onlyCheckLocalData) {
                this.whetherHasLocalDataGroup(this.queryPlan.getExpression(), metaGroupMember, this.queryPlan.isAscending());
            } else {
                this.constructNode(this.queryPlan.getExpression());
            }
        }
        catch (IOException | CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
    }

    protected IBatchReader generateNewBatchReader(SingleSeriesExpression expression) throws IOException {
        ManagedSeriesReader mergeReader;
        Filter filter = expression.getFilter();
        Filter timeFilter = this.getTimeFilter(filter);
        PartialPath path = (PartialPath)expression.getSeriesPath();
        try {
            TSDataType dataType = (TSDataType)((List)((CMManager)IoTDB.metaManager).getSeriesTypesByPaths(Collections.singletonList(path), null).left).get(0);
            mergeReader = this.readerFactory.getSeriesReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, timeFilter, filter, this.context, this.queryPlan.isAscending());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return mergeReader;
    }

    public boolean isHasLocalReader() {
        return this.hasLocalReader;
    }

    public String toString() {
        return super.toString() + ", has local reader:" + this.hasLocalReader;
    }

    public void whetherHasLocalDataGroup(IExpression expression, MetaGroupMember metaGroupMember, boolean isAscending) throws IOException {
        this.hasLocalReader = false;
        this.constructNode(expression, metaGroupMember, isAscending);
    }

    private Node constructNode(IExpression expression, MetaGroupMember metaGroupMember, boolean isAscending) throws IOException {
        if (expression.getType() == ExpressionType.SERIES) {
            SingleSeriesExpression singleSeriesExp = (SingleSeriesExpression)expression;
            this.checkHasLocalReader(singleSeriesExp, metaGroupMember);
            return new LeafNode(null);
        }
        Node leftChild = this.constructNode(((IBinaryExpression)expression).getLeft(), metaGroupMember, isAscending);
        Node rightChild = this.constructNode(((IBinaryExpression)expression).getRight(), metaGroupMember, isAscending);
        if (expression.getType() == ExpressionType.OR) {
            return new OrNode(leftChild, rightChild, isAscending);
        }
        if (expression.getType() == ExpressionType.AND) {
            return new AndNode(leftChild, rightChild, isAscending);
        }
        throw new UnSupportedDataTypeException("Unsupported ExpressionType when construct OperatorNode: " + expression.getType());
    }

    private void checkHasLocalReader(SingleSeriesExpression expression, MetaGroupMember metaGroupMember) throws IOException {
        Filter filter = expression.getFilter();
        Filter timeFilter = this.getTimeFilter(filter);
        PartialPath path = (PartialPath)expression.getSeriesPath();
        try {
            TSDataType dataType = (TSDataType)((List)((CMManager)IoTDB.metaManager).getSeriesTypesByPaths(Collections.singletonList(path), null).left).get(0);
            List<PartitionGroup> partitionGroups = metaGroupMember.routeFilter(null, path);
            for (PartitionGroup partitionGroup : partitionGroups) {
                if (partitionGroup.contains(metaGroupMember.getThisNode())) {
                    DataGroupMember dataGroupMember = metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), String.format("Query: %s, time filter: %s, queryId: %d", path, null, this.context.getQueryId()));
                    IPointReader pointReader = this.readerFactory.getSeriesPointReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, timeFilter, filter, this.context, dataGroupMember, this.queryPlan.isAscending());
                    if (pointReader.hasNextTimeValuePair()) {
                        this.hasLocalReader = true;
                        this.endPoint = null;
                        pointReader.close();
                        break;
                    }
                    pointReader.close();
                    continue;
                }
                if (this.endPoint != null) continue;
                this.endPoint = new QueryDataSet.EndPoint(partitionGroup.getHeader().getClientIp(), partitionGroup.getHeader().getClientPort());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

