/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.cluster.query.reader.ClusterReaderFactory;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeGroupByExecutor
implements GroupByExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MergeGroupByExecutor.class);
    private List<AggregateResult> results = new ArrayList<AggregateResult>();
    private List<Integer> aggregationTypes = new ArrayList<Integer>();
    private PartialPath path;
    private Set<String> deviceMeasurements;
    private TSDataType dataType;
    private QueryContext context;
    private Filter timeFilter;
    private ClusterReaderFactory readerFactory;
    private boolean ascending;
    private List<GroupByExecutor> groupByExecutors;

    MergeGroupByExecutor(PartialPath path, Set<String> deviceMeasurements, TSDataType dataType, QueryContext context, Filter timeFilter, MetaGroupMember metaGroupMember, boolean ascending) {
        this.path = path;
        this.deviceMeasurements = deviceMeasurements;
        this.dataType = dataType;
        this.context = context;
        this.timeFilter = timeFilter;
        this.readerFactory = new ClusterReaderFactory(metaGroupMember);
        this.ascending = ascending;
    }

    public void addAggregateResult(AggregateResult aggrResult) {
        this.results.add(aggrResult);
        this.aggregationTypes.add(aggrResult.getAggregationType().ordinal());
    }

    private void resetAggregateResults() {
        for (AggregateResult result : this.results) {
            result.reset();
        }
    }

    public List<AggregateResult> calcResult(long curStartTime, long curEndTime) throws QueryProcessException, IOException {
        if (this.groupByExecutors == null) {
            this.initExecutors();
        }
        this.resetAggregateResults();
        for (GroupByExecutor groupByExecutor : this.groupByExecutors) {
            List subResults = groupByExecutor.calcResult(curStartTime, curEndTime);
            for (int i = 0; i < subResults.size(); ++i) {
                this.results.get(i).merge((AggregateResult)subResults.get(i));
            }
        }
        logger.debug("Aggregation result of {}@[{}, {}] is {}", new Object[]{this.path, curStartTime, curEndTime, this.results});
        return this.results;
    }

    public Pair<Long, Object> peekNextNotNullValue(long nextStartTime, long nextEndTime) throws IOException {
        if (this.groupByExecutors == null) {
            try {
                this.initExecutors();
            }
            catch (QueryProcessException e) {
                throw new IOException(e);
            }
        }
        Pair result = null;
        for (GroupByExecutor groupByExecutor : this.groupByExecutors) {
            Pair pair = groupByExecutor.peekNextNotNullValue(nextStartTime, nextEndTime);
            if (pair == null || result != null && (Long)result.left <= (Long)pair.left) continue;
            result = pair;
        }
        logger.debug("peekNextNotNullValue result of {}@[{}, {}] is {}", new Object[]{this.path, nextStartTime, nextEndTime, this.results});
        return result;
    }

    private void initExecutors() throws QueryProcessException {
        try {
            this.groupByExecutors = this.readerFactory.getGroupByExecutors(this.path, this.deviceMeasurements, this.dataType, this.context, this.timeFilter, this.aggregationTypes, this.ascending);
        }
        catch (StorageEngineException e) {
            throw new QueryProcessException((IoTDBException)e);
        }
    }
}

