/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.filter;

import java.util.List;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotTsFileFilter
implements TsFileFilter {
    private static final Logger logger = LoggerFactory.getLogger(SlotTsFileFilter.class);
    private List<Integer> slots;

    public SlotTsFileFilter(List<Integer> slots) {
        this.slots = slots;
    }

    public boolean fileNotSatisfy(TsFileResource resource) {
        return SlotTsFileFilter.fileNotInSlots(resource, this.slots);
    }

    private static boolean fileNotInSlots(TsFileResource resource, List<Integer> nodeSlots) {
        Pair sgNameAndPartitionIdPair = FilePathUtils.getLogicalSgNameAndTimePartitionIdPair((TsFileResource)resource);
        int slot = SlotPartitionTable.getSlotStrategy().calculateSlotByPartitionNum((String)sgNameAndPartitionIdPair.left, (Long)sgNameAndPartitionIdPair.right, 10000);
        boolean contained = nodeSlots.contains(slot);
        logger.debug("The slot of {} is {}, contained: {}", new Object[]{resource.getTsFile().getPath(), slot, contained});
        return !contained;
    }
}

