/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.fill;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.query.fill.ClusterLinearFill;
import org.apache.iotdb.cluster.query.fill.ClusterPreviousFill;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.FillQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ClusterFillExecutor
extends FillQueryExecutor {
    private MetaGroupMember metaGroupMember;

    public ClusterFillExecutor(List<PartialPath> selectedSeries, List<TSDataType> dataTypes, long queryTime, Map<TSDataType, IFill> typeIFillMap, MetaGroupMember metaGroupMember) {
        super(selectedSeries, dataTypes, queryTime, typeIFillMap);
        this.metaGroupMember = metaGroupMember;
    }

    protected IFill configureFill(IFill fill, PartialPath path, TSDataType dataType, long queryTime, Set<String> deviceMeasurements, QueryContext context) {
        if (fill instanceof LinearFill) {
            ClusterLinearFill clusterFill = new ClusterLinearFill((LinearFill)fill, this.metaGroupMember);
            clusterFill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
            return clusterFill;
        }
        if (fill instanceof PreviousFill) {
            ClusterPreviousFill clusterFill = new ClusterPreviousFill((PreviousFill)fill, this.metaGroupMember);
            clusterFill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
            return clusterFill;
        }
        return null;
    }
}

