/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.aggregate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.query.aggregate.ClusterAggregator;
import org.apache.iotdb.cluster.query.reader.ClusterReaderFactory;
import org.apache.iotdb.cluster.query.reader.ClusterTimeGenerator;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class ClusterAggregateExecutor
extends AggregationExecutor {
    private MetaGroupMember metaMember;
    private ClusterReaderFactory readerFactory;
    private ClusterAggregator aggregator;

    public ClusterAggregateExecutor(AggregationPlan aggregationPlan, MetaGroupMember metaMember) {
        super(aggregationPlan);
        this.metaMember = metaMember;
        this.readerFactory = new ClusterReaderFactory(metaMember);
        this.aggregator = new ClusterAggregator(metaMember);
    }

    protected void aggregateOneSeries(Map.Entry<PartialPath, List<Integer>> pathToAggrIndexes, AggregateResult[] aggregateResultList, Set<String> measurements, Filter timeFilter, QueryContext context) throws StorageEngineException {
        PartialPath seriesPath = pathToAggrIndexes.getKey();
        TSDataType tsDataType = (TSDataType)this.dataTypes.get(pathToAggrIndexes.getValue().get(0));
        ArrayList<String> aggregationNames = new ArrayList<String>();
        for (int i : pathToAggrIndexes.getValue()) {
            aggregationNames.add((String)this.aggregations.get(i));
        }
        List<AggregateResult> aggregateResult = this.aggregator.getAggregateResult(seriesPath, measurements, aggregationNames, tsDataType, timeFilter, context, this.ascending);
        int rstIndex = 0;
        for (int i : pathToAggrIndexes.getValue()) {
            aggregateResultList[i] = aggregateResult.get(rstIndex++);
        }
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan rawDataQueryPlan) throws StorageEngineException {
        return new ClusterTimeGenerator(context, this.metaMember, rawDataQueryPlan, false);
    }

    protected IReaderByTimestamp getReaderByTime(PartialPath path, RawDataQueryPlan dataQueryPlan, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return this.readerFactory.getReaderByTimestamp(path, dataQueryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, dataQueryPlan.isAscending());
    }
}

