/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.db.query.context.QueryContext;

public class RemoteQueryContext
extends QueryContext {
    private Map<Node, Set<Node>> queriedNodesMap = new HashMap<Node, Set<Node>>();
    private Set<Long> localReaderIds = new ConcurrentSkipListSet<Long>();
    private Set<Long> localGroupByExecutorIds = new ConcurrentSkipListSet<Long>();

    public RemoteQueryContext(long jobId) {
        super(jobId);
    }

    public RemoteQueryContext(long jobId, boolean debug) {
        super(jobId, debug);
    }

    public void registerRemoteNode(Node node, Node header) {
        this.queriedNodesMap.computeIfAbsent(header, n -> new HashSet()).add(node);
    }

    public void registerLocalReader(long readerId) {
        this.localReaderIds.add(readerId);
    }

    public void registerLocalGroupByExecutor(long executorId) {
        this.localGroupByExecutorIds.add(executorId);
    }

    public Set<Long> getLocalReaderIds() {
        return this.localReaderIds;
    }

    public Set<Long> getLocalGroupByExecutorIds() {
        return this.localGroupByExecutorIds;
    }

    public Map<Node, Set<Node>> getQueriedNodesMap() {
        return this.queriedNodesMap;
    }
}

