/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.cluster.exception.UnsupportedPlanException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.utils.PartitionUtils;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CountPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPlanRouter {
    private static final Logger logger = LoggerFactory.getLogger(ClusterPlanRouter.class);
    private PartitionTable partitionTable;

    public ClusterPlanRouter(PartitionTable partitionTable) {
        this.partitionTable = partitionTable;
    }

    private MManager getMManager() {
        return IoTDB.metaManager;
    }

    public PartitionGroup routePlan(PhysicalPlan plan) throws UnsupportedPlanException, MetadataException {
        if (plan instanceof InsertRowPlan) {
            return this.routePlan((InsertRowPlan)plan);
        }
        if (plan instanceof CreateTimeSeriesPlan) {
            return this.routePlan((CreateTimeSeriesPlan)plan);
        }
        if (plan instanceof ShowChildPathsPlan) {
            return this.routePlan((ShowChildPathsPlan)plan);
        }
        if (PartitionUtils.isLocalNonQueryPlan(plan)) {
            logger.error("{} is a local plan. Please run it locally directly", (Object)plan);
        } else if (PartitionUtils.isGlobalMetaPlan(plan) || PartitionUtils.isGlobalDataPlan(plan)) {
            logger.error("{} is a global plan. Please forward it to all partitionGroups", (Object)plan);
        }
        if (plan.canBeSplit()) {
            logger.error("{} can be split. Please call splitPlanAndMapToGroups", (Object)plan);
        }
        throw new UnsupportedPlanException(plan);
    }

    private PartitionGroup routePlan(InsertRowPlan plan) throws MetadataException {
        return this.partitionTable.partitionByPathTime(plan.getDeviceId(), plan.getTime());
    }

    private PartitionGroup routePlan(CreateTimeSeriesPlan plan) throws MetadataException {
        return this.partitionTable.partitionByPathTime(plan.getPath(), 0L);
    }

    private PartitionGroup routePlan(ShowChildPathsPlan plan) {
        try {
            return this.partitionTable.route(this.getMManager().getStorageGroupPath(plan.getPath()).getFullPath(), 0L);
        }
        catch (MetadataException e) {
            return this.partitionTable.getLocalGroups().get(0);
        }
    }

    public Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(PhysicalPlan plan) throws UnsupportedPlanException, MetadataException {
        if (plan instanceof InsertRowsPlan) {
            return this.splitAndRoutePlan((InsertRowsPlan)plan);
        }
        if (plan instanceof InsertTabletPlan) {
            return this.splitAndRoutePlan((InsertTabletPlan)plan);
        }
        if (plan instanceof InsertMultiTabletPlan) {
            return this.splitAndRoutePlan((InsertMultiTabletPlan)plan);
        }
        if (plan instanceof CountPlan) {
            return this.splitAndRoutePlan((CountPlan)plan);
        }
        if (plan instanceof CreateTimeSeriesPlan) {
            return this.splitAndRoutePlan((CreateTimeSeriesPlan)plan);
        }
        if (plan instanceof InsertRowPlan) {
            return this.splitAndRoutePlan((InsertRowPlan)plan);
        }
        if (plan instanceof AlterTimeSeriesPlan) {
            return this.splitAndRoutePlan((AlterTimeSeriesPlan)plan);
        }
        if (plan instanceof CreateMultiTimeSeriesPlan) {
            return this.splitAndRoutePlan((CreateMultiTimeSeriesPlan)plan);
        }
        if (PartitionUtils.isLocalNonQueryPlan(plan)) {
            logger.error("{} is a local plan. Please run it locally directly", (Object)plan);
        } else if (PartitionUtils.isGlobalMetaPlan(plan) || PartitionUtils.isGlobalDataPlan(plan)) {
            logger.error("{} is a global plan. Please forward it to all partitionGroups", (Object)plan);
        }
        if (!plan.canBeSplit()) {
            logger.error("{} cannot be split. Please call routePlan", (Object)plan);
        }
        throw new UnsupportedPlanException(plan);
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(InsertRowPlan plan) throws MetadataException {
        PartitionGroup partitionGroup = this.partitionTable.partitionByPathTime(plan.getDeviceId(), plan.getTime());
        return Collections.singletonMap(plan, partitionGroup);
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(AlterTimeSeriesPlan plan) throws MetadataException {
        PartitionGroup partitionGroup = this.partitionTable.partitionByPathTime(plan.getPath(), 0L);
        return Collections.singletonMap(plan, partitionGroup);
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(CreateTimeSeriesPlan plan) throws MetadataException {
        PartitionGroup partitionGroup = this.partitionTable.partitionByPathTime(plan.getPath(), 0L);
        return Collections.singletonMap(plan, partitionGroup);
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(InsertMultiTabletPlan plan) throws MetadataException {
        HashMap pgSgPathPlanMap = new HashMap();
        for (int i = 0; i < plan.getInsertTabletPlanList().size(); ++i) {
            InsertTabletPlan insertTabletPlan = (InsertTabletPlan)plan.getInsertTabletPlanList().get(i);
            Map<PhysicalPlan, PartitionGroup> tmpResult = this.splitAndRoutePlan(insertTabletPlan);
            for (Map.Entry<PhysicalPlan, PartitionGroup> entry : tmpResult.entrySet()) {
                InsertTabletPlan tmpPlan = (InsertTabletPlan)entry.getKey();
                PartitionGroup tmpPg = entry.getValue();
                PartialPath tmpSgPath = IoTDB.metaManager.getStorageGroupPath(tmpPlan.getDeviceId());
                HashMap<PartialPath, InsertMultiTabletPlan> sgPathPlanMap = (HashMap<PartialPath, InsertMultiTabletPlan>)pgSgPathPlanMap.get(tmpPg);
                if (sgPathPlanMap == null) {
                    ArrayList<InsertTabletPlan> insertTabletPlanList = new ArrayList<InsertTabletPlan>();
                    ArrayList<Integer> parentInsetTablePlanIndexList = new ArrayList<Integer>();
                    insertTabletPlanList.add(tmpPlan);
                    parentInsetTablePlanIndexList.add(i);
                    InsertMultiTabletPlan insertMultiTabletPlan = new InsertMultiTabletPlan(insertTabletPlanList, parentInsetTablePlanIndexList);
                    sgPathPlanMap = new HashMap<PartialPath, InsertMultiTabletPlan>();
                    sgPathPlanMap.put(tmpSgPath, insertMultiTabletPlan);
                    pgSgPathPlanMap.put(tmpPg, sgPathPlanMap);
                    continue;
                }
                InsertMultiTabletPlan insertMultiTabletPlan = (InsertMultiTabletPlan)sgPathPlanMap.get(tmpSgPath);
                if (insertMultiTabletPlan == null) {
                    ArrayList<InsertTabletPlan> insertTabletPlanList = new ArrayList<InsertTabletPlan>();
                    ArrayList<Integer> parentInsetTablePlanIndexList = new ArrayList<Integer>();
                    insertTabletPlanList.add(tmpPlan);
                    parentInsetTablePlanIndexList.add(i);
                    insertMultiTabletPlan = new InsertMultiTabletPlan(insertTabletPlanList, parentInsetTablePlanIndexList);
                    sgPathPlanMap.put(tmpSgPath, insertMultiTabletPlan);
                    continue;
                }
                insertMultiTabletPlan.addInsertTabletPlan(tmpPlan, Integer.valueOf(i));
            }
        }
        HashMap<PhysicalPlan, PartitionGroup> result = new HashMap<PhysicalPlan, PartitionGroup>(pgSgPathPlanMap.values().size());
        for (Map.Entry pgMapEntry : pgSgPathPlanMap.entrySet()) {
            PartitionGroup pg = (PartitionGroup)pgMapEntry.getKey();
            Map sgPathPlanMap = (Map)pgMapEntry.getValue();
            for (Map.Entry sgPathEntry : sgPathPlanMap.entrySet()) {
                result.put((PhysicalPlan)sgPathEntry.getValue(), pg);
            }
        }
        return result;
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(InsertRowsPlan insertRowsPlan) throws MetadataException {
        HashMap<PhysicalPlan, PartitionGroup> result = new HashMap<PhysicalPlan, PartitionGroup>();
        HashMap<PartitionGroup, InsertRowsPlan> groupPlanMap = new HashMap<PartitionGroup, InsertRowsPlan>();
        for (int i = 0; i < insertRowsPlan.getInsertRowPlanList().size(); ++i) {
            InsertRowsPlan tmpPlan;
            InsertRowPlan rowPlan = (InsertRowPlan)insertRowsPlan.getInsertRowPlanList().get(i);
            PartialPath storageGroup = this.getMManager().getStorageGroupPath(rowPlan.getDeviceId());
            PartitionGroup group = this.partitionTable.route(storageGroup.getFullPath(), rowPlan.getTime());
            if (groupPlanMap.containsKey(group)) {
                tmpPlan = (InsertRowsPlan)groupPlanMap.get(group);
                tmpPlan.addOneInsertRowPlan(rowPlan, i);
                continue;
            }
            tmpPlan = new InsertRowsPlan();
            tmpPlan.addOneInsertRowPlan(rowPlan, i);
            groupPlanMap.put(group, tmpPlan);
        }
        for (Map.Entry entry : groupPlanMap.entrySet()) {
            result.put((PhysicalPlan)entry.getValue(), (PartitionGroup)entry.getKey());
        }
        return result;
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(InsertTabletPlan plan) throws MetadataException {
        PartialPath storageGroup = this.getMManager().getStorageGroupPath(plan.getDeviceId());
        HashMap<PhysicalPlan, PartitionGroup> result = new HashMap<PhysicalPlan, PartitionGroup>();
        long[] times = plan.getTimes();
        if (times.length == 0) {
            return Collections.emptyMap();
        }
        long startTime = times[0] / StorageEngine.getTimePartitionInterval() * StorageEngine.getTimePartitionInterval();
        long endTime = startTime + StorageEngine.getTimePartitionInterval();
        int startLoc = 0;
        HashMap<PartitionGroup, List> splitMap = new HashMap<PartitionGroup, List>();
        for (int i = 1; i < times.length; ++i) {
            if (times[i] < endTime) continue;
            PartitionGroup group = this.partitionTable.route(storageGroup.getFullPath(), startTime);
            List ranges = splitMap.computeIfAbsent(group, x -> new ArrayList());
            ranges.add(startLoc);
            ranges.add(i);
            startLoc = i;
            startTime = endTime;
            endTime = (times[i] / StorageEngine.getTimePartitionInterval() + 1L) * StorageEngine.getTimePartitionInterval();
        }
        PartitionGroup group = this.partitionTable.route(storageGroup.getFullPath(), startTime);
        List ranges = splitMap.computeIfAbsent(group, x -> new ArrayList());
        ranges.add(startLoc);
        ranges.add(times.length);
        for (Map.Entry entry : splitMap.entrySet()) {
            List locs = (List)entry.getValue();
            int count = 0;
            for (int i = 0; i < locs.size(); i += 2) {
                int start = (Integer)locs.get(i);
                int end = (Integer)locs.get(i + 1);
                count += end - start;
            }
            long[] subTimes = new long[count];
            int destLoc = 0;
            Object[] values = this.initTabletValues(plan.getMeasurements().length, count, plan.getDataTypes());
            for (int i = 0; i < locs.size(); i += 2) {
                int start = (Integer)locs.get(i);
                int end = (Integer)locs.get(i + 1);
                System.arraycopy(plan.getTimes(), start, subTimes, destLoc, end - start);
                for (int k = 0; k < values.length; ++k) {
                    System.arraycopy(plan.getColumns()[k], start, values[k], destLoc, end - start);
                }
                destLoc += end - start;
            }
            InsertTabletPlan newBatch = PartitionUtils.copy(plan, subTimes, values);
            newBatch.setRange(locs);
            result.put((PhysicalPlan)newBatch, (PartitionGroup)entry.getKey());
        }
        return result;
    }

    private Object[] initTabletValues(int columnSize, int rowSize, TSDataType[] dataTypes) {
        Object[] values = new Object[columnSize];
        block8: for (int i = 0; i < values.length; ++i) {
            switch (dataTypes[i]) {
                case TEXT: {
                    values[i] = new Binary[rowSize];
                    continue block8;
                }
                case FLOAT: {
                    values[i] = new float[rowSize];
                    continue block8;
                }
                case INT32: {
                    values[i] = new int[rowSize];
                    continue block8;
                }
                case INT64: {
                    values[i] = new long[rowSize];
                    continue block8;
                }
                case DOUBLE: {
                    values[i] = new double[rowSize];
                    continue block8;
                }
                case BOOLEAN: {
                    values[i] = new boolean[rowSize];
                }
            }
        }
        return values;
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(CountPlan plan) throws StorageGroupNotSetException, IllegalPathException {
        Map sgPathMap = this.getMManager().determineStorageGroup(plan.getPath());
        if (sgPathMap.isEmpty()) {
            throw new StorageGroupNotSetException(plan.getPath().getFullPath());
        }
        HashMap<PhysicalPlan, PartitionGroup> result = new HashMap<PhysicalPlan, PartitionGroup>();
        if (plan.getShowContentType().equals((Object)ShowPlan.ShowContentType.COUNT_TIMESERIES)) {
            for (Map.Entry entry : sgPathMap.entrySet()) {
                CountPlan plan1 = new CountPlan(ShowPlan.ShowContentType.COUNT_TIMESERIES, new PartialPath((String)entry.getValue()), plan.getLevel());
                result.put((PhysicalPlan)plan1, this.partitionTable.route((String)entry.getKey(), 0L));
            }
        } else if (sgPathMap.size() == 1) {
            for (Map.Entry entry : sgPathMap.entrySet()) {
                result.put((PhysicalPlan)plan, this.partitionTable.route((String)entry.getKey(), 0L));
            }
        } else {
            for (Map.Entry entry : sgPathMap.entrySet()) {
                CountPlan plan1 = new CountPlan(ShowPlan.ShowContentType.COUNT_TIMESERIES, new PartialPath(((String)entry.getValue()).substring(0, ((String)entry.getValue()).lastIndexOf(".*"))), plan.getLevel());
                result.put((PhysicalPlan)plan1, this.partitionTable.route((String)entry.getKey(), 0L));
            }
        }
        return result;
    }

    private Map<PhysicalPlan, PartitionGroup> splitAndRoutePlan(CreateMultiTimeSeriesPlan plan) throws MetadataException {
        HashMap<PhysicalPlan, PartitionGroup> result = new HashMap<PhysicalPlan, PartitionGroup>();
        HashMap<PartitionGroup, CreateMultiTimeSeriesPlan> groupHoldPlan = new HashMap<PartitionGroup, CreateMultiTimeSeriesPlan>();
        for (int i = 0; i < plan.getPaths().size(); ++i) {
            CreateMultiTimeSeriesPlan subPlan;
            PartialPath path = (PartialPath)plan.getPaths().get(i);
            if (plan.getResults().containsKey(i)) continue;
            PartitionGroup partitionGroup = this.partitionTable.partitionByPathTime(path, 0L);
            if (groupHoldPlan.get(partitionGroup) == null) {
                subPlan = this.createSubPlan(plan);
                groupHoldPlan.put(partitionGroup, subPlan);
            } else {
                subPlan = (CreateMultiTimeSeriesPlan)groupHoldPlan.get(partitionGroup);
            }
            subPlan.getPaths().add(path);
            subPlan.getDataTypes().add((TSDataType)plan.getDataTypes().get(i));
            subPlan.getEncodings().add((TSEncoding)plan.getEncodings().get(i));
            subPlan.getCompressors().add((CompressionType)plan.getCompressors().get(i));
            if (plan.getAlias() != null) {
                subPlan.getAlias().add((String)plan.getAlias().get(i));
            }
            if (plan.getProps() != null) {
                subPlan.getProps().add((Map)plan.getProps().get(i));
            }
            if (plan.getTags() != null) {
                subPlan.getTags().add((Map)plan.getTags().get(i));
            }
            if (plan.getAttributes() != null) {
                subPlan.getAttributes().add((Map)plan.getAttributes().get(i));
            }
            subPlan.getIndexes().add(i);
        }
        for (Map.Entry entry : groupHoldPlan.entrySet()) {
            result.put((PhysicalPlan)entry.getValue(), (PartitionGroup)entry.getKey());
        }
        return result;
    }

    private CreateMultiTimeSeriesPlan createSubPlan(CreateMultiTimeSeriesPlan plan) {
        CreateMultiTimeSeriesPlan subPlan = new CreateMultiTimeSeriesPlan();
        subPlan.setPaths(new ArrayList());
        subPlan.setDataTypes(new ArrayList());
        subPlan.setEncodings(new ArrayList());
        subPlan.setCompressors(new ArrayList());
        if (plan.getAlias() != null) {
            subPlan.setAlias(new ArrayList());
        }
        if (plan.getProps() != null) {
            subPlan.setProps(new ArrayList());
        }
        if (plan.getTags() != null) {
            subPlan.setTags(new ArrayList());
        }
        if (plan.getAttributes() != null) {
            subPlan.setAttributes(new ArrayList());
        }
        subPlan.setIndexes(new ArrayList());
        return subPlan;
    }
}

